<?php

use Illuminate\Support\Facades\DB;

function getDatePreviouseThisMonth($day = "01")
{
    $currentDate = Carbon\Carbon::now();
    $year = $currentDate->year;
    $month = $currentDate->month;
    $stamp = sprintf('%s-%02s-' . $day, $year, $month);
    return $stamp;
}
function checkBalancePreviousMonth($table="tstktmatstockcard"){
    $stamp = getDatePreviouseThisMonth();
 
    $oldValueCurrentMonth = DB::table($table)
        ->where('xvstktype', '!=', '0')
        ->where('xistkqtyleft', '!=', '0')
        ->where('xdstkdate', '<', $stamp)
        ->get();
    $monthWithoutBalance = false;
    if (count($oldValueCurrentMonth) > 0) {
        $monthWithoutBalance = true;
    }
    return $monthWithoutBalance;
}


function condition_LCR($model, $column,$isAll=false, $start=null, $end=null){
    if($isAll){
        $model = $model->get();
    }elseif ($start != null && $end != null){
        $model = $model
            ->whereBetween($column, [$start,$end])
            ->get();
    }else if($start != null){
        $model = $model
            ->where($column, $start)
            ->get();
    }else if($end != null){
        $model = $model
            ->where($column, $end)
            ->get();
    }else{
        $model = [];
    }
    return $model;
}
function condition_LCRVOutide($model, $column,$isAll=false, $start=null, $end=null){
    if($isAll){
        return $model;
    }elseif ($start != null && $end != null){
        $model = $model
            ->whereBetween($column, [$start,$end]);

    }else if($start != null){
        $model = $model
            ->where($column, $start);
    }else if($end != null){
        $model = $model
            ->where($column, $end);
    }
    return $model;
}
function divnum($numerator, $denominator)
{
    return $denominator == 0 ? 0 : ($numerator / $denominator);
}

function date_YmdTodmY($date){
    return Carbon\Carbon::createFromFormat('Y-m-d',$date)->format('d-m-Y');
}
function dateToday($fotmat = 'd-m-Y'){
    return Carbon\Carbon::now()->format($fotmat);
}
function GeneratePrimaryKey($table, $primaryKey, $prefix,$offset=  -3)
{
    $spl = Illuminate\Support\Facades\DB::table($table)->orderBy($primaryKey, 'DESC')->select($primaryKey)->first();

    if ($spl == null) {
        $num = 1;
    } else {
        $num = substr($spl->$primaryKey, $offset) + 1;
    }
//    dd($spl->$primaryKey);
//    dd($num);
    $splId = sprintf($prefix . '-' . '%03d', $num);
    return $splId;
}
function GeneratePrimaryKeyDate($table, $primaryKey, $prefix,$offset =  3,$onlyNumber = false)
{
    $spl = Illuminate\Support\Facades\DB::table($table)
        ->orderBy($primaryKey, 'DESC')
        ->select($primaryKey)
        ->first();
        
    $stamp = twoprefixYearMonth();

    if ($spl == null) {
        $num = 1;
    } 
  
    else {
        $lastRowYearMonth = substr($spl->$primaryKey, $offset,4);
        
        if($lastRowYearMonth == $stamp){
          
            $num = substr($spl->$primaryKey, -6) + 1;
        }else{
            $num =1;
        }
    }
    if($onlyNumber){
        return $num;
    }else{
        $splId = sprintf($prefix.$stamp . '-' . '%06d', $num);
        return $splId;
    }
}
function getTempPKGen($prefix){
    $stamp = twoprefixYearMonth();
    return $prefix.$stamp . '-######';

}
function GeneratePrimaryKeyDateExtra($table, $primaryKey, $prefix,$offset =  3,$onlyNumber = false,$field,$letter)
{
    $spl = Illuminate\Support\Facades\DB::table($table)
        ->orderBy($primaryKey, 'DESC')
        ->where($field, 'LIKE', $letter.'%')
        ->select($primaryKey)
        ->first();
    $stamp = twoprefixYearMonth();

    if ($spl == null) {
        $num = 1;
    } else {
        $lastRowYearMonth = substr($spl->$primaryKey, $offset,4);
        if($lastRowYearMonth == $stamp){
            $num = substr($spl->$primaryKey, -6) + 1;
        }else{
            $num =1;
        }
    }
    if($onlyNumber){
        return $num;
    }else{
        $splId = sprintf($prefix.$stamp . '-' . '%06d', $num);
        return $splId;
    }
}
function createDocNo($prefix,$stamp,$num){
    $splId = sprintf($prefix.$stamp . '-' . '%06d', $num);
    return $splId;
}

function twoprefixYearMonth(){
    $dateCarbon = Carbon\Carbon::now();
    $year = $dateCarbon->year;
    $year = substr($year,2);
    $month = $dateCarbon->month;
    $stamp = sprintf('%s%02s', $year, $month);
    return $stamp;
}
function getDocStatusByCode($code)
{
    switch ($code) {
        case '1' :
            return "บันทึก";
            break;
        case '2' :
            return "ขออนุมัติ";
            break;
        case '3' :
            return "อนุมัติ";
            break;
        case '4' :
            return "ขอแก้ไข";
            break;
        case '5' :
            return "ยกเลิก";
        case '6' :
            return "ยกเลิกการใช้งาน";
            break;
        default :
            return " ";
            break;
    }
}

function getCssDocStatusByCode($code)
{
    switch ($code) {
        case '1' :
            return "primary";
            break;
        case '2' :
            return "info";
            break;
        case '3' :
            return "success";
            break;
        case '4' :
            return "warning";
            break;
        case '5' :
            return "danger";
        case '6' :
            return "danger";
            break;
        default :
            return " ";
            break;
    }
}
function getTextStockCardByCode($code)
{
    switch ($code) {
        case '0' :
            return "ยอดยกมา";
            break;
        case '1' :
            return "รับเข้า";
            break;
        case '2' :
            return "เบิกออก";
            break;
        case '3' :
            return "ขาย";
            break;
        case '4' :
            return "คืน";
        case '5' :
            return "ปรับปรุง ( เพิ่ม )";
            break;
        case '6' :
            return "ปรับปรุง ( ลบ )";
            break;
        default :
            return " ";
            break;
    }
}

function canItBeSave($code)
{
    switch ($code) {
        case '1':
        case '4' :
            return true;
        case '2':
        case '3':
        case '5' :
        case '6' :
            return false;
    }
}

function canItBe_Approve_RequestChange($code)
{
    switch ($code) {
        case '2':
        case '1' :  // only work at VK garment becuz they does't want Waiting TO Approve
        return true;
        case '3':
        case '4':
        case '5' :
        case '6' :
            return false;
    }
}

function canItBe_Cancle($code)
{
    switch ($code) {
        case '1':
        case '2' :
        case '4':
            return true;
        case '3':
        case '5' :
            return false;
    }
}
function canItBe_Expire($code)
{
    switch ($code) {
        case '3':
            return true;
        default:
            return false;
    }
}
function getNumberStatus($code){
    $arr = [];
    switch ($code) {
        case '1' :
            $arr = [1,2,5];
            break;
        case '2' :
            $arr = [3,4,5];
            break;
        case '4' :
            $arr = [2,5];
    }
    return $arr;
}
