<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class MasterItemBomSizeController extends Controller
{
    public function index($xvpdtcode,$XVPszName)
    {
        $hd = DB::table('tmstmproduct')->where('xvpdtcode', '=', $xvpdtcode)->first();
        $dt = $this->getRecepie($xvpdtcode,$XVPszName);
        foreach($dt as $item){
            $item->unitType = DB::table('tmstmmat_unit')
                ->where('xvmatcode','=',$item->xvmatcode)
                ->leftjoin('tmstmunit', 'tmstmunit.xvuntcode', 'tmstmmat_unit.xvuntcode')
                ->get()->toArray();
        }
        return view('MasterItemBomSize.frm_edit', [
            'hd' => $hd,
            'dt' => $dt,
            'XVPszName'=>$XVPszName
        ]);
    }
    public function Update(Request $request)
    {
        try {
            $code = $request->xvpdtcode;
            $size = $request->XVPszName;
            DB::beginTransaction();
            DB::table('tmstmbomsize')
                ->where('xvpdtcode','=',$code)
                ->where('XVPszName','=',$size)
                ->delete();
            for ($i = 0; $i < count($request->xvmatcode); $i++) {
                DB::table('tmstmbomsize')->insert([
                    'xvpdtcode' => $code,
                    'XVPszName' => $size,
                    'xvmatcode' => $request->xvmatcode[$i],
                    'xvuntcode' => $request->xvuntcode[$i],
                    'XIBomQty' => $request->XIBomQty[$i],
                ]);
            }
            DB::commit();
            return redirect()->back();
        } catch (\Exception $e) {
            DB::rollback();
            if($e->getCode()==="23000"){
                return redirect()->back()->with('msg', 'Duplicate');
            }
            dd($e);
            abort(500, 'Internal error');
        }
    }
    public function getRecepie($pdtCode,$sizeCode){
        $item = DB::table('tmstmbomsize')
            ->where('xvpdtcode', '=', $pdtCode)
            ->where('XVPszName', '=', $sizeCode)
            ->join('TMstMMaterial','tmstmbomsize.xvmatcode','TMstMMaterial.xvmatcode')
            ->leftjoin('tmstmunit','tmstmbomsize.xvuntcode','tmstmunit.xvuntcode')
            ->get();
        if(count($item) <= 0 ){
            $item = DB::table('tmstmbom')
                ->where('xvpdtcode', '=', $pdtCode)
                ->join('TMstMMaterial','tmstmbom.xvmatcode','TMstMMaterial.xvmatcode')
                ->leftjoin('tmstmunit','tmstmbom.xvuntcode','tmstmunit.xvuntcode')
                ->get();
        }
        return $item;
    }
}
