<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Helper\Helper;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Session;

class POController extends Controller
{
    public function index()
    {
        $roleperm = Session::get('role_perm') ?? [];
      
        if (in_array(20,$roleperm))
        {
           
            $HD = DB::table('TDocTPoHD')
            ->where('XVPohDocStatus', '=', '2')
            ->orWhere('XVPohDocStatus', '=', '3')
            ->leftjoin('tmstmsupplier', 'TDocTPoHD.XVSplCode', 'tmstmsupplier.XVSplCode')
            ->orderBy('XVPohDocNo', 'DESC')
            ->get();
        }
         else {
            $HD = DB::table('TDocTPoHD')
            ->leftjoin('tmstmsupplier', 'TDocTPoHD.XVSplCode', 'tmstmsupplier.XVSplCode')
            ->orderBy('XVPohDocNo', 'DESC')
            ->get();
         }
       
        $data = [
            'HD' => $HD,
        ];
        // dd($data);
        return view('Po.index', $data);
    }
    public function Approveindex()
    {
        $HD = DB::table('TDocTPoHD')
            ->leftjoin('tmstmsupplier', 'TDocTPoHD.XVSplCode', 'tmstmsupplier.XVSplCode')
            ->orderBy('XVPohDocNo', 'DESC')
            ->Where ('XVPohDocStatus','2')
            ->get();
        $data = [
            'HD' => $HD,
        ];
        return view('Po.index', $data);
    }
    public function FormInsert()
    {
        return view('Po.frm_add');
    }

    public function FormEdit($XVPohDocNo)
    {
        $oldHD = DB::table('TDocTPoHD')
            ->where('XVPohDocNo', '=', $XVPohDocNo)->first();
        $oldDT = DB::table('TDocTPoDT')
            ->where('XVPohDocNo', '=', $XVPohDocNo)
            ->leftjoin('TMstMMaterial', 'TDocTPoDT.xvmatcode', 'TMstMMaterial.xvmatcode')
            ->leftjoin('tmstmunit', 'TDocTPoDT.xvuntcode', 'tmstmunit.xvuntcode')
            ->get();
        $dataSend = [
            'hd' => $oldHD,
            'dt' => $oldDT,
            'DocStatus' => $oldHD->XVPohDocStatus
        ];
        return view('Po.frm_edit', $dataSend);
    }

    public function Store(Request $request)
    {
        if (isset($request->ImgResize)) {
            $imageName = time() . '.' . $request->ImgResize->extension();
        } else {
            $imageName = "not-found.jpg";
        }
        $XDPohDocDate = Carbon::createFromFormat('d-m-Y', $request->XDPohDocDate);
//        $XDPohDocDateReceive = Carbon::createFromFormat('d-m-Y', $request->XDPohDocDateReceive);
        try {
            DB::beginTransaction();
            $docNo = GeneratePrimaryKeyDate('TDocTPoHD', 'XVPohDocNo', 'PO',2);
            DB::table('TDocTPoHD')->insert([
                'XVPohDocNo' => $docNo,
                'XVSplCode' => $request->XVSplCode,
                'XDPohDocDate' => $XDPohDocDate->format('Y-m-d'),
                'XVPohDocStatus' => '1',
                'XVPohDocRmk' => $request->XVPohDocRmk,
//                'XDPohDocDateReceive' => $XDPohDocDateReceive->format('Y-m-d'),
                'XVPohBillDays' => $request->XVPohBillDays,
                'XBPohTaxType' => $request->XBPohTaxType,
                'XIPohAmount' => $request->XIPohAmount,
                'XFPohTotal' => $request->XFPohTotal,
                'XFBillDiscount' => $request->XFBillDiscount,
                'XFPohAfterBillDC' => $request->XFPohAfterBillDC,
                'XBPohIsTax' => isset($request->XBPohIsTax),
                'XIPohTax' => $request->XIPohTax,
                'XFPohTotalVat' => $request->XFPohTotalVat,
                'XFPohNet' => $request->XFPohNet,
                'XFPohBeforeVat' => $request->XFPohBeforeVat,
                'XVPohDeliveryPlace' => $request->XVPohDeliveryPlace,
                'XVPohRefNo' => $request->XVPohRefNo,
//                New Requried Image
                'XVPohImg' => "images/" . $imageName,

            ]);
            for ($i = 0; $i < count($request->xvmatcode); $i++) {
                $itemFactor = DB::table('tmstmmat_unit')
                    ->where('xvmatcode','=',$request->xvmatcode[$i])
                    ->where('tmstmmat_unit.xvuntcode','=',$request->XVMatUnit_Name[$i])
                    ->leftJoin('tmstmunit','tmstmmat_unit.xvuntcode','tmstmunit.xvuntcode')
                    ->first();
                $initRcv = 0 ;
                $qtyStk = $request->XIPodQty[$i] * $itemFactor->ximunfactor;
                DB::table('TDocTPoDT')->insert([
                    'XVPohDocNo' => $docNo,
                    'xvmatcode' => $request->xvmatcode[$i],
                    'XVPodName' => $request->XVPodName[$i],
                    'xvuntcode' => $request->XVMatUnit_Name[$i],
                    'XVPodUnitName' => $itemFactor->xvuntname,
                    'XIPodFactor'=>$itemFactor->ximunfactor,
                    'XIPodQty' => $request->XIPodQty[$i],
                    'XIPodQtyRcv' => $initRcv,
                    'XIPodQtyLeft' => $request->XIPodQty[$i] - $initRcv ,
                    'XIPodQtyStk' => $qtyStk,
                    'XFPodUnitCost' => $request->XFPodUnitCost[$i],
                    'XFPodDiscount' => $request->XFPodDiscount[$i],
                    'XFPodCostTotal' => $request->XFPodCostTotal[$i] ,
                    'XFPodCostAvg' => $request->XFPodCostTotal[$i] / $qtyStk ,
                ]);
            }
            if (isset($request->ImgResize)) {
                $request->ImgResize->move(public_path('images'), $imageName);
            }
            DB::commit();
            return redirect()->route('po.edit', ['XVPohDocNo' => $docNo])->with('msg', 'success');

        } catch (\Exception $e) {
            DB::rollback();
            dd($e);
            abort(500, 'Internal error');
        }
    }

    public function Update(Request $request)
    {
        $XDPohDocDate = Carbon::createFromFormat('d-m-Y', $request->XDPohDocDate);
//        $XDPohDocDateReceive = Carbon::createFromFormat('d-m-Y', $request->XDPohDocDateReceive);
        try {
            $isUploadNew = false;
            if (isset($request->ImgResize)) {
                $isUploadNew = true;
                $imageName = time() . '.' . $request->ImgResize->extension();
            } else {
                $imageName = $request->oldImg;
            }

            DB::beginTransaction();
            $docNo = $request->XVPohDocNo;
            DB::table('TDocTPoHD')
                ->where('XVPohDocNo', '=', $docNo)
                ->update([
                    'XVSplCode' => $request->XVSplCode,
                    'XDPohDocDate' => $XDPohDocDate->format('Y-m-d'),
                    'XVPohDocRmk' => $request->XVPohDocRmk,
//                    'XDPohDocDateReceive' => $XDPohDocDateReceive->format('Y-m-d'),
                    'XVPohBillDays' => $request->XVPohBillDays,
                    'XBPohTaxType' => $request->XBPohTaxType,
                    'XIPohAmount' => $request->XIPohAmount,
                    'XFPohTotal' => $request->XFPohTotal,
                    'XFBillDiscount' => $request->XFBillDiscount,
                    'XFPohAfterBillDC' => $request->XFPohAfterBillDC,
                    'XBPohIsTax' => isset($request->XBPohIsTax),
                    'XIPohTax' => $request->XIPohTax,
                    'XFPohTotalVat' => $request->XFPohTotalVat,
                    'XFPohNet' => $request->XFPohNet,
                    'XFPohBeforeVat' => $request->XFPohBeforeVat,
                    'XVPohRefNo' => $request->XVPohRefNo,
                    'XVPohDeliveryPlace' => $request->XVPohDeliveryPlace,
                    //                New Requried Image
                    'XVPohImg' => $isUploadNew ? "images/" . $imageName : $imageName,
                ]);
            DB::table('TDocTPoDT')
                ->where('XVPohDocNo', '=', $docNo)
                ->delete();
            for ($i = 0; $i < count($request->xvmatcode); $i++) {
                $itemFactor = DB::table('tmstmmat_unit')
                    ->where('xvmatcode','=',$request->xvmatcode[$i])
                    ->where('tmstmmat_unit.xvuntcode','=',$request->XVMatUnit_Name[$i])
                    ->leftJoin('tmstmunit','tmstmmat_unit.xvuntcode','tmstmunit.xvuntcode')
                    ->first();
                $initRcv = 0 ;
                $qtyStk = $request->XIPodQty[$i] * $itemFactor->ximunfactor;
                DB::table('TDocTPoDT')->insert([
                    'XVPohDocNo' => $docNo,
                    'xvmatcode' => $request->xvmatcode[$i],
                    'XVPodName' => $request->XVPodName[$i],
                    'xvuntcode' => $request->XVMatUnit_Name[$i],
                    'XVPodUnitName' => $itemFactor->xvuntname,
                    'XIPodFactor'=>$itemFactor->ximunfactor,
                    'XIPodQty' => $request->XIPodQty[$i],
                    'XIPodQtyRcv' => $initRcv,
                    'XIPodQtyLeft' => $request->XIPodQty[$i] - $initRcv ,
                    'XIPodQtyStk' => $qtyStk,
                    'XFPodUnitCost' => $request->XFPodUnitCost[$i],
                    'XFPodDiscount' => $request->XFPodDiscount[$i],
                    'XFPodCostTotal' => $request->XFPodCostTotal[$i] ,
                    'XFPodCostAvg' => $request->XFPodCostTotal[$i] / $qtyStk ,
                ]);
            }

            if ($isUploadNew) {
                $request->ImgResize->move(public_path('images'), $imageName);
//                if (File::exists(public_path($request->oldImg))) {
//                    File::delete(public_path($request->oldImg));
//                }
            }
            DB::commit();
            return redirect()->back();
//            return redirect()->route('Po.index')->with('msg', 'success');

        } catch (\Exception $e) {
            DB::rollback();
            dd($e);
            abort(500, 'Internal error');
        }
    }

    public function ChangeStatus(Request $request)
    {
        $docNo = $request->XVPohDocNo;
        $requestChange = $request->eventRequest;
        $TDocTPoHD = DB::table('TDocTPoHD')
            ->where('XVPohDocNo', '=', $docNo)
            ->first();
        $DocStatus = $TDocTPoHD->XVPohDocStatus;
        switch ($requestChange) {
            case '2' : // Ask for Approve
                if (canItBeSave($DocStatus)) {
                    $this->UpdateStatus($docNo, $requestChange);
                } else {
                    // Can't Update Status Because DocStatus Isn't 1 or 4
                    // Do Someting
                }
                break;
            case '3' :  // Approve
                if (canItBe_Approve_RequestChange($DocStatus)) {
                    $this->UpdateStatus($docNo, $requestChange);
                } else {
                    // Can't Update Status Because DocStatus Isn't 2
                    // Do Someting
                }
                break;
            case '4' : // Requeste Change
                if (canItBe_Approve_RequestChange($DocStatus)) {
                    $this->UpdateStatus($docNo, $requestChange);
                } else {
                    // Can't Update Status Because DocStatus Isn't 2
                    // Do Someting
                }
                break;
            case '5' :
                if (canItBe_Cancle($DocStatus)) {
                    $this->UpdateStatus($docNo, $requestChange);
                } else {
                    // Can't Update Status Because DocStatus Isn't ( 1 , 2 , 4)
                    // Do Someting
                }
            case '6' :
                if (canItBe_Expire($DocStatus)) {
                    $this->UpdateStatus($docNo, $requestChange);
                } else {
                    // Can't Update Status Because DocStatus Isn't ( 3)
                    // Do Someting
                }
                break;
        }
        return redirect()->back();
    }

    public function UpdateStatus($docNo, $docStatus)
    {
        DB::table('TDocTPoHD')
            ->where('XVPohDocNo', '=', $docNo)
            ->update([
                'XVPohDocStatus' => $docStatus
            ]);
    }

    public function getOldDataByDocNO($docNo)
    {
        $oldHD = DB::table('TDocTPoHD')
            ->where('XVPohDocNo', '=', $docNo)
            ->join('tmstmsupplier', 'TDocTPoHD.XVSplCode', 'tmstmsupplier.XVSplCode')
            ->first();
        $oldDT = DB::table('TDocTPoDT')
            ->where('XVPohDocNo', '=', $docNo)
            ->leftjoin('TMstMMaterial', 'TDocTPoDT.xvmatcode', 'TMstMMaterial.xvmatcode')
            ->leftjoin('tmstmunit', 'TDocTPoDT.xvuntcode', 'tmstmunit.xvuntcode')
            ->get();
        $dataSend = [
            'hd' => $oldHD,
            'dt' => $oldDT,
        ];
        return response()->json($dataSend);

    }
}
