<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ProductController extends Controller
{
    //
    public function index()
    {
        $product = DB::table('tmstmproduct')
            ->get();
        foreach ($product as $item) {
            $arr = DB::table('tmstmproductsize')
                ->where('xvpdtcode', '=', $item->xvpdtcode)
                ->pluck('XVPszName');
            $item->Size = $arr;
        }

        $data = [
            'products' => $product,
        ];
        return view('product.index', $data);
    }

    public function FormInsert()
    {
        return view('product.frm_add');
    }

    public function FormEdit($id)
    {
        $product = DB::table('tmstmproduct')
            ->where('xvpdtcode', '=', $id)
            ->first();
        if (!$product) {
            return redirect()->route('product.index')->with('msg', 'error_notfound');
        }
        $arr = DB::table('tmstmproductsize')
            ->where('xvpdtcode', '=', $product->xvpdtcode)
            ->pluck('XVPszName');
        $product->Size = $arr;

        $data = [
            'product' => $product,
        ];
        return view('product.frm_edit', $data);
    }
    public function Store(Request $request)
    {
        try {
            DB::beginTransaction();
            $code = GeneratePrimaryKeyDate('tmstmproduct','xvpdtcode','Pdt');
            DB::table('tmstmproduct')->insert([
                'xvpdtcode' => $code,
                'xvpdtname' => $request->xvpdtname,
            ]);
            for ($i = 0; $i < count($request->XVPszName); $i++) {
                DB::table('tmstmproductsize')->insert([
                    'xvpdtcode' => $code,
                    'XVPszName' => $request->XVPszName[$i],
                ]);
            }
            DB::commit();
            return redirect()->route('product.index')->with('msg', 'success');

        } catch (\Exception $e) {
            DB::rollback();
            abort(500, 'Internal error');
        }
    }

    public function Update(Request $request)
    {
        try {
            DB::beginTransaction();
            $code = $request->xvpdtcode;
            DB::table('tmstmproduct')
                ->where('xvpdtcode', '=', $code)
                ->update([
                    'xvpdtname' => $request->xvpdtname,
                ]);
            DB::table('tmstmproductsize')->where('xvpdtcode', '=', $code)->delete();
            for ($i = 0; $i < count($request->XVPszName); $i++) {
                DB::table('tmstmproductsize')->insert([
                    'xvpdtcode' => $code,
                    'XVPszName' => $request->XVPszName[$i],
                ]);
            }
            DB::commit();
            return redirect()->route('product.index')->with('msg', 'success');

        } catch (\Exception $e) {
            DB::rollback();
            abort(500, 'Internal error');
        }
    }

    public function Delete($id)
    {
//        dd("delete");
        try {
            DB::beginTransaction();
            $code = $id;
            DB::table('tmstmproduct')
                ->where('xvpdtcode', '=', $code)
                ->delete();
            DB::table('tmstmproductsize')->where('xvpdtcode', '=', $code)->delete();
            DB::commit();
            return redirect()->route('product.index')->with('msg', 'success');
        } catch (\Exception $e) {
            DB::rollback();
            abort(500, 'Internal error');
        }
    }

}
