<?php

namespace App\Http\Controllers\Report;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class Report101Controller extends Controller
{
    public function index()
    {
        return view('Report/index101');
    }

    public function data(Request $request)
    {
        //        Section Data
        $DateStart = $request->input('DateStart');
        $DateEnd = $request->input('DateEnd');
        $isAllTime = $request->input("isAllTime") === 'true' ? true : false;
        $XVSplCodeStart = $request->input('XVSplCodeStart');
        $XVSplCodeEnd = $request->input('XVSplCodeEnd');
        $isAllSpl = $request->input("isAllSpl") === 'true' ? true : false;
        //        Section Data

        $customer = DB::table('tmstmcustomer');
        $customer = condition_LCR($customer, 'XVCstCode', $isAllSpl, $XVSplCodeStart, $XVSplCodeEnd);
        foreach ($customer as $item) {
            $OrderHD = DB::table('TDocTOrHD')
                ->where('XVOrhDocStatus', '=', '3')
                ->where('XVCstCode', '=', $item->XVCstCode);
            $OrderHD = condition_LCR($OrderHD, 'XDOrhDocDate', $isAllTime, $DateStart, $DateEnd);
            if (count($OrderHD) > 0) {
                $item->OrderHD = $OrderHD;
                foreach ($item->OrderHD as $itemSecond) {
                    $OrderDT = DB::table('TDocTOrDT')
                        ->where('XVOrhDocNo', '=', $itemSecond->XVOrhDocNo);

                    $itemSecond->OrderDT = $OrderDT
                        ->leftJoin('tmstmproduct', 'TDocTOrDT.xvpdtcode', '=', 'tmstmproduct.xvpdtcode')
                        ->get();;
                    $SumQty = $OrderDT
                        ->select(DB::raw('SUM(XIOrdQty) as SumQty'))
                        ->first();
                    $itemSecond->SumQty = $SumQty->SumQty;
                }
            } else {
                $item->OrderHD = [];
            }
        }
        return response()->json($customer);
    }
    public function datexcel(Request $request)
    {
        $DateStart = $request->input('DateStart');
        $DateEnd = $request->input('DateEnd');
        $isAllTime = $request->input("isAllTime") === 'true' ? true : false;
        $XVSplCodeStart = $request->input('XVSplCodeStart');
        $XVSplCodeEnd = $request->input('XVSplCodeEnd');
        $isAllSpl = $request->input("isAllSpl") === 'true' ? true : false;
        $customer = DB::table('TDocTOrDT');
        $customer ->join('TDocTOrHD','TDocTOrDT.XVOrhDocNo', '=', 'TDocTOrHD.XVOrhDocNo');
        $customer ->join('tmstmcustomer','TDocTOrHD.XVCstCode', '=', 'tmstmcustomer.XVCstCode');
        $customer ->Join('tmstmproduct', 'TDocTOrDT.xvpdtcode', '=', 'tmstmproduct.xvpdtcode')
                  ->orderBy('TDocTOrHD.XVCstCode');

        $customer = condition_LCRVOutide($customer, 'TDocTOrHD.XVCstCode', $isAllSpl,$XVSplCodeStart,  $XVSplCodeEnd);
        $customer =  condition_LCR($customer, 'XDOrhDocDate', $isAllTime, $DateStart, $DateEnd);
        if($customer== null)
        {
            $customer=[];
            return response()->json($customer );
        }
        else
        {
            return response()->json($customer );
        }
    }
}
