<?php

namespace App\Http\Controllers\Report;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class Report304Controller extends Controller
{
    //
    public function index()
    {
        return view('Report/index304');
    }
    public function data(Request $request)
    {
        //        Section Data
        $DateStart = $request->input('DateStart');
        $DateEnd = $request->input('DateEnd');
        $isAllTime = $request->input("isAllTime") === 'true' ? true : false;
        $MatStart = $request->input('MatStart');
        $MatEnd = $request->input('MatEnd');
        $isAllMat = $request->input("isAllMat") === 'true' ? true : false;
        //        Section Data
        $material = DB::table('tmstmmaterial');
        $material = condition_LCR($material, 'xvmatcode', $isAllMat, $MatStart, $MatEnd);
        foreach ($material as $item) {
            $OrderHD =DB::table('tstktmatstockcard')
                ->orderBy('id', 'asc')
                ->where('xvmatcode', '=', $item->xvmatcode);
            $OrderHD = condition_LCR($OrderHD, 'xdstkdate', $isAllTime, $DateStart, $DateEnd);
            if (count($OrderHD) > 0) {
                $item->OrderHD = $OrderHD;
            } else {
                $item->OrderHD = [];
            }
        }
        return response()->json($material);
    }
    public function datexcel(Request $request)
    {
        //        Section Data
        $DateStart = $request->input('DateStart');
        $DateEnd = $request->input('DateEnd');
        $isAllTime = $request->input("isAllTime") === 'true' ? true : false;
        $MatStart = $request->input('MatStart');
        $MatEnd = $request->input('MatEnd');
        $isAllMat = $request->input("isAllMat") === 'true' ? true : false;
        //        Section Data
        $material =DB::table('tstktmatstockcard')
                    ->join('tmstmmaterial','tmstmmaterial.xvmatcode','tstktmatstockcard.xvmatcode')
                    ->orderBy('tstktmatstockcard.xvmatcode', 'asc')
                    ->orderBy('id', 'asc');
        $material = condition_LCRVOutide($material, 'tstktmatstockcard.xvmatcode', $isAllMat, $MatStart, $MatEnd);
        $material = condition_LCR($material, 'tstktmatstockcard.xdstkdate', $isAllTime, $DateStart, $DateEnd);
        return response()->json($material);
    }
}
