<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class StockCardController extends Controller
{
    public function index(Request $request)
    {
        $HD = DB::table('tstktmatstockcard')
            ->leftJoin('tmstmmaterial', 'tstktmatstockcard.xvmatcode', '=', 'tmstmmaterial.xvmatcode');
        if (isset($request->xvmatcode) && $request->xvmatcode != null) {
            $HD = $HD
                ->orderBy('id', 'asc')
                ->where('tstktmatstockcard.xvmatcode', '=', $request->xvmatcode);
        } else {
            $HD = $HD
                ->orderBy('id', 'desc');
        }
        if (isset($request->DateStart) && isset($request->DateEnd)) {
            $HD = condition_LCRVOutide($HD, 'xdstkdate', false, $request->DateStart, $request->DateEnd);
        }
        $HD = $HD->get();
        $monthWithoutBalance = checkBalancePreviousMonth();
        $HDMat = DB::table('tmstmmaterial')
            ->orderBy('xvmatcode', 'DESC')
            ->get();
        $data = [
            'HD' => $HD,
            'HDMat' => $HDMat,
            'monthWithoutBalance' => $monthWithoutBalance,
            'xvmatcode' => $request->xvmatcode ?? null,
            'DateStart' => $request->DateStart ?? null,
            'DateEnd' => $request->DateEnd ?? null,
        ];
        return view('Stockcard.index', $data);
    }

    public function Balance(Request $request)
    {
        try {
            DB::beginTransaction();

            $start = new Carbon('first day of last month');
            $end = new Carbon('last day of last month');
            $today = new Carbon('first day of this month');
            $startPrevious = $start->format('Y-m-d');
            $endPrevious = $end->format('Y-m-d');
            $todayME = $today->format('Y-m-d');
            $prefix = twoprefixYearMonth();
            $docNo = "ME" . $prefix;
//                                        INSERT INTO tstktmatstockcard(xvstkdocno,xvmatcode,xvstktype,xistkqty,xistkqtyuse,xistkqtyleft,xfstkcost,xdstkdate)
            $sql = "
                                        SELECT  '$docNo' AS xvstkdocno,xvmatcode,'0' AS xvstktype,SUM(xistkqtyleft) AS xistkqty,0 AS xistkqtyuse,SUM(xistkqtyleft) AS xistkqtyleft
                                        ,CASE  WHEN SUM(xistkqtyleft)>0 THEN SUM((xistkqtyleft*xfstkcost))/SUM(xistkqtyleft)
                                         WHEN SUM(xistkqtyleft)=0 THEN 0
                                         WHEN SUM(xistkqtyleft)<0 THEN ABS(SUM((xistkqtyleft*xfstkcost))/SUM(xistkqtyleft))
                                        END AS xfstkcost
                                        ,'$todayME' as xdstkdate
                                        FROM tstktmatstockcard
                                        WHERE xdstkdate BETWEEN '$startPrevious' AND '$endPrevious'
                                        GROUP BY xvmatcode";

            $query = DB::select($sql);
            foreach ($query as $item) {
                DB::table('tstktmatstockcard')
                    ->where('xvmatcode', '=', $item->xvmatcode)
                    ->whereBetween('xdstkdate', [$startPrevious, $endPrevious])
                    ->update([
                        'xistkqtyuse' => DB::raw('xistkqty'),
                        'xistkqtyleft' => 0,
                    ]);
                $hasOldME = DB::table('tstktmatstockcard')
                    ->where('xvmatcode', '=', $item->xvmatcode)
                    ->where('xvstkdocno', '=', $item->xvstkdocno)
                    ->where('xvstktype', '=', $item->xvstktype)
                    ->first();
                if ($hasOldME) {
                    $costNew = ($item->xistkqty *$item->xfstkcost);
                    $costOld = $hasOldME->xistkqty *$hasOldME->xfstkcost;
                    $totalQty = $item->xistkqty + $hasOldME->xistkqty;
                    $stkcost= ($costNew+$costOld)/$totalQty;
                    DB::table('tstktmatstockcard')
                        ->where('xvmatcode', '=', $item->xvmatcode)
                        ->where('xvstkdocno', '=', $item->xvstkdocno)
                        ->where('xvstktype', '=', $item->xvstktype)
                        ->delete();
                    DB::table('tstktmatstockcard')
                        ->where('xvmatcode', '=', $item->xvmatcode)
                        ->where('xvstkdocno', '=', $item->xvstkdocno)
                        ->where('xvstktype', '=', $item->xvstktype)
                        ->insert([
                            'xvmatcode' => $item->xvmatcode,
                            'xvstkdocno' => $item->xvstkdocno,
                            'xvstktype' => $item->xvstktype,

                            'xistkqty' => $totalQty,
                            'xistkqtyuse' => $item->xistkqtyuse + $hasOldME->xistkqtyuse,
                            'xistkqtyleft' => $item->xistkqtyleft + $hasOldME->xistkqtyleft,
                            'xfstkcost' => $stkcost,
                            'xdstkdate' => $item->xdstkdate ,
                        ]);
                } else {
                    DB::table('tstktmatstockcard')->insert([
                        'xvmatcode' => $item->xvmatcode,
                        'xvstkdocno' => $item->xvstkdocno,
                        'xvstktype' => $item->xvstktype,
                        'xistkqty' => $item->xistkqty,
                        'xistkqtyuse' => $item->xistkqtyuse,
                        'xistkqtyleft' => $item->xistkqtyleft,
                        'xfstkcost' => $item->xfstkcost,
                        'xdstkdate' => $item->xdstkdate,
                    ]);
                }
            }
            DB::commit();

            return redirect()->back();
        } catch (\Exception $e) {
            DB::rollback();
            dd($e);
            abort(500, 'Internal error');
        }

    }

    public function SumQty($xvmatcode)
    {
        $Summary = DB::table('tstktmatstockcard')
            ->where('xvmatcode', '=', $xvmatcode)
            ->select(DB::raw('SUM(xistkqtyleft) as SumQty'))
            ->first();
        $data = [
            'Qty' => $Summary->SumQty ?? 0
        ];
        return response()->json($data);
    }


}
