function renderPdf(XVOrhDocNo) {
    let currentUrl = document.getElementById('urlGlobal').value;
    let url = `${currentUrl}/order/getDataForPDF/${XVOrhDocNo}`
    fetch(url)
        .then(response => response.json())
        .then(async data => {
            let GlobalHeader = {
                color: '#ffffff',
                fillColor: '#387fba',
            }
            let headerSection = SectionHeader(XVOrhDocNo)
            let sectionSubHeader = SectionSubHeader(GlobalHeader, data.hd);
            let aboutBOm = AboutBomCalculate();
            let orderSheetHeader = OrderSheetHeader();
            let orderSheet = OrderSheet(GlobalHeader, data.dt);
            var dd = {
                pageSize: 'A4',
                pageMargins: [10, 20],

                content: [
                    ...headerSection,
                    ...sectionSubHeader,
                    ...aboutBOm,
                    ...orderSheetHeader,
                    ...orderSheet,
                    ...OrderDetailHeader(),
                    ...OrderDetail(GlobalHeader, data.hdPure),
                    ...CommentDetailHeader(),
                    ...await CommentDetail(currentUrl, data.hd, data.hdPure),
                    ...Confirmation(),
                ],
                defaultStyle: {
                    font: "Sarabun",
                    fontSize: 7,

                }
            }
            pdfMake.createPdf(dd).open()
        });
}

// ซ้าย บน ขวา ล่าง

function SectionHeader(XVOrhDocNo) {
    return [
        {
            table: {
                widths: ['*', 125],
                body: [
                    [
                        {
                            text: 'VK GARMENT CO.,LTD. (VKJEANS.COM) \t PLS/BOM เอกสารสั่งตัด (Cutting)',
                            border: [false, false, false, false],
                            fontSize: 11,
                            bold: true
                        },
                        {
                            text: "OR No." + XVOrhDocNo,
                            alignment: 'right',
                            border: [false, false, false, false],
                            fontSize: 11,
                        }
                    ],
                ]
            },
        },
    ]
}

function SectionSubHeader(GlobalHeader, hd) {
    let Rmk = {
        color: '#a5a5a5',
        italics: true,
    }
    return [
        {
            table: {
                widths: [35, '*', 35, '*', 35, 100, 45],
                body: [
                    [
                        {
                            text: 'Item No:\nรหัสสินค้า:',
                            rowSpan: 2,
                            color: '#ffffff',
                            fillColor: '#12128a',
                        },
                        {
                            text: hd.xvpdtname,
                            fontSize: 12,
                            rowSpan: 2
                        },
                        {
                            text: 'รูปทรง',
                            ...GlobalHeader
                        },
                        {
                            text: hd.XVShapeName
                        },
                        {
                            text: 'ชื่อลูกค้า',
                            ...GlobalHeader
                        },
                        {
                            text: hd.XVCstName
                        },
                        {
                            text: 'เปิด Bom วันที่',
                            ...GlobalHeader
                        }
                    ],
                    [
                        {},
                        {},
                        {
                            text: 'ลักษณะ',
                            ...GlobalHeader
                        },
                        {
                            text: hd.XVGenerateName,
                        },
                        {
                            text: 'แบรน',
                            ...GlobalHeader
                        },
                        {
                            text: ''
                        },
                        {
                            text: convertDateToLocale(hd.XDOrhDocDate)
                        }
                    ],
                    [
                        {
                            text: 'Pattern No:',
                            color: '#ffffff',
                            fillColor: '#12128a',
                        },
                        {
                            text: hd.XVPdtPatternNo,
                        },
                        {
                            text: 'รูปแบบ',
                            ...GlobalHeader
                        },
                        {
                            text: hd.XVForType
                        },
                        {
                            text: 'ราคาขาย',
                            ...GlobalHeader
                        },
                        {
                            text: hd.XFPdtPrice
                        },
                        {
                            text: 'ชื่อช่างตัด',
                            ...GlobalHeader
                        }
                    ],
                    [
                        {
                            text: 'ร้านผ้า',
                            ...GlobalHeader,
                        },
                        {
                            text: ''
                        },
                        {
                            text: 'คำนวณหลา',
                            ...GlobalHeader,
                        },
                        {
                            text: ''
                        },
                        {
                            text: 'ราคาส่ง',
                            ...GlobalHeader,
                        },
                        {
                            text: ''
                        },
                        {
                            text: hd.XVOrhCutter
                        }
                    ],
                    [
                        {
                            text: 'ชื่อผ้าตัว',
                            ...GlobalHeader,
                        },
                        {
                            text: hd.xvmatname,
                        },
                        {
                            text: 'หลาจากบิล',
                            ...GlobalHeader,
                        },
                        {
                            text: '',
                        },
                        {
                            text: '* ใส่จำนวน พับ/หลา ผ้าก่อนตัดงานทุกครั้ง',
                            ...Rmk,
                            border: [true, true, true, false],
                            colSpan: 3,
                        },

                    ],
                    [
                        {
                            text: 'หน้าผ้า',
                            ...GlobalHeader,
                        },
                        {
                            text: hd.XVPdtClothFace,
                        },
                        {
                            text: 'หลาที่จด',
                            ...GlobalHeader,
                        },
                        {
                            text: '',
                        },
                        {
                            text: '* ผ้ามาครบไม่ขาดหลา',
                            ...Rmk,
                            border: [true, false, true, false],
                            colSpan: 3,
                        },
                    ],
                    [
                        {
                            text: 'ผ้าเป้า',
                            ...GlobalHeader,
                        },
                        {
                            text: hd.XVPdtCrotchFabric,
                        },
                        {
                            text: 'กินผ้าเป้า',
                            ...GlobalHeader,
                        },
                        {
                            text: '',
                        },
                        {
                            text: '* เหลือเศษเก็บเป็นตัวไม่ได้รวม 0 หลา',
                            ...Rmk,
                            border: [true, false, true, false],
                            colSpan: 3,
                        },
                    ],
                    [
                        {
                            text: 'ผ้าแต่ง A',
                            ...GlobalHeader,
                        },
                        {
                            text: hd.XVPdtFarbicA,
                        },
                        {
                            text: 'กินผ้า',
                            ...GlobalHeader,
                        },
                        {
                            text: '',
                        },
                        {
                            text: '* หมายเหตุ ตัดงานวันที่',
                            color: '#ba6a00',
                            border: [true, false, true, false],
                            colSpan: 3,
                        },
                    ],
                    [
                        {
                            text: 'ผ้าแต่ง B',
                            ...GlobalHeader,
                        },
                        {
                            text: hd.XVPdtFarbicB,
                        },
                        {
                            text: 'กินผ้า',
                            ...GlobalHeader,
                        },
                        {
                            text: '',
                        },
                        {
                            text: '\t Mark: \t 0',
                            ...Rmk, preserveLeadingSpaces: true,
                            border: [true, false, true, true],
                            colSpan: 3,
                        },
                    ],
                ]
            },
        },
    ]
}

function AboutBomCalculate() {
    let ArrayExample = [
        'ต.ย.คำนวณผ้าตัว',
        'ต.ย.คำนวณถุงเป๋า',
        'ต.ย.คำนวณผ้าแต่ง A',
        'ต.ย.คำนวณผ้าแต่ง B',
    ]
    let ItemRender = renderBodyAboutBom(ArrayExample)
    return [
        {
            margin: [0, 5, 0, 0],
            table: {
                widths: [60, 20, 85, 15, 35, 10, 10, 15, '*'],
                body: [
                    [
                        {
                            text: '* คำนวณการสั่งผ้า ( ประมาณ 98 % ) จากตัวอย่าง',
                            border: [true, true, true, false],
                            alignment: 'center',
                            colSpan: 8
                        },
                        {}, {}, {}, {}, {}, {}, {},
                        {
                            text: 'ตำหนิ :',
                            rowSpan: 5
                        },
                    ],
                    ...ItemRender
                ]
            },
        },
    ]
}

function renderBodyAboutBom(ArrForExample) {
    let Arr = []
    let borderFirst = [true, false, false, false]
    let borderChild = [false, false, false, false]
    for (let i = 0; i < ArrForExample.length; i++) {
        if (i === ArrForExample.length - 1) {
            borderFirst = [true, false, false, true]
            borderChild = [false, false, false, true]
        }
        Arr.push([
            {
                text: ArrForExample[i],
                alignment: 'right',
                border: borderFirst,
            },
            {
                text: '',
                border: borderChild,
            },
            {
                text: 'หลาต่อ 1 ตัว คูณจำนวณตัว',
                alignment: 'center',
                border: borderChild,

            },
            {
                text: '=',
                alignment: 'center',
                border: borderChild,

            },
            {
                text: 'ใช้ประมาณ',
                alignment: 'center',
                border: borderChild,

            },
            {
                text: '',
                border: borderChild,
            },
            {
                text: '',
                border: borderChild,
            },
            {
                text: 'หลา',
                alignment: 'center',
                border: borderChild,

            },

        ])
    }
    return Arr
}

function OrderSheetHeader() {
    return [
        {
            margin: [0, 5, 0, 0],
            table: {
                widths: ['*'],
                body: [
                    [
                        {
                            text: 'ORDER SHEET / จำนวนยอดสั่งผลิต',
                            alignment: 'center',
                            fontSize: 11,
                        },
                    ],
                ]
            },
        },
    ]
}

function OrderSheet(GlobalHeader, dt) {
    let size = dt;
    let star = size.map((item) => "*")
    let {arr, arrOrderThai, arrOrderActual} = renderBodyOrder(size, GlobalHeader)
    return [
        {
            table: {
                widths: ['*', '*', ...star],
                body: [
                    arr,
                    arrOrderThai,
                    arrOrderActual
                ]
            },
        },
    ]
}

function renderBodyOrder(arrSize, GlobalHeader) {
    let arr = [
        {
            text: 'Size / ไซส์',
            alignment: 'center',
            ...GlobalHeader
        },
    ]
    let arrOrderThai = [
        {
            text: 'รวมยอดสั่งผลิต',
            alignment: 'center',
        },
    ]
    let arrOrderActual = [
        {
            text: 'ยอดที่ตัดได้จริง',
            alignment: 'center',
        },
    ]
    let total = arrSize.reduce((sum, {XIOrdQty}) => sum + XIOrdQty, 0)
    for (let i = 0; i < arrSize.length; i++) {
        arr.push(
            {
                text: `${arrSize[i].XVPszName}`,
                alignment: 'center',
                ...GlobalHeader
            },
        )
        arrOrderThai.push(
            {
                text: `${arrSize[i].XIOrdQty}`,
                alignment: 'center',
            },
        )
        arrOrderActual.push(
            {
                text: ``,
                alignment: 'center',
            },
        )


    }
    arr.push(
        {
            text: 'รวม',
            alignment: 'center',
            ...GlobalHeader
        },
    )
    arrOrderThai.push(
        {
            text: total,
            alignment: 'center',
        },
    )
    arrOrderActual.push(
        {
            text: ``,
            alignment: 'center',
        },
    )
    return {
        arr,
        arrOrderThai,
        arrOrderActual
    };
}

function OrderDetailHeader() {
    return [
        {
            margin: [0, 5, 0, 0],
            table: {
                widths: ['*'],
                body: [
                    [
                        {
                            text: 'รายละเอียดการตัดงาน / ผลิต',
                            alignment: 'center',
                            fontSize: 11,
                            color: '#ffffff',
                            fillColor: '#12128a',
                        },
                    ],
                ]
            },
        },
    ]
}

function OrderDetail(GlobalHeader, hd) {

    return [
        {
            table: {
                heights: function (row) {
                    if (row === 2) {
                        return 100;
                    }
                },
                widths: [40, '*', 45, '*'],
                body: [
                    [
                        {
                            text: "ชื่อโรงฟอก",
                            ...GlobalHeader
                        },
                        {
                            text: "",
                        },
                        {
                            text: "ชื่อโรงพิมพ์",
                            ...GlobalHeader
                        },
                        {
                            text: "",
                        }

                    ],
                    [
                        {
                            text: "รหัสด้ายเย็บ",
                            ...GlobalHeader
                        },
                        {
                            text: "",
                        },
                        {
                            text: "ชื่อโรงปัก",
                            ...GlobalHeader
                        },
                        {
                            text: "",
                        }

                    ],
                    [
                        {
                            text: hd.XVPohDocRmk,
                            colSpan: 4
                        },
                    ],
                ]
            },
        },
    ]
}

function CommentDetailHeader() {
    return [
        {
            table: {
                widths: [200, '*'],
                body: [
                    [
                        {
                            text: 'Comment:',
                            alignment: 'left',
                            fontSize: 11,
                            border: [true, true, false, true],
                        },
                        {
                            text: 'รูปภาพประกอบ / คำอธิบาย',
                            alignment: 'left',
                            fontSize: 11,
                            border: [false, true, true, true],
                        },
                    ],
                ]
            },
        },
    ]
}

async function CommentDetail(urlApp, hdjoin, hd) {
    let imgUrl, picture;
    if(hd.XVOrhImg){
        imgUrl = `${urlApp}/${hd.XVOrhImg}`
    } else if (hdjoin.XVPdtImg) {
        imgUrl = `${urlApp}/${hdjoin.XVPdtImg}`
    } else {
        imgUrl = `${urlApp}/images/not-found.jpg`
    }
    try {
        picture = await getBase64ImageFromURL(imgUrl)
    } catch (e) {
        imgUrl = `${urlApp}/images/not-found.jpg`
        picture = await getBase64ImageFromURL(imgUrl)
    }
    return [
        {
            table: {
                widths: [50, 200, '*'],
                body: [
                    [
                        {
                            text: hd.XVPdtCmtDetail,
                            colSpan: 2
                        },
                        {},
                        {
                            image: picture,
                            width: 295,
                            height: 155,
                            alignment: 'center',
                            rowSpan: 12
                        },
                    ],
                    [
                        {
                            text: 'เพิ่มเติม',
                        },
                        {
                            text: hd.XVPdtCmtDetailMore,
                        },
                        {},
                    ],
                    [
                        {
                            text: 'ซิปยาว',
                        },
                        {
                            text: hd.XVPdtCmtZipSize,
                        },
                        {},
                    ],
                    [
                        {
                            text: 'สาบกระดุม',
                        },
                        {
                            text: hd.XVPdtCmtButton,
                        },
                        {},
                    ],
                    [
                        {
                            text: 'กระเป๋าลับ',
                        },
                        {
                            text: hd.XVPdtCmtSecretBag,
                        },
                        {},
                    ],
                    [
                        {
                            text: 'กระเป๋าหลัง',
                        },
                        {
                            text: hd.XVPdtCmtBackPocket,
                        },
                        {},
                    ],
                    [
                        {
                            text: 'ขนาดหู',
                        },
                        {
                            text: hd.XVPdtCmtEarSize,
                        },
                        {},
                    ],
                    [
                        {
                            text: 'ด้ายเย็บ',
                        },
                        {
                            text: hd.XVPdtCmtSewing,
                        },
                        {},
                    ],
                    [
                        {
                            text: 'ด้ายโพ้ง',
                        },
                        {
                            text: hd.XVPdtCmtTwill,
                        },
                        {},
                    ],
                    [
                        {
                            text: 'ด้ายแท้กกิ้ง',
                        },
                        {
                            text: hd.XVPdtCmtTagging,
                        },
                        {},
                    ],
                    [
                        {
                            text: 'ด้ายถักรังดุม',
                        },
                        {
                            text: hd.XVPdtCmtTung,
                        },
                        {},
                    ],
                    [
                        {
                            text: 'คำสั่งพิเศษ',
                        },
                        {
                            text: hd.XVPdtCmtSpecial,
                        },
                        {},
                    ],

                ]
            },
        },
    ]
}

function Confirmation() {
    return [
        {
            table: {
                heights: function (row) {
                    return 15;
                },
                widths: [150, 50, '*', 50, '*'],
                body: [
                    [
                        {
                            text: 'ผู้สั่งตัดอนุมัติ',
                            alignment: 'center',
                            fontSize: 11,
                            rowSpan: 4
                        },
                        {
                            text: 'Designer',
                        },
                        {
                            text: '',
                        },
                        {
                            text: 'โต๊ะตัดตุ๋ม',
                        },
                        {
                            text: '',
                        },
                    ],
                    [
                        {},
                        {
                            text: 'Merchandiser',
                        },
                        {
                            text: '',
                        },
                        {
                            text: 'ตัดสต็อคผ้าน่อง',
                        },
                        {
                            text: '',
                        },
                    ],
                    [
                        {},
                        {
                            text: 'ส่งปัก',
                        },
                        {
                            text: '',
                        },
                        {
                            text: 'ใบตามงาน อิ๊ด',
                        },
                        {
                            text: '',
                        },
                    ],
                    [
                        {},
                        {
                            text: 'ส่งพิมพ์',
                        },
                        {
                            text: '',
                        },
                        {
                            text: 'ยืนยันสั่งตัด ต๋อย',
                        },
                        {
                            text: '',
                        },
                    ],
                ]
            },
        },
    ]
}

//Utility

function formatMoney(amount, decimalCount = 2, decimal = ".", thousands = ",") {
    try {
        decimalCount = Math.abs(decimalCount);
        decimalCount = isNaN(decimalCount) ? 2 : decimalCount;

        const negativeSign = amount < 0 ? "-" : "";

        let i = parseInt(amount = Math.abs(Number(amount) || 0).toFixed(decimalCount)).toString();
        let j = (i.length > 3) ? i.length % 3 : 0;

        return negativeSign + (j ? i.substr(0, j) + thousands : '') + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + thousands) + (decimalCount ? decimal + Math.abs(amount - i).toFixed(decimalCount).slice(2) : "");
    } catch (e) {
        console.error(e)
    }
};

function getBase64ImageFromURL(url) {
    return new Promise((resolve, reject) => {
        var img = new Image();
        img.setAttribute("crossOrigin", "anonymous");
        img.onload = () => {
            var canvas = document.createElement("canvas");
            canvas.width = img.width;
            canvas.height = img.height;
            var ctx = canvas.getContext("2d");
            ctx.drawImage(img, 0, 0);
            var dataURL = canvas.toDataURL("image/png");
            resolve(dataURL);
        };
        img.onerror = error => {
            reject(error);
        };
        img.src = url;
    });
}

function convertDateToLocale(date) {
    return new Date(date).toLocaleDateString('th')
}


function renderPdfBOM(XVOrhDocNo) {
    let currentUrl = document.getElementById('urlGlobal').value;
    let url = `${currentUrl}/order/getDataForPDFBOM/${XVOrhDocNo}`
    fetch(url)
        .then(response => response.json())
        .then(async data => {
            let GlobalHeader = {
                color: '#ffffff',
                fillColor: '#387fba',
            }

            // let orderSheet = OrderSheetBOM(GlobalHeader, data.dt);
            let itemList = await renderList(data.mtQ, currentUrl)
            var dd = {
                pageSize: 'A4',
                pageMargins: [10, 20],

                content: [
                    // ...orderSheet,
                    BomHeader(),
                    BomHeaderDetail(data.hd),
                    BomDetailHeader(),
                    BomDetailList(itemList),
                ],
                defaultStyle: {
                    font: "Sarabun",
                    fontSize: 7,

                }
            }
            pdfMake.createPdf(dd).open()
        });


}

function OrderSheetBOM(GlobalHeader, dt) {
    let size = dt;
    let star = size.map((item) => "*")
    let {arr, arrOrderThai, arrOrderActual} = renderBodyOrder(size, GlobalHeader)
    return [
        {
            table: {
                widths: ['*', '*', ...star],
                body: [
                    arr,
                    arrOrderThai,
                ]
            },
        },
    ]
}

function BomHeader() {
    return [
        {
            table: {
                widths: ['*'],
                body: [
                    [
                        {
                            text: 'รายการวัตถุดิบที่ใช้ในการผลิต / B O M',
                            alignment: 'center',
                            fontSize: 11,
                        },
                    ],
                ]
            },
        },
    ]
}

function BomHeaderDetail(data) {
    return [
        {
            table: {
                widths: ['*', '*', 50, '*', '*', '*'],
                body: [
                    [
                        {
                            text: 'รหัสงาน / Order No.',
                            alignment: 'center',
                            fontSize: 11,
                        },
                        {
                            text:data.XVOrhDocNo,
                            alignment: 'center',
                            fontSize: 11,
                        },
                        {
                            text: 'ราคา',
                            alignment: 'center',
                            fontSize: 11,
                        },
                        {
                            text:data.XFPdtPrice,
                            alignment: 'center',
                            fontSize: 11,
                        },
                        {
                            text: 'วันที่ / Date',
                            alignment: 'center',
                            fontSize: 11,
                            rowSpan: 2,
                            margin: [0, 10, 0]
                        },
                        {
                            text: convertDateToLocale(data.XDOrhDocDate),
                            alignment: 'center',
                            fontSize: 11,
                            rowSpan: 2,
                            margin: [0, 10, 0]
                        },
                    ],
                    [
                        {
                            text: 'ลูกค้า / Customer',
                            alignment: 'center',
                            fontSize: 11,
                        },
                        {
                            text: data.XVCstName,
                            alignment: 'center',
                            fontSize: 11,
                            colSpan: 3
                        },
                        {},
                        {},
                        {},
                        {}
                    ],
                ]
            },
        },
    ]
}

function BomDetailHeader() {
    return [
        {
            table: {
                widths: ['*', '*'],
                body: [
                    [
                        {
                            text: 'รายละเอียดวัตถุดิบเย็บ',
                            alignment: 'center',
                            fontSize: 11,
                        },
                        {
                            text: 'รายละเอียดวัตถุดิบเย็บ',
                            alignment: 'center',
                            fontSize: 11,
                        },
                    ],
                ]
            },
        },
    ]
}

function BomDetailList(itemList) {
    let line = Math.ceil(itemList.length / 2);
    let mod = itemList.length%2;
    const emptyTemp = [
        {text: '', fontSize: 8, alignment: 'center'},
        {text: '', fontSize: 8, alignment: 'center'},
        {text: '', fontSize: 8, alignment: 'center'},
        {text: '', fontSize: 8, alignment: 'center'},
        {text: '', fontSize: 8, alignment: 'center'},
    ]
    let arr =[];
    let arrL = [];
    let SumQtyL = 0;
    let SumQtyR = 0;
    let arrR = [];
    for(let i = 0 ; i < itemList.length ; i=i+2){
        arrL.push(itemList[i])
        SumQtyL= SumQtyL + parseInt(itemList[i][2].text);
        if( i === itemList.length-1){
            if(mod === 0){
                arrR.push(itemList[i+1])
                SumQtyR= SumQtyR + parseInt(itemList[i+1][2].text);
            }
        }else{
            arrR.push(itemList[i+1])
            SumQtyR= SumQtyR + parseInt(itemList[i+1][2].text);
        }
    }
    for(let i = 0 ; i <= line-1 ; i++){
        if( i === line-1 ){
            if(mod === 0){
                arr.push([
                    ...arrL[i],
                    ...arrR[i],
                ])
            }else{
                arr.push([
                    ...arrL[i],
                    ...emptyTemp,
                ])
            }
        }else{
            arr.push([
                ...arrL[i],
                ...arrR[i],
            ])
        }

    }
    return [
        {
            table: {
                widths: ['*',50,39,39,39,'*',50,39,39,39],
                // widths: ['*','*','*','*','*'],
                body: [
                    [
                        {text: 'รูปแบบ', fontSize: 8, alignment: 'center'},
                        {text: 'รายละเอียด', fontSize: 8, alignment: 'center'},
                        {text: 'จำนวน', fontSize: 8, alignment: 'center'},
                        {text: '@', fontSize: 8, alignment: 'center'},
                        {text: 'จำนวนเงิน', fontSize: 8, alignment: 'center'},
                        {text: 'รูปแบบ', fontSize: 8, alignment: 'center'},
                        {text: 'รายละเอียด', fontSize: 8, alignment: 'center'},
                        {text: 'จำนวน', fontSize: 8, alignment: 'center'},
                        {text: '@', fontSize: 8, alignment: 'center'},
                        {text: 'จำนวนเงิน', fontSize: 8, alignment: 'center'},
                    ],
                    ...arr,
                    [
                        {text: '', fontSize: 8, alignment: 'center'},
                        {text: '', fontSize: 8, alignment: 'center'},
                        {text: '', fontSize: 8, alignment: 'center'},
                        {text: '', fontSize: 8, alignment: 'center'},
                        {text: '', fontSize: 8, alignment: 'center'},
                        {text: '', fontSize: 8, alignment: 'center'},
                        {text: '', fontSize: 8, alignment: 'center'},
                        {text: '', fontSize: 8, alignment: 'center'},
                        {text: '', fontSize: 8, alignment: 'center'},
                        {text: '', fontSize: 8, alignment: 'center'},
                    ],
                    [
                        {text: 'รวม', fontSize: 8, alignment: 'center'},
                        {text: '', fontSize: 8, alignment: 'center'},
                        {text: SumQtyL, fontSize: 8, alignment: 'center'},
                        {text: '', fontSize: 8, alignment: 'center'},
                        {text: '', fontSize: 8, alignment: 'center'},
                        {text: 'รวม', fontSize: 8, alignment: 'center'},
                        {text: '', fontSize: 8, alignment: 'center'},
                        {text: SumQtyR, fontSize: 8, alignment: 'center'},
                        {text: '', fontSize: 8, alignment: 'center'},
                        {text: '', fontSize: 8, alignment: 'center'},
                    ],
                    // [
                    //     {text: 'Vat   %', fontSize: 8, alignment: 'center'},
                    //     {text: '', fontSize: 8, alignment: 'center'},
                    //     {text: '', fontSize: 8, alignment: 'center'},
                    //     {text: '', fontSize: 8, alignment: 'center'},
                    //     {text: '', fontSize: 8, alignment: 'center'},
                    //     {text: 'Vat   %', fontSize: 8, alignment: 'center'},
                    //     {text: '', fontSize: 8, alignment: 'center'},
                    //     {text: '', fontSize: 8, alignment: 'center'},
                    //     {text: '', fontSize: 8, alignment: 'center'},
                    //     {text: '', fontSize: 8, alignment: 'center'},
                    // ],
                    [
                        {text: 'สุทธิ', fontSize: 8, alignment: 'center'},
                        {text: '', fontSize: 8, alignment: 'center'},
                        {text: '', fontSize: 8, alignment: 'center'},
                        {text: '', fontSize: 8, alignment: 'center'},
                        {text: '', fontSize: 8, alignment: 'center'},
                        {text: 'สุทธิ', fontSize: 8, alignment: 'center'},
                        {text: '', fontSize: 8, alignment: 'center'},
                        {text: '', fontSize: 8, alignment: 'center'},
                        {text: '', fontSize: 8, alignment: 'center'},
                        {text: '', fontSize: 8, alignment: 'center'},
                    ],
                    [
                        {text: 'Total Buy Unit ', fontSize: 11, alignment: 'center'},
                        {text: SumQtyL+SumQtyR, fontSize: 8, alignment: 'center'},
                        {text: 'อุปกรณ์เย็บ \n อุปกรณ์แพ็ค',colSpan: 2, fontSize: 8, alignment: 'center'},
                        {},
                        {text: '', fontSize: 8, alignment: 'center'},
                        {text: 'อุปกรณ์เย็บ + Packing : 1 ตัว',colSpan:2, fontSize: 8, alignment: 'center'},
                        {},
                        {text: '',colSpan:3, fontSize: 8, alignment: 'center'},
                        {},
                        {},

                    ],
                ]
            },
        },
    ]
}

async function renderList(data, urlApp, itemPerLine = 2) {
    let itemList = [];
    for (let i = 0; i < data.length; i++) {
        let imgUrl, picture;
        if (data[i].xvmatpic && !data[i].xvmatpic.includes('not-found')) {
            imgUrl = `${urlApp}/${data[i].xvmatpic}`
            try {
                picture = await getBase64ImageFromURL(imgUrl)
                itemList.push([
                    {
                        table: {
                            widths: ['*'],
                            body: [
                                [
                                    {
                                        image: picture,
                                        width: 50,
                                        height: 50,
                                        alignment: 'center',
                                    },
                                ],
                                [
                                    {
                                        text: data[i].xvmatname,
                                        alignment: 'center',
                                        fontSize: 8,
                                    },
                                ],
                            ]
                        },layout: 'noBorders'
                    },
                    {text: data[i].xvmatdes, fontSize: 8, alignment: 'center'},
                    {text: `${data[i].SumQty} \n ${data[i].xvuntname} `, fontSize: 8, alignment: 'center'},
                    {text: '', fontSize: 8, alignment: 'center'},
                    {text: '-', fontSize: 8, alignment: 'right'},

                ])
            } catch (e) {
                itemList.push([
                    {
                        table: {
                            widths: ['*'],
                            border: [false, false],
                            body: [
                                [
                                    {
                                        text: data[i].xvmatname,
                                        alignment: 'center',
                                        fontSize: 8,
                                    },
                                ],
                            ]
                        },layout: 'noBorders'
                    },
                    {text: data[i].xvmatdes, fontSize: 8, alignment: 'center'},
                    {text: `${data[i].SumQty} \n ${data[i].xvuntname} `, fontSize: 8, alignment: 'center'},
                    {text: '', fontSize: 8, alignment: 'center'},
                    {text: '-', fontSize: 8, alignment: 'right'},
                ])
            }
        } else {
            itemList.push([
                {
                    table: {
                        widths: ['*'],
                        border: [false, false],
                        body: [
                            [
                                {
                                    text: data[i].xvmatname,
                                    alignment: 'center',
                                    fontSize: 8 ,
                                },
                            ],
                        ]
                    },layout: 'noBorders'
                },
                {text: data[i].xvmatdes, fontSize: 8, alignment: 'center'},
                {text: `${data[i].SumQty} \n ${data[i].xvuntname} `, fontSize: 8, alignment: 'center'},
                {text: '', fontSize: 8, alignment: 'center'},
                {text: '-', fontSize: 8, alignment: 'right'},

            ])
        }
    }
    return itemList;
}
