$(document).ready(function() {
    if ($('input[name="msg"]').val() == 'Duplicate') {
        swal('พบชื่อวัสดุนี้แล้วของผู้จัดจำหน่ายภายในระบบ', "กรุณาตั้งชื่อวัสดุใหม่", "warning")
    }
    let DT = $('#SelectMaterialUnit').on('select2:select', function(e) {
        var { id, text } = (e.params.data);
        createRowTable(id, text)
    });
    let SP = $('#SelectSupplier').on('select2:select', function(e) {
        var { id, text } = (e.params.data);
        createRowTableSup(id, text)
    });

    window.TriggerChange = function(oldArr, oldArr2) {
        DT.val(oldArr).trigger("change");
        SP.val(oldArr2).trigger("change");
    }

});


function createRowTable(id, text) {
    let str = text.replace(/ /g, '');
    str = replaceQuotes(str);
    let txt = str.split(":");
    const Control = document.getElementById("Control")
    Control.insertAdjacentHTML('beforebegin', `
                                <tr id="${id}" class="dtItems">
                                    <th scope="row">${txt[0]}</th>
                                    <th scope="row">${txt[1]}</th>
                                    <td>
                                        <input type="text" class="form-control text-right"
                                        onkeypress='return isNumberKeyNoDot(event)'
                                        name="ximunfactor[]" value="1" min="1"/>
                                    </td>
                                    <td>
                                        <input type="text" class="form-control text-right"
                                        onkeypress='return textNumber(event)'
                                        name="xfmunprice[]" value="1" min="1"/>
                                    </td>
                                    <td class="text-center">
                                        <button type="button" class="btn btn-danger btn-circle btn-sm" onclick="removeRow('${id}')">X</button>
                                    </td>
                                    <input type="hidden" name="xvuntcode[]" value="${id}">
                                </tr>`)
}

function createRowTableSup(id, text) {
    let str = text.replace(/ /g, '');
    str = replaceQuotes(str);
    let txt = str.split(":");
    const Control = document.getElementById("TableSup")
    Control.insertAdjacentHTML('beforebegin', `
                                <tr id="${id}" class="supItems">
                                    <th scope="row">${txt[0]}</th>
                                    <th scope="row">${txt[1]}</th> 
                                    <td style="10%;text-align:center;"><button type="button"  class="btn-sm btn-warning" onclick="godetail('${id}')"><i class="fas fa-eye"></i></button></td>
                                    <td class="text-center"><button type="button" class="btn btn-danger btn-circle btn-sm" onclick="removeRow('${id}')">X</button></td>
                                    <input type="hidden" name="xvsupcode[]" value="${id}">
                                </tr>`)
}

function removeRow(id) {
    document.getElementById(id).remove();
    updateCurrentDT("dtItems", "supItems");
}
//Form

function validateForm() {
    const ximunfactor = getArrayInput('ximunfactor[]');
    if (
        checkValue(ximunfactor, "กรุณากรอกจำนวน อย่างน้อย 1")
    ) {
        if (ximunfactor.length > 0) {
            return true
        } else {
            swal('กรุณาเลือกหน่วยนับวัสดุ', "กรุณาเลือกหน่วยนับวัสดุ 1 ชนิด", "warning")
        }
    }
    return false
}

function checkValue(arrVal, responseText) {
    const itemFillter = arrVal.filter((item) => item.trim().length === 0)
    if (itemFillter.length > 0) {
        swal(responseText, responseText, "warning")
        return false
    } else {
        return true;
    }
}

function SumArray(arrAmount) {
    return arrAmount
        .filter((item) => item !== '')
        .reduce((prev, curr) => parseFloat(prev) + parseFloat(curr))
}

function getArrayInput(NameElement) {
    var input = document.getElementsByName(NameElement);
    let arr = []
    for (var i = 0; i < input.length; i++) {
        arr.push(input[i].value)
    }
    return arr;
}

function replaceQuotes(text) {
    return text.replace(/"/g, "&quot;");
}

function updateCurrentDT(name, name2) {
    var oldList = document.getElementsByClassName(name)
    let oldArr = [];
    for (let i = 0; i < oldList.length; i++) {
        oldArr.push(oldList[i].id)
    }
    var oldList2 = document.getElementsByClassName(name2)
    let oldArr2 = [];
    for (let i = 0; i < oldList2.length; i++) {
        oldArr2.push(oldList2[i].id)
    }

    TriggerChange(oldArr, oldArr2)
}

function isNumberKeyNoDot(evt) {
    var charCode = (evt.which) ? evt.which : evt.keyCode;
    if ((charCode > 31 && (charCode < 48 || charCode > 57)))
        return false;
    return true;
}