const miniMumRow = 30;
const HeaderName = "401 รายงานการผลิตสินค้าแยกตามลูกค้า";
const column = 6;

function countLineSpace(text) {
    return Math.floor((text.length / 20)) * 10;
}

function renderPdf(result,filter) {
    let header = SectionHeader(filter);
    let ListItems = ListItem(result);
    let SubHeaderX = SubHeader();

    var dd = {
        pageSize: 'A4',
        // pageMargins: [20, 20],
        pageMargins: [20, 103, 20, 20],
        header: function (currentPage, pageCount, pageSize) {
            return {
                stack: [...header,...SubHeaderX],
                margin: [20, 15, 20, 0]
            }
        },
        content: [
            ...ListItems,
        ],
        defaultStyle: {
            font: "Sarabun",
            fontSize: 7,

        }
    }
    pdfMake.createPdf(dd).open()
}

// ซ้าย บน ขวา ล่าง

function SectionHeader(filter) {

    let DateStart,DateEnd,CstNameStart,CstNameEnd
    if(!!filter.isAllTime){
         DateStart = "ทั้งหมด"
         DateEnd = "ทั้งหมด"
    }else{
         DateStart = convertDateToLocale(filter.DateStart)
         DateEnd = convertDateToLocale(filter.DateEnd)
    }
    if(!!filter.isAllSpl){
         CstNameStart = "ทั้งหมด"
         CstNameEnd = "ทั้งหมด"
    }else{
         CstNameStart = (filter.XVSplCodeStart)
         CstNameEnd = (filter.XVSplCodeEnd)
    }
    return [
        {
            text: HeaderName,
            alignment: 'center',
            fontSize: 11,
            bold: true,

        },
        {
            text: `จากวันที่ ${DateStart}  ถึงวันที่ ${DateEnd}`,
            alignment: 'center',
            fontSize: 10,
            bold: false,
        },
        {
            text: `จากลูกค้า ${CstNameStart}\nถึง ${CstNameEnd}`,
            alignment: 'center',
            fontSize: 10,
            bold: false,
        },
    ]
}

function SubHeader() {
    return [
        {
            table: {
                widths: [80, 60, '*', '*', 80, 80],
                body: [
                    [
                        {text: 'ลูกค้า', fontSize: 9, alignment: 'left', rowSpan: 2, border: [true, true,true,true]},
                        {text: 'วันที่', fontSize: 9, alignment: 'left', rowSpan: 2, border: [true, true,true,true]},
                        {text: 'เลขที่ใบสั่งผลิต', fontSize: 9, alignment: 'left', border: [true, true,true,false]},
                        {text: 'เลขที่ใบรับสินค้า', fontSize: 9, alignment: 'left',rowSpan: 2, border: [true, true,true,true]},
                        {text: 'จำนวนสั่ง', fontSize: 9, alignment: 'left',rowSpan: 2, border: [true, true,true,true]},
                        {text: 'จำนวนผลิต', fontSize: 9, alignment: 'left',rowSpan: 2, border: [true, true,true,true]},
                    ],
                    [
                        {},
                        {},
                        {text: '\tสินค้า', fontSize: 9, alignment: 'left', border: [true, false,true,true],preserveLeadingSpaces: true},
                        {},
                        {},
                        {},

                    ],
                ]
            },

            layout: {
                fillColor: function (rowIndex, node, columnIndex) {
                    return (rowIndex === 0 || rowIndex === 1) ? '#CCCCCC' : null;
                },
                hLineWidth: function (i, node) {
                    return (i === 0 || i === node.table.body.length) ? 1 : 1;
                },
                vLineWidth: function (i, node) {
                    return (i === 0 || i === node.table.widths.length) ? 1 : 1;
                },
                hLineColor: function (i, node) {
                    return (i === 0 || i === node.table.body.length) ? 'black' : 'gray';
                },
                vLineColor: function (i, node) {
                    return (i === 0 || i === node.table.widths.length) ? 'black' : 'gray';
                },
            }
        },

    ]
}
function ListItem(result) {
    let arrayItems = [] ;
    for(let i = 0 ; i < result.length ; i++){
        let Items = renderItem(result[i]);
        arrayItems = [...arrayItems,...Items]
    }
    return [
        {
            table: {
                widths: [80, 60, '*', '*', 80, 80],
                body: [
                    ...arrayItems,
                ]
            },
        },

    ]
}
function renderItem({XVCstCode,XVCstName,OrderHD}) {
    let Item = []
    for (let i = 0; i < OrderHD.length; i++) {
        const {XVOrhDocNo,XDOrhDocDate,OrderDT,XVFrhDocNo} = OrderHD[i];
        const oldValue = OrderHD[i-1] ?? {XVOrhDocNo :null , XDOrhDocDate:null};
        let DateDisplay;
        if(XDOrhDocDate == oldValue.XDOrhDocDate){
            DateDisplay=""
        }else{
            DateDisplay = convertDateToLocale(XDOrhDocDate)
        }
        let NameDisplay = i == 0 ? `${XVCstCode+" "+XVCstName}`:'';
        const GlobalHeader = i == OrderHD.length-1 ? {border: [true, false,true,true]} : {border: [true, false,true,false]};
        Item.push([
            {text: NameDisplay, fontSize: 8, alignment: 'left',rowSpan:OrderDT.length+1,...GlobalHeader},
            {text: DateDisplay, fontSize: 8, alignment: 'center',rowSpan:OrderDT.length+1,...GlobalHeader},
            {text: XVOrhDocNo, fontSize: 8, alignment: 'left',...GlobalHeader},
            {text: XVFrhDocNo, fontSize: 8, alignment: 'left',...GlobalHeader},
            {text: "", fontSize: 8, alignment: 'right',...GlobalHeader},
            {text: "", fontSize: 8, alignment: 'right',...GlobalHeader},
        ],)
        for (let i = 0; i < OrderDT.length; i++) {
            const {XIOrdQty,xvpdtcode,xvpdtname,XVPszName,XIFrdQty} = OrderDT[i]
            Item.push([
                {},
                {},
                {text: `\t${xvpdtcode} ${xvpdtname} ไซส์ ${XVPszName}`,colSpan:2, fontSize: 8, alignment: 'left',preserveLeadingSpaces: true},
                {},
                {text: formatMoney(XIOrdQty,0,''), fontSize: 8, alignment: 'left'},
                {text: formatMoney(XIFrdQty,0,''), fontSize: 8, alignment: 'left'},
            ],)
        }

    }
    return Item
}

//Utility


function formatMoney(amount, decimalCount = 2, decimal = ".", thousands = ",") {
    try {
        decimalCount = Math.abs(decimalCount);
        decimalCount = isNaN(decimalCount) ? 2 : decimalCount;

        const negativeSign = amount < 0 ? "-" : "";

        let i = parseInt(amount = Math.abs(Number(amount) || 0).toFixed(decimalCount)).toString();
        let j = (i.length > 3) ? i.length % 3 : 0;

        return negativeSign + (j ? i.substr(0, j) + thousands : '') + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + thousands) + (decimalCount ? decimal + Math.abs(amount - i).toFixed(decimalCount).slice(2) : "");
    } catch (e) {
        console.error(e)
    }
};

function convertDateToLocale(date) {
    return new Date(date).toLocaleDateString('th')
}
