@extends('layouts.master')
@section('header')
    <link href="{{asset('css/gijgo.min.css')}}" rel="stylesheet" type="text/css"/>
    <link href="{{asset('css/select2.min.css')}}" rel="stylesheet"/>
    <link rel="stylesheet"
          href="{{asset('css/select2-bootstrap4.min.css')}}">
@endsection
<style>
    div.sticky {
        position: sticky;
        top: 0;
        background-color: #ffffff;
        padding-top: 8px;
        z-index: 100;
    }

    form.noStyle {
        margin: 0;
    }

    .btn-circle.btn-sm {
        width: 30px;
        height: 30px;
        padding: 6px 0px;
        border-radius: 15px;
        font-size: 8px;
        text-align: center;
    }

    .form-control {
        display: inline-block !important;
    }

</style>
@section('content')
    <form action="{{route('gr.store')}}" method="POST" id="Form_Submit"
          enctype="multipart/form-data"
          onkeypress="return event.keyCode != 13;"
          class="noStyle"
          onsubmit="return validateForm()">
        @csrf
        <div class="card">
            <div class="card-body">
                <div class="sticky">
                    <div class="row ">
                        <div class="col-md-4 col-xl-2">
                            <h5>ฟอร์มเพิ่มข้อมูล ใบรับวัสดุ</h5>
                        </div>

                        <div class="col text-right">
                            <label for="" class="mr-2 fontsi">สถานะเอกสาร : {{getDocStatusByCode("1")}}</label>

                            <a href="{{route('gr.index')}}" class="btn btn-danger"><i
                                    class="fas fa-long-arrow-alt-left fa-lg"></i> <span>กลับ</span></a>
                                    <button type="submit" class="btn btn-success">บันทึก</button>
                        </div>
                    </div>
                    <hr>
                </div>
                <h5>ข้อมูลเอกสาร</h5>

                <div class="row border mb-1 pb-0 ">

                    <div class="col border-right " style="display: none">
                        @component('Components.Supplier',['oldValue'=>$hd->XVSplCode,'isReadOnly'=>true])
                        @endcomponent
                    </div>

                    <div class="col  ">
                        @component('GR.components.hd',['oldHD'=>$hd])
                        @endcomponent
                    </div>
                    <div class="col border-right ">
                        <label class="col-md-4  col-xl-2 col-form-label">สถานที่รับวัสดุ</label>
                        <div class="col-11">
                            <input type="text" class="form-control" name="XVPohDeliveryPlace"
                                   value="{{$hd->XVPohDeliveryPlace }}"
                                   readonly>
                        </div>
                        <div class="col-11">
                            <label for="">หมายเหตุ</label>
                            <textarea type="text" class="form-control" name="XVGrhDocRmk"
                                      maxlength="100"
                                      rows="5">{{$hd->XVGrhDocRmk ?? ""}}</textarea>
                        </div>
                    </div>

                </div>

                <div class="row mb-1 pb-0">
                    <div class="col border ">
                        @component('GR.components.dt',['oldHD'=>$hd,'oldDT'=>$dt])
                        @endcomponent
                    </div>
                </div>

            </div>
        </div>
    </form>
@endsection
<script src="{{asset('js/jquery-3.5.1.min.js')}}"></script>
<script src="{{asset('js/gijgo.min.js')}}" defer type="text/javascript"></script>
<script src="{{asset('js/select2.min.js')}}" defer></script>
<script src="{{asset('js/sweetalert.min.js')}}"></script>
<script src="{{asset('js/pages/GR/form.js')}}"></script>
