@extends('layouts.master')
@section('header')
    <link href="{{asset('css/gijgo.min.css')}}" rel="stylesheet" type="text/css"/>
    <link href="{{asset('css/select2.min.css')}}" rel="stylesheet"/>
    <link rel="stylesheet"
          href="{{asset('css/select2-bootstrap4.min.css')}}">
    <link href="{{asset('js/kartik-v-bootstrap-fileinput/css/fileinput.min.css')}}" media="all" rel="stylesheet"
          type="text/css"/>
@endsection
<style>
    div.sticky {
        position: sticky;
        top: 0;
        background-color: #ffffff;
        padding-top: 8px;
        z-index: 100;
    }

    form.noStyle {
        margin: 0;
    }

    .btn-circle.btn-sm {
        width: 30px;
        height: 30px;
        padding: 6px 0px;
        border-radius: 15px;
        font-size: 8px;
        text-align: center;
    }

    .form-control {
        display: inline-block !important;
    }

</style>
@section('content')

    @csrf
    @method('PUT')
    <div class="card">
        <div class="card-body">
            <div class="sticky">
                <div class="row ">
                    <div class="col-3">
                        <h5>ฟอร์มอัพโหลด </h5>
                    </div>

                    {{--                        <div class="col-1 text-left">--}}
                    {{--                            <button type="button" onclick="TakeAction('save')" id="btn_save" class="btn btn-primary">บันทึก</button>--}}
                    {{--                        </div>--}}
                    <div class="col text-right">
                        <a href="{{route('item.index')}}" class="btn btn-success"><i
                                class="fas fa-long-arrow-alt-left fa-lg"></i> <span>กลับ</span></a>
                    </div>
                </div>
                <hr>
            </div>
            <h5>ข้อมูลเอกสาร</h5>
            <form action="{{route('itemSize.update')}}" method="POST" id="Form_Submit"
                  class="noStyle"
                  onsubmit="return validateForm()">
                <div class="row border">

                    <div class="col border-right ">

                        @component('MasterItem.components.hd',['oldHD'=>$hd])
                        @endcomponent
                    </div>
                    <div class="col border-right ">

                        @component('MasterItem.components.secondHD',['oldHD'=>$hd])
                        @endcomponent
                    </div>

                </div>
            </form>

            <div class="row">
                <div class="col-8 ">
                    <label for="input-24">อัพโหลดข้อมูล (jpg , png , pdf)</label>
                    <div class="file-loading">
                        <input id="input-24" name="ImageUpload" type="file">
                    </div>


                </div>
                <div class="col">
                    <label for="input-24">อัพโหลด Link ข้อมูล</label>
                    <a href="#" class="btn-sm btn-success" data-toggle="modal" data-target="#exampleModalCenter">
                        <i class="fas fa-plus-square"></i>เพิ่มข้อมูล</a>
                    <table class="table table-sm">
                        <thead>
                        <tr>
                            <th scope="col">ชื่อ Link</th>
                            <th scope="col">Url</th>
                            <th scope="col" width="5%">ลบ</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($pdtLink as $item)
                            <tr>
                                <th scope="row">{{$item->xvpdtlinkname}}</th>
                                <td>
                                    <a href="{{$item->xvpdtlinkurl}}" target="_blank" class="btn-sm btn-warning">
                                        <i class="fas fa-link"></i>
                                    </a>
                                </td>
                                <td>
                                    <form action="{{route('item.DeleteLink')}}" method="POST"
                                          class="noStyle"
                                          onsubmit="event.preventDefault();return SwalAskFormEdit(this,'ยืนยันการลบข้อมูล','ข้อมูลจะถูกลบออกจากระบบ')"
                                    >
                                        @csrf
                                        @method('DELETE')
                                        <input type="hidden" class="form-control"
                                               name="xvpdtcode" value="{{$hd->xvpdtcode ?? "Itm####-######"}}"
                                               readonly>
                                        <input type="hidden" class="form-control"
                                               name="xvpdtlinkname" value="{{$item->xvpdtlinkname ?? "Itm####-######"}}"
                                               readonly>
                                        <input type="hidden" class="form-control"
                                               name="xvpdtlinkurl" value="{{$item->xvpdtlinkurl ?? "Itm####-######"}}"
                                               readonly>
                                        <button type="submit"  class="btn-sm btn-danger "  style="cursor: pointer;">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>

                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                    <!-- Modal -->
                    <form action="{{route('item.StoreLink')}}" method="POST"
                          class="noStyle"
                    >
                        @csrf
                        <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog"
                             aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="exampleModalCenterTitle">เพิ่ม Link</h5>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <div class="modal-body">
                                        <input type="hidden" class="form-control"
                                               name="xvpdtcode" value="{{$hd->xvpdtcode ?? "Itm####-######"}}"
                                               readonly>
                                        <div class="form-group row mt-2">
                                            <label class="col-sm-12 col-form-label">ชื่อ Link</label>
                                            <div class="col-sm-12">
                                                <input type="text" class="form-control"
                                                       name="xvpdtlinkname"
                                                       id="xvpdtlinkname"
                                                       required/>
                                            </div>
                                            <label class="col-sm-12 col-form-label">Link URL ( 1 Link ) </label>
                                            <div class="col-sm-12">
                                            <textarea type="text" class="form-control" name="xvpdtlinkurl"
                                                      id="xvpdtlinkurl"
                                                      required
                                                      placeholder="ตัวอย่าง Ex.http://google.co.th/"
                                                      maxlength="100"
                                                      rows="5"></textarea>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">ยกเลิก
                                        </button>
                                        <button type="submit" class="btn btn-primary">บันทึก</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <input type="hidden" name="msg" value="{{session()->get('msg')}}">

@endsection
<script src="{{asset('js/helper.js')}}"></script>
<script src="{{asset('js/jquery-3.5.1.min.js')}}"></script>
<script src="{{asset('js/gijgo.min.js')}}" defer type="text/javascript"></script>
<script src="{{asset('js/select2.min.js')}}" defer></script>
<script src="{{asset('js/sweetalert.min.js')}}"></script>
<script src="{{asset('js/kartik-v-bootstrap-fileinput/js/plugins/piexif.js')}}" type="text/javascript"
        defer></script>
<script src="{{asset('js/kartik-v-bootstrap-fileinput/js/plugins/sortable.js')}}" type="text/javascript"
        defer></script>
<script src="{{asset('js/kartik-v-bootstrap-fileinput/js/plugins/popper.js')}}" defer></script>
<script src="{{asset('js/kartik-v-bootstrap-fileinput/js/fileinput.js')}}" defer></script>
<script src="{{asset('js/kartik-v-bootstrap-fileinput/themes/fas/theme.js')}}" defer></script>
{{--<script src="{{asset('js/kartik-v-bootstrap-fileinput/js/locales/en.js')}}"  defer></script>--}}

<script>
    $(document).ready(function () {
        const OldImage = {!! $images !!};
        const currentUrl = $("#urlGlobal").val();
        let arr = [];
        let urlArr = [];
        for (let i = 0; i < OldImage.length; i++) {
            urlArr.push(`${currentUrl}/${OldImage[i].xvpdffile}`);
            let obj = {
                caption: OldImage[i].xvpdffile,
                downloadUrl: `${currentUrl}/${OldImage[i].xvpdffile}`,
                width: "120px",
                key: OldImage[i].xvpdffile
            }
            if (OldImage[i].xvpdffiletype === "pdf") {
                obj.type = OldImage[i].xvpdffiletype
            }
            arr.push(obj)
        }
        $("#input-24").fileinput({
            theme: "fas",
            validateInitialCount: true,
            allowedFileExtensions: ['jpg', 'png', 'pdf'],
            slugCallback: function (filename) {
                return filename.replace('(', '_').replace(']', '_');
            },

            initialPreview: urlArr,
            initialPreviewAsData: true,
            initialPreviewConfig: arr,

            overwriteInitial: false,
            showRemove: false,
            showUpload: false,

            uploadUrl: "{!! route('item.storePicture') !!}",
            uploadExtraData: function () {
                return {
                    xvpdtcode: $("input[name='xvpdtcode']").val(),
                    _token: $("input[name='_token']").val(),
                };
            },
            deleteExtraData: function () {
                return {
                    xvpdtcode: $("input[name='xvpdtcode']").val(),
                    _token: $("input[name='_token']").val(),
                };
            },
            deleteUrl: "{!! route('item.deletePicture') !!}",

        }).on('fileuploaded', function (event, previewId, index, fileId) {
            location.reload();
        }).on('filebeforedelete', function() {
            return new Promise(function(resolve, reject) {
                swal({
                    title: "ยืนยันการลบไฟล์",
                    icon: "warning",
                    buttons: true,
                    dangerMode: true,
                })
                    .then((willDelete) => {
                        if (willDelete) {
                            resolve()
                        }
                    });
            });
        }).on('filedeleted', function() {
            swal('ลบไฟล์สำเร็จ','', "success")
        });


        if ($('input[name="msg"]').val() == 'Duplicate') {
            console.log('here')
            swal('พบ Size นี้แล้ว', "กรุณาตั้ง Size ใหม่", "warning")
        }
        $("#Form_Submit :input").prop("disabled", true);
        // $("#btn_save").attr('disabled',false)
        $("#XVPszName").attr('disabled', false)
        $("#btn_XVPszName").attr('disabled', false)
        $("#eventMethod").attr('disabled', false)
        $("#eventValue").attr('disabled', false)
        $("[name='_token']").attr('disabled', false)
        $("[name='_method']").attr('disabled', false)
        $("[name='xvpdtcode']").attr('disabled', false)

    })
</script>
