
@extends('layouts.master')
@section('header')
    <link href="{{ asset('css/gijgo.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('css/select2.min.css') }}" rel="stylesheet" />
    <link rel="stylesheet" href="{{ asset('css/select2-bootstrap4.min.css') }}">

@endsection
@php
use Illuminate\Support\Facades\DB;
$DataSource = DB::table('vk2_users')
->get()->toArray();
$pk = "id";
$display = "name";
@endphp
@section('content')

    <meta name="csrf-token" content="{{ csrf_token() }}" />
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-6">
                    <h5 style="font-weight: bold;">รายงานการเบิกวัสดุแยกตามผู้เบิก</h5>
                </div>
            </div>
            <hr>
            <div class="card-body  border border-dark rounded">
                <div class="row mt-1">
                    <div class="col-4 text-right">
                        <h6 style="font-weight: bold">เงื่อนไขในการเลือก</h6>

                    </div>
                    <div class="col-8 text-right">
                        <button class="btn btn-info bottom " style="vertical-align: bottom;" onclick="datareport()">
                           export pdf</button>
                        <button class="btn btn-success bottom " style="vertical-align: bottom;" onclick="">export
                            excel</button>
                        {{-- <button class="btn btn-success bottom " style="vertical-align: bottom;" onclick="">export
                            PDF</button> --}}

                    </div>
                </div>
                <div class="row mt-2">
                    <div class="col-12">
                        <h6 style="font-weight: bold">วันที่</h6>
                        <input type="checkbox" class="mr-2" id="AllDate" onclick="AllDate()">ทั้งหมด
                        <div class="row mt-2 mb-3">
                            <p>ตั้งแต่วันที่</p>
                            <div class="col-4">
                                <input class="form-control" type="date" value="" name="DateStart" id="DateStart">
                            </div>
                            <p>ถึงวันที่</p>
                            <div class="col-4">
                                <input class="form-control" type="date" value="" name="DateEnd" id="DateEnd">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row mt-2">
                    <div class="col-12">
                        <h6 style="font-weight: bold">พนักงาน</h6>
                        <input type="checkbox" class="mr-2" id="AllCst" onclick="AllCst()">ทั้งหมด
                        <div class="row mt-2">
                            <p> จาก</p>
                            <div class="col-4 ml-0">
                                <select class="form-control" id="SelectUsersStart"
                                name="SelectUsers"
                                @if(isset($isMultiple) && $isMultiple== true) multiple @endif
                                @if(isset($isRequired) && $isRequired== true) required @endif
                                @if(isset($isReadOnly) && $isReadOnly== true) readonly @endif
                        >
                            <option></option>
                            @foreach ($DataSource as $key => $item)
                                <option
                                    @if(isset($oldValue) && $oldValue==$item->$pk) selected @endif
                                value="{{$item->$pk}}">{{$item->$pk}} : {{$item->$display}}</option>
                            @endforeach
                        </select>
                            </div>
                            <p> ถึง</p>
                            <div class="col-4 ml-0">
                                <select class="form-control" id="SelectUsersEnd"
                                name="SelectUsers"
                                @if(isset($isMultiple) && $isMultiple== true) multiple @endif
                                @if(isset($isRequired) && $isRequired== true) required @endif
                                @if(isset($isReadOnly) && $isReadOnly== true) readonly @endif
                        >
                            <option></option>
                            @foreach ($DataSource as $key => $item)
                                <option
                                    @if(isset($oldValue) && $oldValue==$item->$pk) selected @endif
                                value="{{$item->$pk}}">{{$item->$pk}} : {{$item->$display}}</option>
                            @endforeach
                        </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <table id="table-report" class="table " style="width: 100%">
    </div>

    </div>
    <script>
        $(document).ready(function() {

            $('#SelectUsersStart').select2({
                placeholder: "เลือกพนักงาน",
                theme: 'bootstrap4',
            });
            $('#SelectUsersEnd').select2({
                placeholder: "เลือกพนักงาน",
                theme: 'bootstrap4',
            });
            Date.prototype.toDateInputValue = (function() {
                var local = new Date(this);
                local.setMinutes(this.getMinutes() - this.getTimezoneOffset());
                return local.toJSON().slice(0, 10);
            });

            document.getElementById('DateStart').value = new Date().toDateInputValue();
            document.getElementById('DateEnd').value = new Date().toDateInputValue();


        })

        function lll(sss) {
            console.log(sss);

        }

    </script>

    <script>
        function AllCst() {
            var checkBox = document.getElementById("AllCst");
            if (checkBox.checked == true) {
                document.getElementById('SelectUsersStart').disabled = true;
                document.getElementById('SelectUsersEnd').disabled = true;
            } else {
                document.getElementById('SelectUsersStart').disabled = false;
                document.getElementById('SelectUsersEnd').disabled = false;
            }
        }

        function AllDate() {
            var checkBox = document.getElementById("AllDate");
            if (checkBox.checked == true) {
                document.getElementById('DateStart').disabled = true;
                document.getElementById('DateEnd').disabled = true;
            } else {
                document.getElementById('DateStart').disabled = false;
                document.getElementById('DateEnd').disabled = false;
            }
        }

        function datareport() {
            var dataSet = [];
            let _token = $('meta[name="csrf-token"]').attr('content');
            $.ajax({
                url: '{{ route('report.Select201') }}',
                type: "POST",
                data: {
                    _token: _token,
                    DateStart: document.getElementById('DateStart').value,
                    DateEnd: document.getElementById('DateEnd').value,
                    // XVSplName: document.getElementById('SelectSupplier').value,
                },
                success: function(result) {
                    console.log(result);
                    renderPdf(result);
                }
            });
        }

    </script>
@endsection
<script src="{{ asset('js/pages/report/PO/pdf.js') }}"></script>
<script src="{{ asset('js/jquery-3.5.1.min.js') }}"></script>
<script src="{{ asset('js/gijgo.min.js') }}" defer type="text/javascript"></script>
<script src="{{ asset('js/select2.min.js') }}" defer></script>
<script src="{{ asset('js/sweetalert.min.js') }}"></script>
<script src="{{ asset('js/pdfmake.js') }}"></script>
