@extends('layouts.master')
@section('content')
<div class="card">
  <div class="card-body">
    <div class="row">
      <div class="col-6">
        <h5 style="font-weight: bold;">หน่วยนับ</h5>
      </div>
      <div class="col-6 text-right">
          <a data-toggle="modal" href="#modal-form-material-unit" class="btn btn-success"><i class="fas fa-plus-square"></i> เพิ่มข้อมูล</a>
      </div>
    </div>
    <hr>
    <div class="row mt-5">
      <div class="col-12" style="margin: auto">
        <table id="tb_mat_unit" class="table table-striped">
          <thead style="font-weight: bold;">
            <tr>
              <td >รหัส</td>
              <td >ชื่อหน่วยนับ</td>
              <td style="text-align: center; width:5%;">แก้ไข</td>
              <td style="text-align: center; width:5%;"">ลบ</td>
            </tr>
          </thead>
          <tbody style="font-size: 14px;">
            @foreach ($units as $unit)
                <tr>
                  <td>{{$unit->xvuntcode}}</td>
                  <td>{{$unit->xvuntname}}</td>
                  <td style="text-align: center;">
                    <a data-toggle="modal" href="#modal-form-edit-material-unit" class="btn-sm btn-info pl-2 pr-2 pb-2 pt-2" onclick="open_modal('{{$unit->xvuntcode}}','{{$unit->xvuntname}}')"><i class="fas fa-edit fa-1x"></i></a>
                  </td>
                  <td style="text-align: center;color:white;"><a class="btn-sm btn-danger pl-2 pr-2 pb-2 pt-2" onclick="del('{{$unit->xvuntcode}}')"><i class="fas fa-trash fa-1x"></i></a></td>
                </tr>
            @endforeach
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
{{-- modal form --}}
<div class="modal" id="modal-form-material-unit" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">ฟอร์มเพิ่มข้อมูลหน่วยนับ</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form action="{{route('add_material_unit')}}" method="POST">
          @csrf
          <div class="form-row">
            <div class="col-12">
              <label for="">ชื่อหน่วยนับ</label>
              <input type="text" class="form-control" name="xvuntname" required>
            </div>
          </div>
          <div class="form-row mt-5">
            <div class="col-6 text-center">
              <button type="button" class="btn btn-danger" data-dismiss="modal">ยกเลิก</button>
            </div>
            <div class="col-6 text-center">
              <button type="submit" class="btn btn-primary">บันทึกข้อมูล</button>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
{{-- modal edit --}}
<div class="modal" id="modal-form-edit-material-unit" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">ฟอร์มแก้ไขหน่วยนับ</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form action="{{route('edit_material_unit')}}" method="POST" onsubmit="event.preventDefault();return SwalAskFormEdit(this)">
          @csrf
          <div class="form-row">
            <div class="col-12">
              <label for="">ชื่อหน่วยนับ</label>
              <input type="text" class="form-control" name="xvuntname" required>
            </div>
          </div>
          <div class="form-row mt-5">
            <div class="col-6 text-center">
              <button type="button" class="btn btn-danger" data-dismiss="modal">ยกเลิก</button>
            </div>
            <div class="col-6 text-center">
              <button type="submit" class="btn btn-primary">บันทึกข้อมูล</button>
            </div>
          </div>
          <input type="hidden" name="xvuntcode">
        </form>
      </div>
    </div>
  </div>
</div>
 <input type="hidden" name="msg" value="{{session()->get('msg')}}">
@endsection
<style>
  input{
     background-color: rgb(247, 247, 247) !important;
  }
  #tb_mat_unit tbody tr{
    cursor: pointer;
  }
  #tb_mat_unit tbody tr:hover{
     background-color:azure;
  }
  #tb_mat_unit tbody td{
    font-size: 14px;
    height: 35px;
    vertical-align: middle;
  }
  #tb_mat_unit_filter{
    margin-bottom: 1cm;
  }

</style>
<script src="{{asset('js/jquery-3.5.1.min.js')}}"></script>
<script src="{{asset('js/sweetalert.min.js')}}"></script>
<script src="{{asset('js/helper.js')}}"></script>

<script>
  $(document).ready(function(){
     if($('input[name="msg"]').val() == 'success'){
       swal("บันทึกข้อมูลเรียบร้อย", "คลิก ตกลง", "success");
     }
      if($('input[name="msg"]').val() == 'Duplicate'){
          swal("ชื่อหน่วยนับซ้ำ", "ชื่อหน่วยนับซ้ำ ไม่สามารถบันทึกได้", "warning");
      }
      if($('input[name="msg"]').val() == 'busy'){
          swal("ไม่สามารถลบได้", "ข้อมูลที่เลือกถูกใช้ในข้อมูลอื่น", "warning");
      }
      if($('input[name="msg"]').val() == 'busyEdit'){
          swal("ไม่สามารถแก้ไขได้", "ข้อมูลที่เลือกถูกใช้ในข้อมูลอื่น", "warning");
      }
     $('#tb_mat_unit').DataTable({
         "order": [],
         "language": {
             "search": "ค้นหา"
         }
     });
  })
  function open_modal(code,name){

    $('#modal-form-edit-material-unit input[name="xvuntcode"]').val(code);
    $('#modal-form-edit-material-unit input[name="xvuntname"]').val(name);
  }
  function del(id){
    swal({
      title: "คุณต้องลบข้อมูลหรือไม่",
      // text: "Once deleted, you will not be able to recover this imaginary file!",
      icon: "warning",
      buttons: true,
      dangerMode: true,
    })
    .then((willDelete)=>{
      if(willDelete == true){
        location.href = 'del_material_unit/'+id+'';
      }else{
        console.log('no')
      }
    })
  }
</script>
