@extends('layouts.master')
@section('content')
  <div class="card">
    <div class="card-body">
      <div class="row">
        <div class="col-6">
          <h5 style="font-weight: bold;">ผู้จัดจำหน่าย</h5>
        </div>
        <div class="col-6 text-right">
          <a href="{{route('frm_add_sup')}}" class="btn btn-success"><i class="fas fa-plus-square"></i> เพิ่มข้อมูล</a>
        </div>
      </div>
      <hr>
      <div class="row mt-5">
        <div class="col-12">
          <table id="tb_supplier" class="table table-striped table-sm" style="width:100%">
            <thead>
              <tr>
                <td style="width: 5%;">รหัส</td>
                <td style="width: 15%;">ชื่อ</td>
                <td style="width: 25%;">ที่อยู่</td>
                <td style="width: 15%;">ชื่อผู้ติดต่อ</td>
                <td style="width:10%;">โทรศัพท์</td>
                <td style="width:10%;">Email</td>
                <td style="10%;text-align:center;">ข้อมูล</td>
                <td style="10%;text-align:center;">แก้ไข</td>
                <td style="10%;text-align:center;">ลบ</td>
              </tr>
            </thead>
            <tbody>
              @foreach ($spls as $key => $spl)
                <tr>
                  <td style="width: 10%;">{{$spl->XVSplCode}}</td>
                  <td style="width: 15%;">{{$spl->XVSplName}}</td>
                  <td style="width: 25%;">{{$spl->XVSplAddress}}</td>
                  <td style="width: 15%;">{{$spl->xvsqlcontactname}}</td>
                  <td style="width:10%;">{{$spl->XVSplPhone}}</td>
                  <td style="width:10%;">{{$spl->XVSplEmail}}</td>
                  <td style="10%;text-align:center;"><a href="{{route('view_detail_supplier',$spl->XVSplCode)}}" class="btn-sm btn-warning"><i class="fas fa-eye"></i></a></td>
                  <td style="10%;text-align:center;"><a href="{{route('frm_edit_supplier',$spl->XVSplCode)}}" class="btn-sm btn-info"><i class="fas fa-edit"></i></a></td>
                  <td style="10%;text-align:center;"><a class="btn-sm btn-danger" onclick="del('{{$spl->XVSplCode}}');"><i class="fas fa-trash"></i></a></td>
                </tr>
              @endforeach
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
  <input type="hidden" name="msg" value="{{session()->get('msg')}}">
@endsection
<style>
  #tb_supplier thead{
    font-weight:bold;
    text-align: left;
  }
  #tb_supplier thead td{
    vertical-align: middle;
    height: 50px;
  }
  #tb_supplier tbody{
    font-size: 13px;
    text-align: left;
    font-weight:400;
  }
  #tb_supplier tbody tr:hover{
    cursor: pointer;
    background-color:azure;
  }
  #tb_supplier tbody td{
    height: 35px;
    vertical-align: middle;
  }
  #tb_supplier a{
      padding: 0.2cm 0.2cm 0.2cm 0.2cm;
    color: white;
  }
  #tb_supplier  i{
    text-align: center
  }
  #tb_supplier_filter{
    margin-bottom:1cm;
  }
</style>
<script src="js/jquery-3.5.1.min.js"></script>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script>
  $(document).ready(function() {
     if($('input[name="msg"]').val() == 'success'){
       swal("บันทึกข้อมูลเรียบร้อย", "คลิก ตกลง", "success");
     }
      if($('input[name="msg"]').val() == 'busy'){
          swal("ไม่สามารถลบได้", "ข้อมูลที่เลือกถูกใช้ในข้อมูลอื่น", "warning");
      }
      if($('input[name="msg"]').val() == 'busyEdit'){
          swal("ไม่สามารถแก้ไขได้", "ข้อมูลที่เลือกถูกใช้ในข้อมูลอื่น", "warning");
      }
      if ($('input[name="msg"]').val() == 'Duplicate') {
          swal("ไม่สามารถเพิ่ม / แก้ไขข้อมูลได้", "ข้อมูลที่เพิ่ม / แก้ไขมีชื่อผู้จัดจำหน่ายนี้แล้วภายในระบบ", "warning");
      }
    $('#tb_supplier').DataTable({
        "order": [],
        "language": {
            "search": "ค้นหา"
        }
    });
  });
  function del(id){
    swal({
      title: "คุณต้องลบข้อมูลผู้จัดจำหน่ายหรือไม่",
      // text: "Once deleted, you will not be able to recover this imaginary file!",
      icon: "warning",
      buttons: true,
      dangerMode: true,
    })
    .then((willDelete)=>{
      if(willDelete == true){
        location.href = 'del_supplier/'+id+'';
      }else{
        console.log('no')
      }
    })
  }
</script>
