<?php
    $menuperm = Illuminate\Support\Facades\Session::get('menu_perm') ?? [];
?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-6">
                    <h5 style="font-weight: bold;">ใบเบิกวัสดุ</h5>
                </div>
                <?php if(in_array(10,$menuperm)): ?>
                <div class="col-6 text-right">
                    <a href="<?php echo e(route('gi.addEmptyOr')); ?>" class="btn btn-success" ><i class="fas fa-plus-square"></i>
                        เพิ่มข้อมูล</a>
                    <a href="#" class="btn btn-info" data-toggle="modal" data-target="#exampleModalCenter"><i class="fas fa-plus-square"></i>
                        เพิ่มข้อมูลจากใบ Order</a>
                </div>
                <?php endif; ?>
               
            </div>
            <hr>
            <div class="row mt-5">
                <div class="col-12 table-responsive ">
                    <table id="tb_mat" class="table table-striped mt-5">
                        <thead class="thead-light">
                        <tr>
                            <td class="text-left">ลำดับ</td>
                            <td class="text-left">เลขที่ GI</td>
                            <td class="text-left">เลขที่ Order</td>
                            <td class="text-left">วันที่เอกสาร</td>
                            <td class="text-left">ผู้เบิก</td>

                            <td class="text-left">สถานะเอกสาร</td>
                            <td class="text-center">แก้ไข</td>
                            <td class="text-center">PDF</td>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $HD; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="text-left"><?php echo e($key += 1); ?></td>
                                <td class="text-left"><?php echo e($item->XVGihDocNo); ?></td>
                                <td class="text-left"><?php echo e($item->XVGihDocNoOR); ?></td>
                                <td class="text-left"><?php echo e(date_YmdTodmY($item->XDGihDocDate)); ?></td>
                                <td class="text-left"><?php echo e($item->name); ?></td>

                                <td class="text-left"><?php echo e(getDocStatusByCode($item->XVGihDocStatus)); ?></td>
                                <td class="text-center">
                                    <a href="<?php echo e(route('gi.edit',$item->XVGihDocNo)); ?>" class="btn-sm btn-info"><i
                                            class="fas fa-edit fa-1x"></i></a></td>
                                <td class="text-center">
                                    <?php if($item->XVGihDocStatus == "3"): ?>
                                    <a href="#" onclick="renderPdf('<?php echo e(route('gi.pdf',['docNo'=>$item->XVGihDocNo])); ?>')" class="btn-sm btn-info">
                                        <i class="far fa-file-pdf"></i></a>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal -->
    <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg " role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">เลือกใบเอกสารใบสั่งผลิต ( Order )</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row ">
                        <div class="col-12 table-responsive ">
                            <table id="tb_matOrder" class="table table-striped " style="width:100%";>
                                <thead class="thead-light">
                                <tr>
                                    <td class="text-left">ลำดับ</td>
                                    <td class="text-left">เลขที่ Order</td>
                                    <td class="text-left">วันที่เอกสาร</td>
                                    <td class="text-left">Number</td>

                                    <td class="text-left">ใบเบิกวัสดุ</td>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $RefHD; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="text-left"><?php echo e($key += 1); ?></td>
                                        <td class="text-left"><?php echo e($item->XVOrhDocNo); ?></td>
                                        <td class="text-left"><?php echo e(date_YmdTodmY($item->XDOrhDocDate)); ?></td>
                                        <td class="text-left"><?php echo e($item->xvpdtname); ?></td>

                                        <td class="text-left">
                                            <?php if($item->XVOrhDocStatus == "3"): ?>
                                                <a href="<?php echo e(route('gi.add',$item->XVOrhDocNo)); ?>" class="btn btn-info"><i
                                                        class="fas fa-edit fa-1x"></i>
                                                </a>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <input type="hidden" name="msg" value="<?php echo e(session()->get('msg')); ?>">
    <input type="hidden" id="url" value="<?php echo e(url('')); ?>">
<?php $__env->stopSection(); ?>
<style>
    #tb_mat thead {
        font-weight: bold;
    }

    #tb_mat tbody {
        font-size: 14px;
    }

    #tb_mat tbody tr:hover {
        background-color: azure;
    }

    #tb_mat tbody td {
        height: 35px;
        vertical-align: middle;
        cursor: pointer;
    }

    #tb_mat_filter {
        margin-bottom: 1cm;
        margin-top: 0.3cm;
    }
</style>
<script src="<?php echo e(asset('js/ThbNumber.js')); ?>"></script>
<script src="<?php echo e(asset('js/jquery-3.5.1.min.js')); ?>"></script>
<script src="<?php echo e(asset('js/sweetalert.min.js')); ?>"></script>
<script src="<?php echo e(asset('js/pdfmake.js')); ?>"></script>
<script src="<?php echo e(asset('js/pages/gi/pdf.js')); ?>"></script>

<script>
    $(document).ready(function () {
        if ($('input[name="msg"]').val() == 'success') {
            swal("บันทึกข้อมูลเรียบร้อย", "คลิก ตกลง", "success");
        }
        if ($('input[name="msg"]').val() == 'warning') {
            swal('มีรหัส Material นี้แล้ว', "กรุณาตั้งรหัส Material ใหม่", "warning")
        }
        if ($('input[name="msg"]').val() == 'error_duplicate') {
            swal('มีรหัส Unit นี้แล้ว', "กรุณาตั้งรหัส Unit ใหม่", "warning")
        }
        if ($('input[name="msg"]').val() == 'NoDataFound') {
            swal('กรุณาเลือกประเภท Unit ', "กรุณาเลือกประเภท Unit ของ Material", "warning")
        }
        if ($('input[name="msg"]').val() == 'NoDataFound_Factor') {
            swal('กรุณากรอกจำนวนสินค้าของประเภท Unit', "กรุณากรอกจำนวนสินค้าของประเภท Unit", "warning")
        }
        // New
        if ($('input[name="msg"]').val() == 'error_notfound') {
            swal('ไม่พบข้อมูล', "ไม่พบข้อมูลรายการแก้ไขที่เลือก", "warning")
        }

        $('#tb_mat').DataTable({
            "language": {
                "search": "ค้นหา"
            }
        });

        $('#tb_matOrder').DataTable({
            "language": {
                "search": "ค้นหา"
            }
        });
    })

    function setData(xvpdtcode, xvmatname) {
        $('#modal-form-material-mat input[name="xvpdtcode"]').val(xvpdtcode)
        $('#modal-form-material-mat .modal-title').text('เพิ่ม หน่วยนับ Material รหัส ' + xvpdtcode);
    }

    function del(id) {
        swal({
            title: "คุณต้องลบข้อมูลหรือไม่",
            // text: "Once deleted, you will not be able to recover this imaginary file!",
            icon: "warning",
            buttons: true,
            dangerMode: true,
        })
            .then((willDelete) => {
                if (willDelete == true) {
                    let formID = "frm_" + id
                    let frm = document.getElementById(formID)
                    frm.submit()
                }
            })
    }

    function del_Size(xvpdtcode, xvSizeName) {
        swal({
            title: "คุณต้องลบ Size :" + xvSizeName + " ของ Product รหัส " + xvpdtcode + " หรือไม่",
            // text: "Once deleted, you will not be able to recover this imaginary file!",
            icon: "warning",
            buttons: true,
            dangerMode: true,
        })
            .then((willDelete) => {
                if (willDelete == true) {
                    let formID = `pdt_${xvpdtcode}_size_${xvSizeName}`
                    let frm = document.getElementById(formID)
                    frm.submit()
                    // location.href = 'del_material_mat/' + xvpdtcode + '/' + xvuntcode + '';
                }
            })
    }
</script>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\vk-2\resources\views/Gi/index.blade.php ENDPATH**/ ?>