<?php
    use Illuminate\Support\Facades\DB;
    $customer = DB::table('tmstmcustomer')->orderBy('XVCstCode','desc')->get();
?>
<style>
    /*Select2 ReadOnly Start*/
    select[readonly].select2-hidden-accessible + .select2-container {
        pointer-events: none;
        touch-action: none;
    }

    select[readonly].select2-hidden-accessible + .select2-container .select2-selection {
        background: #eee;
        box-shadow: none;
    }

    select[readonly].select2-hidden-accessible + .select2-container .select2-selection__arrow, select[readonly].select2-hidden-accessible + .select2-container .select2-selection__clear {
        display: none;
    }

    /*Select2 ReadOnly End*/
</style>
<input type="hidden" class="form-control" id="oldValueCustomer" value="<?php echo e($oldValue ?? ''); ?>">
<div class="form-group row mt-2 mb-1 pb-0" >
    <label class="col-md-4  col-xl-2 col-form-label">ลูกค้า</label>
    <div class="col-10" >
        <select class="form-control" id="SelectCustomer" 
                <?php if(isset($isMultiple) && $isMultiple== true): ?> multiple <?php endif; ?>
                <?php if(isset($isRequired) && $isRequired== true): ?> required <?php endif; ?>
                <?php if(isset($isReadOnly) && $isReadOnly== true): ?> readonly <?php endif; ?>
                name="XVCstCode">
            <option></option>
            <?php $__currentLoopData = $customer; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option
                    data-raw="<?php echo e(json_encode($item)); ?>"
                    <?php if(isset($oldValue) && $oldValue==$item->XVCstCode): ?>
                    selected
                    <?php endif; ?>
                    value="<?php echo e($item->XVCstCode); ?>"><?php echo e($item->XVCstCode); ?> <?php echo e($item->XVCstName); ?> <?php echo e($item->XVCstAddress); ?> <?php echo e($item->XVCstPhone); ?> <?php echo e($item->XVCstTaxID); ?> <?php echo e($item->XVCstEmail); ?> <?php echo e($item->XVCstFax); ?> <?php echo e($item->XVCstContacName); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>

</div>
<div class="form-group row mb-1 pb-0">
    <label class="col-md-4  col-xl-2 col-form-label">ชื่อผู้ติดต่อ</label>
    <div class="col">
        <input type="text" class="form-control col" name="XVCstContacName"
               readonly
               id="XVCstContacName">
    </div>

</div>
<div class="form-group row mb-1 pb-0">
    <label class="col-md-4  col-xl-2 col-form-label">ชื่อลูกค้า</label>
    <div class="col">
        <input type="text" class="form-control" name="XVCstName"
               readonly
               id="XVCstName">
    </div>
</div>
<div class="form-group row mb-1 pb-0">
    <label class="col-md-4  col-xl-2 col-form-label">ที่อยู่</label>
    <div class="col">
       <textarea type="text" class="form-control" name="XVCstAddress"
                 readonly
                 id="XVCstAddress"
                 rows="2"></textarea>
    </div>
</div>
<div class="form-group row mb-1 pb-0">
    <label class="col-md-4  col-xl-2 col-form-label">โทรศัพท์</label>
    <div class="col">
        <input type="text" class="form-control" name="XVCstPhone"
               readonly
               id="XVCstPhone">
    </div>
</div>
<div class="form-group row mb-1 pb-0">
    <label class="col-md-4  col-xl-2 col-form-label">Fax</label>
    <div class="col">
        <input type="text" class="form-control col" name="XVCstFax"
               readonly
               id="XVCstFax">
    </div>
</div>
<div class="form-group row mb-0 pb-0">
    <label class="col-md-4  col-xl-2 col-form-label">Email</label>
    <div class="col">
        <input type="text" class="form-control" name="XVCstEmail"
               readonly
               id="XVCstEmail">
    </div>
</div>
<script>
    $(document).ready(function () {
        function i(id) {
            return document.getElementById(id);
        }

        const XVCstContacName = i('XVCstContacName');
        const XVCstName = i('XVCstName');
        const XVCstAddress = i('XVCstAddress');
        const XVCstPhone = i('XVCstPhone');
        const XVCstFax = i('XVCstFax');
        const XVCstEmail = i('XVCstEmail');

        const oldValueCustomer = i('oldValueCustomer')

        const Customer = $('#SelectCustomer').select2({
            placeholder: "เลือกลูกค้า",
            theme: 'bootstrap4',
        });
        if (oldValueCustomer.value) {
            let rawData = Customer.find(':selected');
            rawData = JSON.parse(rawData[0].attributes[0].nodeValue)
            PushData(rawData)
        }
        $('#SelectCustomer').on('select2:select', function (e) {
            let rawData = JSON.parse(e.params.data?.element?.attributes[0]?.nodeValue) ?? [];
            PushData(rawData);
        });

        function PushData(rawData) {
            XVCstContacName.value = rawData.XVCstContacName
            XVCstName.value = rawData.XVCstName
            XVCstAddress.value = rawData.XVCstAddress
            XVCstPhone.value = rawData.XVCstPhone
            XVCstFax.value = rawData.XVCstFax
            XVCstEmail.value = rawData.XVCstEmail
        }
    })
</script>
<?php /**PATH C:\xampp\htdocs\vk-2\resources\views/Components/Customer.blade.php ENDPATH**/ ?>