<?php

namespace App\Exports;

use App\Torder_bc;
use Maatwebsite\Excel\Concerns\FromCollection;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;

use PhpOffice\PhpSpreadsheet\Cell\Cell;
use Maatwebsite\Excel\Concerns\ToModel;
use PhpOffice\PhpSpreadsheet\Cell\DataType;
use Maatwebsite\Excel\Concerns\WithCustomValueBinder;
use PhpOffice\PhpSpreadsheet\Cell\DefaultValueBinder;


class BarcodeExport implements FromCollection, WithHeadings
#, WithCustomValueBinder
{
    /**
     * @return \Illuminate\Support\Collection
     */
    public function __construct(string $docNo, string $sizecode)
    {
        $this->docNo = $docNo;
        $this->sizecode = $sizecode;
    }

    public function collection()
    {

        return torder_bc::select("torder_bc.XVOrderBCode", 'torder_hd.XVOrderIn')
            ->join('torder_hd', 'torder_hd.XVOrderDocNo', 'torder_bc.XVOrderDocNo')
            ->where('torder_hd.XVOrderDocNo', $this->docNo)
            ->where('torder_bc.XVOrderBSize', $this->sizecode)
            ->get();
    }

    public function headings(): array
    {
        return [
            'Barcode', 'รหัสภายใน'
        ];
    }

}
