<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use App\TMtotalsew;
use App\tmgenerate;
use App\tmcustomer;
use App\Tdocprexp;
use App\Torder_hd;
use App\Torder_bc;
use App\Torder_dt;
use App\TMblench;
use App\tmforuse;
use App\TMshape;
use App\TMsew;
use App\Exports\BarcodeExport;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\DB;

/**
 * Class DashboardController.
 */
class BarcodeController extends Controller
{
    /**
     * @return \Illuminate\View\View
     */
    public function index()
    {
        return view('admin.barcode.index');
    }

    public function create()
    {
        return view('admin.barcode.create');
    }

    public function edit($docNo)
    {
        // abort_unless(\Gate::allows('order_edit'), 403);

        $sizes = \DB::table('tmsize')->get();
        $customer     = TMcustomer::all();
        $foruse       = TMforuse::all();
        $forms        = TMgenerate::all();
        $shape        = TMshape::all();
        $sews         = TMsew::all();
        $totalsews    = TMtotalsew::all();
        $blenchs      = TMblench::all();
        $order_hd     = Torder_hd::getoder_hd()->where('XVOrderDocNo', '=', $docNo)->first();
        $order_hd->XDOrderDocMDate = Carbon::createFromFormat('Y-m-d', $order_hd->XDOrderDocMDate)->format('d/m/Y');
        $order_dt     = Torder_dt::where('XVOrderDocNo', '=', $docNo)->get();


        $order_bc = \DB::table('torder_bc')
            ->join('torder_dt', 'torder_bc.XVOrderDocNo', '=', 'torder_dt.XVOrderDocNo')

            ->selectRaw('XVOrderBSize,MIN(XVOrderBCode) as  minBar ,MAX(XVOrderBCode) as maxBar,MIN(XIOrderDTotalNum) XIOrderDTotalNum')
            ->where('torder_bc.XVOrderDocNo', '=', $docNo)
            ->groupBy('XVOrderBSize')
            ->get()->toArray();

        // dd($order_bc);

        $order = [
            'order_hd'     => $order_hd,
            'order_dt'     => $order_dt,
            'order_bc'     => $order_bc,
            'XVOrderDocNo' => $order_hd->XVOrderDocNo,
            'customer'     => $customer,
            'foruse'       => $foruse,
            'forms'        => $forms,
            'shape'        => $shape,
            'sews'         => $sews,
            'totalsews'    => $totalsews,
            'blenchs'      => $blenchs,
            'sizes'        => $sizes
        ];



        return view('admin.barcode.edit', compact('order'));
    }

    public function getData(Request $request)
    {


        $draw = $request->get('draw');
        $start = $request->get('start');
        $length = $request->get('length');


        $search = (isset($filter['value'])) ? $filter['value'] : false;

        $sql = \DB::table('torder_hd')
            ->join('tmcustomer', 'tmcustomer.XIGuestCode', 'torder_hd.XIGuestCode')
            ->join('tmforuse', 'tmforuse.XIForCode', 'torder_hd.XIForCode')
            ->join('tmgenerate', 'tmgenerate.XIGenerateCode', 'torder_hd.XIGenerateCode')
            ->join('tmshape', 'tmshape.XIShapeCode', 'torder_hd.XIShapeCode')
            ->select('torder_hd.*', 'XVGuestName', 'XVForType', 'XVGenerateName', 'XVShapeName', 'XVOrderDocNo as key')
            ->whereIn('torder_hd.XCStatus', [1, 2]);

        $AllData = $sql->count();

        $total_members = $AllData; // get your total no of data;
        $data = $sql->limit($start, $length)->get();

        $data = array(
            'draw' => $draw,
            'recordsTotal' => $total_members,
            'recordsFiltered' => $total_members,
            'data' => $data,
        );

        print  json_encode($data);
    }

    public function export($docNo, $size_code)
    {
        // $xx = new BarcodeExport($docNo, $size_code);
        // dd($docNo, $size_code,$xx);
        return Excel::download(new BarcodeExport($docNo, $size_code), $docNo . '_' . $size_code . '.csv');
    }

    public function show(Request $request){
        return view('admin.barcode.sendItem');
    }
    public function SendItemgetData(Request $request)
    {


        $draw = $request->get('draw');
        $start = $request->get('start');
        $length = $request->get('length');


        $search = (isset($filter['value'])) ? $filter['value'] : false;

        $sql = \DB::table('torder_hd')
            ->join('torder_dt', 'torder_dt.XVOrderDocNo', 'torder_hd.XVOrderDocNo')
            ->join('torder_bc', 'torder_bc.XVOrderDocNo', 'torder_hd.XVOrderDocNo')
            ->whereNull('torder_dt.XDDateOutvk')
            ->whereNull('torder_dt.XIOrderSand')
            ->where('torder_bc.XVOrderBLocation','=','1')
            ->groupby('torder_hd.XVOrderDocNo','torder_dt.XVOrderDSize')
            ->select('torder_hd.XVOrderDocNo','torder_hd.XVOrderIn','torder_hd.XVOrderDetail'
                ,'torder_dt.XVOrderDSize','torder_dt.XIOrderDTotalNum');
//        $sql = \collect($sql);

        $AllData = $sql->count();

        $total_members = $AllData; // get your total no of data;
        $data = $sql->limit($start, $length)->get();

        $data = array(
            'draw' => $draw,
            'recordsTotal' => $total_members,
            'recordsFiltered' => $total_members,
            'data' => $data,
        );

        print  json_encode($data);
    }

    public function showConfirmSendItem($Docno,$OrderIn,$DSize,$TotalNum){
        return view('admin.barcode.senditem_confirm',[
            'Docno'=>$Docno,
            'OrderIn'=>$OrderIn,
            'Dsize'=>$DSize,
            'TotalNum'=>$TotalNum
        ]);

    }

    public function confirmSendItem(Request $request){


        $data = $request->all(); // This will get all the request data.

//        dd($data); // This will dump and die

        $validator = $this->SendItem_rules($data);
        if($validator->fails())
        {
//            dd($validator);
            return redirect()->back()->withErrors($validator)->withInput();
        }
//        dd($request->all());
        try{
            $id = DB::table('torder_dt')
                ->where('XVOrderDocNo',$request->Docno)
                ->where('XVOrderDSize',$request->Dsize)
                ->update(
                    [
                        "XDDateOutvk" => \DB::raw('NOW()'),
                        "XIOrderSand" => $request->TotalNum,
                    ]
                );
            return redirect()->route('admin.barcode.sendItem')->with("success",'ยืนยันการส่งสินค้าสำเร็จ');
        }catch (QueryException  $e){
            return redirect()->route('admin.barcode.sendItem')->with("failed",'ยืนยันการส่งสินค้าไม่สำเร็จ :'.$e->getMessage());
        }
    }

    public function SendItem_rules($data)
    {
        $messages = [
            'Docno.required'=>'กรุณากรอกข้อมูล',
            'OrderIn.required'=>'กรุณากรอกข้อมูล',
            'Dsize.required'=>'กรุณากรอกข้อมูล',
            'TotalNum.required'=>'กรุณากรอกข้อมูล',
        ];

        $validator = \Validator::make($data, [
            "Docno" => 'required',
            "OrderIn" => 'required',
            "Dsize" => 'required',
            "TotalNum" => 'required',

        ], $messages);

        return $validator;
    }
}
