<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Carbon\Carbon;
use App\TMtotalsew;
use Auth;
use PDF;

class BorrowController extends Controller
{

    public function index()
    {
        return view('admin.borrow.index');
    }


    public function create()
    {
        return view('admin.borrow.create');
    }

    public function updateBorrow(Request $request)
    {
        // dd($request->barcode);
        \DB::table('torder_bc')
                    ->where('XVOrderBCode', $request->get('barcode'))
                    ->update(
                        [
                            'XVOrderBLocation' => $request->get('location'),
                            'XVComment' => $request->get('comment'),
                            'XVWhoEdit' => \Auth::user()->name,
                            'XTWhenEdit' => date("Y-m-d H:i:s"),
                        ]);


        return response()->json([
                'success' => '1'
                ]);
    }

    public function checkBarcode(Request $request)
    {
        $res = \DB::table('torder_bc')
                ->leftJoin('tmsize','torder_bc.XVOrderBSize','tmsize.size_id')
                ->where('torder_bc.XVOrderBCode', $request->barcode)->first();
        if (!$res) {
            return response()->json([
                'success'     =>  '0',
                ]);
        }else{
            return response()->json([
                'success'     =>  '1',
                'XVComment'   => @$res->XVComment,
                'XVOrderBLocation' =>@$res->XVOrderBLocation
                ]);
        }
    }

    public function showBarcode()
    {
        return view('Admin.borrow.show');
    }

    public function showTable()
    {
        $sql="select * from torder_inout where XIIOSta='17' order by XIIOID desc";
        $data = \DB::select($sql);
        $data = array(
            'data' => $data,
        );
        // dd($data);
        print json_encode($data);
    }

    public function store(Request $request)
    {
        // dd($request);

        $XDIODate=Carbon::createFromFormat('d/m/Y',$request->XDIODate)->format('Y-m-d');
        // $XIIOinoutedit = $request->XIIOinoutedit == 'true'? 0:1;
        // //dd($XIIOinoutedit);

        DB::beginTransaction();
        try {
                DB::table('torder_inout')->insert(
                    [
                        'XDIODate'          => $XDIODate,
                        'XIStVkID'          => $request->XIStVkID,
                        'XVOrderIn'         => $request->XVOrderIn,
                        'XVStVkSize'        => $request->XVStVkSize,
                        'XVIOSKUin'         => $request->XVIOSKUin,
                        'XIIONum'           => $request->XIIONum,
                        'XVOinoutNote'      => $request->XVOinoutNote,
                        'XIIOSta'           => "17",
                        'XIIOinorout'       => "1",
                        'XTWhenCreate'      => DB::Raw('now()'),
                        'XTWhenEdit'        => DB::Raw('now()'),
                        'XVWhoCreate'       => Auth::user()->name,
                        'XVWhoEdit'         => Auth::user()->name,
                    ]
                );
            DB::commit();
            } catch (\Exception $e) {
                //echo $e;
                DB::rollBack();
                abort(500, 'Internal error');
            }
            return redirect('admin/borrow')->with('message','บันทึกสำเร็จ');

    }


}
