<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\GennarateidController;
use App\Http\Requests\MassDestroybranchRequest;
use App\Http\Requests\StorebranchRequest;
use App\Http\Requests\UpdatebranchRequest;
use App\TMbranch;

use Illuminate\Support\Facades\Auth;

class BranchController extends Controller
{
    public function index()
    {

        // abort_unless(\Gate::allows('branch_access'), 403);

        $resAll  = TMbranch::all();

        return view('admin.branch.index', compact('resAll'));
    }

    public function create()
    {
        abort_unless(\Gate::allows('branch_create'), 403);

        return view('admin.branch.create');
    }

    public function store(StorebranchRequest $request)
    {

        abort_unless(\Gate::allows('branch_create'), 403);

        $request->request->add(['XVWhoCreate' => Auth::user()->name]);
        $request->request->add(['XVWhoEdit' => Auth::user()->name]);
        $branch = TMbranch::create($request->all());

        return redirect()->route('admin.branch.index');
    }

    public function edit(TMbranch $branch)
    {

        abort_unless(\Gate::allows('branch_edit'), 403);


        return view('admin.branch.edit', compact('branch'));
    }

    public function update(UpdatebranchRequest $request, TMbranch $branch)
    {

        abort_unless(\Gate::allows('branch_edit'), 403);
        $request->request->add(['XVWhoEdit' => Auth::user()->name]);

        $branch->update($request->all());

        return redirect()->route('admin.branch.index');
    }

    public function show(TMbranch $branch)
    {

        abort_unless(\Gate::allows('branch_show'), 403);

        return view('admin.branch.index', compact('branch'));
    }

    public function destroy(TMbranch $branch)
    {
        abort_unless(\Gate::allows('branch_delete'), 403);
        $branch->delete();

        return back();
    }

    public function massDestroy(MassDestroybranchRequest $request)
    {
        abort_unless(\Gate::allows('branch_delete'), 403);

        //add request
        TMbranch::whereIn('XIBranchCode', request('ids'))->delete();

        return response(null, 204);
    }
}
