<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;


/**
 * Class DashboardController.
 */
class EditSizeBarcodeController extends Controller
{
    /**
     * @return \Illuminate\View\View
     */
    public function index()
    {
        $size = \DB::table('tmsize')->orderBy('size_name')->get();
        return view('admin.editsizebarcode.index',compact('size',$size));
    }

    public function create()
    {
        return view('admin.editsizebarcode.create');
    }

    public function edit()
    {
        return view('admin.editsizebarcode.edit');
    }

    public function checkBarcode(Request $request)
    {
        $res = \DB::table('torder_bc')
                    ->leftJoin('tmsize','torder_bc.XVOrderBSize','tmsize.size_id')
                    ->where('torder_bc.XVOrderBCode', $request->barcode)->first();

        if (!$res) {
            return response()->json([
                'success'     =>  '0',
                'size'        => ''
                ]);
        }else{
            return response()->json([
                'success'     =>  '1',
                'size'        => @$res->size_name
                ]);
        }
    }

    public function updateSize(Request $request)
    {

        \DB::table('torder_bc')
                    ->where('XVOrderBCode', $request->barcode)
                    ->update(
                        [
                            'XVOrderBSize' => $request->size,
                            'XVWhoEdit' => \Auth::user()->name,
                            'XTWhenEdit' => date("Y-m-d H:i:s"),
                        ]);


        return response()->json([
                'success' => '1'
                ]);
    }



}
