<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\GennarateidController;
use App\Http\Requests\MassDestroyForuseRequest;
use App\Http\Requests\StoreForuseRequest;
use App\Http\Requests\UpdateForuseRequest;
use App\tmforuse;

use Illuminate\Support\Facades\Auth;

class ForuseController extends Controller
{

    protected $TMforuse;

    public function __construct(tmforuse $TMforuse)
    {
        $this->TMforuse = $TMforuse;
    }

    public function index()
    {

        abort_unless(\Gate::allows('foruse_access'), 403);

        $foruse = $this->TMforuse::all();

        // dd($foruse);

        return view('admin.foruse.index', compact('foruse'));
    }

    public function create()
    {
        abort_unless(\Gate::allows('foruse_create'), 403);

        return view('admin.foruse.create');
    }

    public function store(StoreForuseRequest $request)
    {

        abort_unless(\Gate::allows('foruse_create'), 403);


        //add request

        $request->request->add(['XVWhoEdit' => Auth::user()->name]);
        $request->request->add(['XVWhoCreate' => Auth::user()->name]);
        $foruse = TMforuse::create($request->all());

        return redirect()->route('admin.foruse.index');
    }

    public function edit(TMforuse $foruse)
    {

        abort_unless(\Gate::allows('foruse_edit'), 403);

        return view('admin.foruse.edit', compact('foruse'));
    }

    public function update(UpdateForuseRequest $request, TMforuse $foruse)
    {

        abort_unless(\Gate::allows('foruse_edit'), 403);

        //add request
        $request->request->add(['XVWhoEdit' => Auth::user()->name]);
        $foruse->update($request->all());

        return redirect()->route('admin.foruse.index');
    }

    public function show(TMforuse $foruse)
    {
        abort_unless(\Gate::allows('foruse_show'), 403);

        return view('admin.foruse.show', compact('foruse'));
    }

    public function destroy(TMforuse $foruse)
    {
        abort_unless(\Gate::allows('foruse_delete'), 403);

        $foruse->update(['XVWhoEdit' => Auth::user()->name]);
        $foruse->delete();

        return back();
    }

    public function massDestroy(MassDestroyForuseRequest $request)
    {
        abort_unless(\Gate::allows('foruse_delete'), 403);

        //add request
        TMforuse::whereIn('XIForCode', request('ids'))->update(['XVWhoEdit' => Auth::user()->name]);
        TMforuse::whereIn('XIForCode', request('ids'))->delete();

        return response(null, 204);
    }
}
