<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Imports\BoxsImport;
use App\Torder_cuspo;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Facades\Excel;
use Maatwebsite\Excel\HeadingRowImport;
use DateTime;
use Carbon\Carbon;
/**
 * Class DashboardController.
 */
class ImportExcelController extends Controller
{
    /**
     * @return \Illuminate\View\View
     */
    public function index()
    {
        return view('admin.importexcel.index');
    }

    public function create()
    {
        return view('admin.importexcel.create');
    }

    public function edit()
    {
        return view('admin.importexcel.edit');
    }

    function validateDate($date, $format = 'd-m-Y')
    {
        $d = DateTime::createFromFormat($format, $date);
        // The Y ( 4 digits year ) returns TRUE for any integer with any number of digits so changing the comparison from == to === fixes the issue.
        return $d && $d->format($format) === $date;
    }
    public function getData(Request $request)
    {

        DB::statement(DB::raw('set @row:=0'));
        $sql = DB::table('torder_box')->selectRaw('*, @row:=@row+1 as row');


        // dd($sql);
        $totalData = $sql->get()->count();


        $totalFiltered = $totalData;

        $limit = $request->input('length');
        $start = $request->input('start');


        if (empty($request->input('search.value'))) {
            $datas = $sql->offset($start)
                ->limit($limit)
                ->orderByDesc('XTWhenCreate')
                ->get();
        } else {
            $search = $request->input('search.value');
            if($this->validateDate($search)){
                // $d = DateTime::createFromFormat($search,'');
                $search = Carbon::createFromFormat('d-m-Y', $search)->format('Y-m-d');
                // dd($dt);
            }
            $datas =  $sql->whereRaw('(XVPONbr LIKE "%' . $search . '%"
                                        OR XVStoreNbr LIKE "%' . $search . '%"
                                        OR XVUPCCode LIKE "%' . $search . '%"
                                        OR XVSKUCode LIKE "%' . $search . '%"
                                        OR XVDescription LIKE "%' . $search . '%"
                                        OR XDDateInDelivery Like "%' . $search . '%"
                                        )
                                    ')
                ->offset($start)
                ->limit($limit)
                ->orderByDesc('XTWhenCreate')
                ->get();

            $totalFiltered = $sql->whereRaw('(XVPONbr LIKE "%' . $search . '%"
                                        OR XVStoreNbr LIKE "%' . $search . '%"
                                        OR XVUPCCode LIKE "%' . $search . '%"
                                        OR XVSKUCode LIKE "%' . $search . '%"
                                        OR XVDescription LIKE "%' . $search . '%"
                                        OR XDDateInDelivery Like "%' . $search . '%"
                                        )
                                    ')
                ->count();
        }


        $json_data = array(
            "draw"            => intval($request->input('draw')),
            "recordsTotal"    => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data"            => $datas
        );

        dd($json_data);


        echo json_encode($json_data);
    }

    function import(Request $request)
    {
        $this->validate($request, [
            'select_file'  => 'required|mimes:xls,xlsx'
        ]);



        // $headings = (new BoxsImport)->toArray('users.xlsx');
        Excel::import(new BoxsImport, request()->file('select_file'));
        $roles = \DB::table('torder_cuspo')->get();

        $order = [
            'roles' => $roles
        ];

        // dd($request);
        // return back()->with('success', 'Excel Data Imported successfully.');
        return view('admin.sendimportfile.index', compact('order'));
    }
}
