<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Auth;
use PDF;
/**
 * Class DashboardController. 
 */
class PpeController extends Controller
{
    /**
     * @return \Illuminate\View\View
     */
    public function index()
    {
        //dd('aaa');
        return view('admin.ppe.index');
    }

    public function create()
    {
        //dd('PPE Create');
        return view('admin.ppe.create');
        //return view('admin.scanpackking.create');
    }

    public function store(Request $request)
    {

        $XDPpeOrderDate= !empty($request->XDPpeOrderDate) ? Carbon::createFromFormat('d/m/Y', $request->XDPpeOrderDate)->format('Y-m-d') : null;
        $XDPpeSendDate=  !empty($request->XDPpeSendDate) ? Carbon::createFromFormat('d/m/Y', $request->XDPpeSendDate)->format('Y-m-d') : null;
        $XDPpeDateSal=  !empty($request->XDPpeDateSal) ? Carbon::createFromFormat('d/m/Y', $request->XDPpeDateSal)->format('Y-m-d') : null;
        $XVPpeStaSal = $request->XVPpeStaSal == 'true'? 1:0;
        $XVPpeStaSend = $request->XVPpeStaSend == 'true'? 1:0;



        DB::beginTransaction();
        try {
                DB::table('torder_ppe')->insert(
                    [
                        'XVPpeOrderId'      => $request->XVPpeOrderId,
                        'XDPpeOrderDate'    => $XDPpeOrderDate,
                        'XVPpeContactName'  => $request->XVPpeContactName,
                        'XVPpeContactTel'   => $request->XVPpeContactTel,
                        'XIIsoNum'          => $request->XIIsoNum,
                        'XIAntiNumM'        => $request->XIAntiNumM,
                        'XIAntiNumL'        => $request->XIAntiNumL,
                        'XIOverM'           => $request->XIOverM,
                        'XIOverL'           => $request->XIOverL,
                        'XIOverXL'          => $request->XIOverXL,
                        'XIOver2XL'         => $request->XIOver2XL,
                        'XVPpeDonateName'    => $request->XVPpeDonateName,
                        'XVPpeRecipName'    => $request->XVPpeRecipName,
                        'XVPpeSendTel'      => $request->XVPpeSendTel,
                        'XVPpeSendAdd'      => $request->XVPpeSendAdd,
                        'XDPpeSendDate'     => $XDPpeSendDate,
                        'XVPpeInvNo'        => $request->XVPpeInvNo,
                        'XVPpeNameInv'      => $request->XVPpeNameInv,
                        'XVPpeTelInv'       => $request->XVPpeTelInv,                        
                        'XVPpeInvAdd'       => $request->XVPpeInvAdd,
                        'XVPpeStaSal'       => $XVPpeStaSal,
                        'XFPpeInvSal'       => $request->XFPpeInvSal,
                        'XDPpeDateSal'      => $XDPpeDateSal,
                        'XVPpeStaSend'      => $XVPpeStaSend,
                        'XTWhenCreate'      => DB::Raw('now()'),
                        'XTWhenEdit'        => DB::Raw('now()'),
                        'XVWhoCreate'       => Auth::user()->name,
                        'XVWhoEdit'         => Auth::user()->name,
                    ]
                );
            DB::commit();
            } catch (\Exception $e) {
                //echo $e;
                DB::rollBack();
                abort(500, 'Internal error');
            }
            return redirect('admin/ppe')->with('message','บันทึกสำเร็จ');
    }


    public function edit($id)
    {
        $data = DB::table('torder_ppe')->where('XIPpeCode','=',$id)->first();
        //dd($data);
        return view('admin.ppe.edit',['data' => $data]);
    }

    public function update(Request $request,$id)
    {
        $XDPpeOrderDate= !empty($request->XDPpeOrderDate) ? Carbon::createFromFormat('d/m/Y', $request->XDPpeOrderDate)->format('Y-m-d') : null;
        $XDPpeSendDate=  !empty($request->XDPpeSendDate) ? Carbon::createFromFormat('d/m/Y', $request->XDPpeSendDate)->format('Y-m-d') : null;
        $XDPpeDateSal=  !empty($request->XDPpeDateSal) ? Carbon::createFromFormat('d/m/Y', $request->XDPpeDateSal)->format('Y-m-d') : null;
        $XVPpeStaSal = $request->XVPpeStaSal == 'true'? 1:0;
        $XVPpeStaSend = $request->XVPpeStaSend == 'true'? 1:0;

        DB::beginTransaction();
        try {
                DB::table('torder_ppe') ->where('XIPpeCode','=',$id)
                ->update(
                    [
                        'XVPpeOrderId'      => $request->XVPpeOrderId,
                        'XDPpeOrderDate'    => $XDPpeOrderDate,
                        'XVPpeContactName'  => $request->XVPpeContactName,
                        'XVPpeContactTel'   => $request->XVPpeContactTel,
                        'XIIsoNum'          => $request->XIIsoNum,
                        'XIAntiNumM'        => $request->XIAntiNumM,
                        'XIAntiNumL'        => $request->XIAntiNumL,
                        'XIOverM'           => $request->XIOverM,
                        'XIOverL'           => $request->XIOverL,
                        'XIOverXL'          => $request->XIOverXL,
                        'XIOver2XL'         => $request->XIOver2XL,
                        'XVPpeDonateName'    => $request->XVPpeDonateName,
                        'XVPpeRecipName'    => $request->XVPpeRecipName,
                        'XVPpeSendTel'      => $request->XVPpeSendTel,
                        'XVPpeSendAdd'      => $request->XVPpeSendAdd,
                        'XDPpeSendDate'     => $XDPpeSendDate,
                        'XVPpeInvNo'        => $request->XVPpeInvNo,
                        'XVPpeNameInv'      => $request->XVPpeNameInv,
                        'XVPpeTelInv'       => $request->XVPpeTelInv,
                        'XVPpeInvAdd'       => $request->XVPpeInvAdd,
                        'XVPpeStaSal'       => $XVPpeStaSal ,
                        'XFPpeInvSal'       => $request->XFPpeInvSal,
                        'XDPpeDateSal'      => $XDPpeDateSal,
                        'XVPpeStaSend'      => $XVPpeStaSend,
                        'XTWhenEdit'        => DB::Raw('now()'),
                        'XVWhoEdit'         => Auth::user()->name, 

                        ]
                );
            DB::commit();
            } catch (\Exception $e) {
                DB::rollBack();
                abort(500, 'Internal error');
            }
            return redirect('admin/ppe')->with('message','บันทึกสำเร็จ');
    }

    public function LabelReportPdf($id)
    {

        $data = DB::table('torder_ppe')->where('XIPpeCode','=',$id)->first();
        $pdf = PDF::loadView('admin.ppe.label_report_pdf', compact('data'));
        return $pdf->stream();
    }

    public function copyid($id)
    {

        $request = DB::table('torder_ppe')->where('XIPpeCode','=',$id)->first();
        // dd($request);
        // $XDPpeOrderDate= !empty($request->XDPpeOrderDate) ? Carbon::createFromFormat('d/m/Y', $request->XDPpeOrderDate)->format('Y-m-d') : null;
        // $XDPpeSendDate=  !empty($request->XDPpeSendDate) ? Carbon::createFromFormat('d/m/Y', $request->XDPpeSendDate)->format('Y-m-d') : null;
        // $XDPpeDateSal=  !empty($request->XDPpeDateSal) ? Carbon::createFromFormat('d/m/Y', $request->XDPpeDateSal)->format('Y-m-d') : null;
        // $XVPpeStaSal = $request->XVPpeStaSal == 'true'? 1:0;
        // $XVPpeStaSend = $request->XVPpeStaSend == 'true'? 1:0;

        DB::beginTransaction();
        try {
                DB::table('torder_ppe')->insert(
                    [
                        'XVPpeOrderId'      => $request->XVPpeOrderId,
                        'XDPpeOrderDate'    => $request->XDPpeOrderDate,
                        'XVPpeContactName'  => $request->XVPpeContactName,
                        'XVPpeContactTel'   => $request->XVPpeContactTel,
                        'XIIsoNum'          => $request->XIIsoNum,
                        'XIAntiNumM'        => $request->XIAntiNumM,
                        'XIAntiNumL'        => $request->XIAntiNumL,
                        'XIOverM'           => $request->XIOverM,
                        'XIOverL'           => $request->XIOverL,
                        'XIOverXL'          => $request->XIOverXL,
                        'XIOver2XL'         => $request->XIOver2XL,
                        'XVPpeDonateName'    => $request->XVPpeDonateName,
                        'XVPpeRecipName'    => $request->XVPpeRecipName,
                        'XVPpeSendTel'      => $request->XVPpeSendTel,
                        'XVPpeSendAdd'      => $request->XVPpeSendAdd,
                        'XDPpeSendDate'     => $request->XDPpeSendDate,
                        'XVPpeInvNo'        => $request->XVPpeInvNo,
                        'XVPpeNameInv'      => $request->XVPpeNameInv,
                        'XVPpeTelInv'       => $request->XVPpeTelInv,                        
                        'XVPpeInvAdd'       => $request->XVPpeInvAdd,
                        'XVPpeStaSal'       => $request->XVPpeStaSal,
                        'XFPpeInvSal'       => $request->XFPpeInvSal,
                        'XDPpeDateSal'      => $request->XDPpeDateSal,
                        'XVPpeStaSend'      => $request->XVPpeStaSend,
                        'XTWhenCreate'      => DB::Raw('now()'),
                        'XTWhenEdit'        => DB::Raw('now()'),
                        'XVWhoCreate'       => Auth::user()->name,
                        'XVWhoEdit'         => Auth::user()->name,
                    ]
                );
            DB::commit();
            } catch (\Exception $e) {
                //echo $e;
                DB::rollBack();
                abort(500, 'Internal error');
            }
            return redirect('admin/ppe')->with('message','บันทึกสำเร็จ');
    }

    public function getdata()
    {
        $sql="select * from torder_ppe order by XTWhenCreate desc";
        $data = \DB::select($sql);

        $data = array(
            'data' => $data,
        );

        print json_encode($data);
    }

}
