<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Auth;
use PDF;
/**
 * Class DashboardController. 
 */
class PpeboxController extends Controller
{
    /**
     * @return \Illuminate\View\View
     */
    public function index()
    {
        //dd('aaa');
        
        return view('admin.ppebox.index');
    }

    public function create($id)
    {
        //dd($id);
        $sql="SELECT * FROM torder_ppe WHERE XIPpeCode = $id";
        $res = \DB::select($sql);

        $sql="SELECT XIPPpeBoxId,XIPpeCode,sum(XIBoxIsoNum) as IsoNum,sum(XIBoxAntiNumM) as AntiNumM,sum(XIBoxAntiNumL) as AntiNumL,sum(XIBoxOverM) as OverM,sum(XIBoxOverL) as OverL,sum(XIBoxOverXL) as OverXL,sum(XIBoxOver2XL) as Over2XL 
        FROM torder_ppebox WHERE XIPpeCode = $id GROUP BY XIPpeCode";
        $res1 = \DB::select($sql);

        
        $rbox =[
            'box1' => $res1,
        ];

        //dd($res1);
        if ( count($res1)==0) {
            $rbox =[
                'IsoNum' => 0,
                'AntiNumM' => 0,
                'AntiNumL' => 0,
                'OverM' => 0,
                'OverL' => 0,
                'OverXL' => 0,
                'Over2XL' => 0,
            ];
        } else {
            $rbox =[
                'IsoNum' => $rbox['box1'][0]->IsoNum,
                'AntiNumM' => $rbox['box1'][0]->AntiNumM,
                'AntiNumL' => $rbox['box1'][0]->AntiNumL,
                'OverM' => $rbox['box1'][0]->OverM,
                'OverL' => $rbox['box1'][0]->OverL,
                'OverXL' => $rbox['box1'][0]->OverXL,
                'Over2XL' => $rbox['box1'][0]->Over2XL,
            ];

        }
        //dd($rbox);
        return view('admin.ppebox.create',[
            'data' => $res[0],
            'data2' => $rbox
        ]);
        
 
    }

    public function store(Request $request)
    {

        //dd($request);

        DB::beginTransaction();
        try {
                DB::table('torder_ppebox')->insert(
                    [
                        'XIPpeCode'            => $request->XIPpeCode,
                        'XVBoxSize'            => $request->XVBoxSize,
                        'XIBoxIsoNum'          => $request->XIBoxIsoNum,
                        'XIBoxAntiNumM'        => $request->XIBoxAntiNumM,
                        'XIBoxAntiNumL'        => $request->XIBoxAntiNumL,
                        'XIBoxOverM'           => $request->XIBoxOverM,
                        'XIBoxOverL'           => $request->XIBoxOverL,
                        'XIBoxOverXL'          => $request->XIBoxOverXL,
                        'XIBoxOver2XL'         => $request->XIBoxOver2XL,
                        'XTWhenCreate'      => DB::Raw('now()'),
                        'XTWhenEdit'        => DB::Raw('now()'),
                        'XVWhoCreate'       => Auth::user()->name,
                        'XVWhoEdit'         => Auth::user()->name,
                    ]
                );
            DB::commit();
            } catch (\Exception $e) {
                //echo $e;
                DB::rollBack();
                abort(500, 'Internal error');
            }
            return redirect()->route('admin.ppebox.create',$request->XIPpeCode)->with('message','บันทึกสำเร็จ');
            //return redirect('admin/ppebox/create')->with('message','บันทึกสำเร็จ');
    }


    public function edit($id)
    {
        // $data = DB::table('torder_ppe')->where('XIPpeCode','=',$id)->first();
        // //dd($data);
        // return view('admin.ppe.edit',['data' => $data]);
    }

    public function update(Request $request,$id)
    {
        // $XDPpeOrderDate= !empty($request->XDPpeOrderDate) ? Carbon::createFromFormat('d/m/Y', $request->XDPpeOrderDate)->format('Y-m-d') : null;
        // $XDPpeSendDate=  !empty($request->XDPpeSendDate) ? Carbon::createFromFormat('d/m/Y', $request->XDPpeSendDate)->format('Y-m-d') : null;
        // $XDPpeDateSal=  !empty($request->XDPpeDateSal) ? Carbon::createFromFormat('d/m/Y', $request->XDPpeDateSal)->format('Y-m-d') : null;
        // $XVPpeStaSal = $request->XVPpeStaSal == 'true'? 1:0;
        // $XVPpeStaSend = $request->XVPpeStaSend == 'true'? 1:0;

        // DB::beginTransaction();
        // try {
        //         DB::table('torder_ppe') ->where('XIPpeCode','=',$id)
        //         ->update(
        //             [
        //                 'XVPpeOrderId'      => $request->XVPpeOrderId,
        //                 'XDPpeOrderDate'    => $XDPpeOrderDate,
        //                 'XVPpeContactName'  => $request->XVPpeContactName,
        //                 'XVPpeContactTel'   => $request->XVPpeContactTel,
        //                 'XIIsoNum'          => $request->XIIsoNum,
        //                 'XIAntiNumM'        => $request->XIAntiNumM,
        //                 'XIAntiNumL'        => $request->XIAntiNumL,
        //                 'XIOverM'           => $request->XIOverM,
        //                 'XIOverL'           => $request->XIOverL,
        //                 'XIOverXL'          => $request->XIOverXL,
        //                 'XIOver2XL'         => $request->XIOver2XL,
        //                 'XVPpeDonateName'    => $request->XVPpeDonateName,
        //                 'XVPpeRecipName'    => $request->XVPpeRecipName,
        //                 'XVPpeSendTel'      => $request->XVPpeSendTel,
        //                 'XVPpeSendAdd'      => $request->XVPpeSendAdd,
        //                 'XDPpeSendDate'     => $XDPpeSendDate,
        //                 'XVPpeInvNo'        => $request->XVPpeInvNo,
        //                 'XVPpeNameInv'      => $request->XVPpeNameInv,
        //                 'XVPpeTelInv'       => $request->XVPpeTelInv,
        //                 'XVPpeInvAdd'       => $request->XVPpeInvAdd,
        //                 'XVPpeStaSal'       => $XVPpeStaSal ,
        //                 'XFPpeInvSal'       => $request->XFPpeInvSal,
        //                 'XDPpeDateSal'      => $XDPpeDateSal,
        //                 'XVPpeStaSend'      => $XVPpeStaSend,
        //                 'XTWhenEdit'        => DB::Raw('now()'),
        //                 'XVWhoEdit'         => Auth::user()->name, 

        //                 ]
        //         );
        //     DB::commit();
        //     } catch (\Exception $e) {
        //         DB::rollBack();
        //         abort(500, 'Internal error');
        //     }
        //     return redirect('admin/ppe')->with('message','บันทึกสำเร็จ');
    }


    public function getdata()
    {
        $sql="select * from torder_ppe order by XDPpeSendDate desc";
        $data = \DB::select($sql);

        $data = array(
            'data' => $data,
        );

        print json_encode($data);
    }

}
