<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ReceiveItemController extends Controller
{
    public function index()
    {
        return view('admin.receiveItem.index');
    }
    public function receiveItemgetData(Request $request)
    {


        $draw = $request->get('draw');
        $start = $request->get('start');
        $length = $request->get('length');


        $search = (isset($filter['value'])) ? $filter['value'] : false;

        //Todo
        // ทำไมยังเห็นรหัส2
        $sql = \DB::table('torder_hd')
            ->join('torder_dt', 'torder_dt.XVOrderDocNo', 'torder_hd.XVOrderDocNo')
            ->join('torder_bc', 'torder_bc.XVOrderDocNo', 'torder_hd.XVOrderDocNo')
            ->whereNotNull('torder_dt.XDDateOutvk')
            ->whereNotNull('torder_dt.XIOrderSand')
            ->where('torder_bc.XVOrderBLocation','=','1')
            ->groupby('torder_hd.XVOrderDocNo','torder_dt.XVOrderDSize')
            ->select('torder_hd.XVOrderDocNo','torder_hd.XVOrderIn','torder_hd.XVOrderDetail'
                ,'torder_dt.XVOrderDSize','torder_dt.XIOrderDTotalNum');
//        $sql = \collect($sql);

        $AllData = $sql->count();

        $total_members = $AllData; // get your total no of data;
        $data = $sql->limit($start, $length)->get();

        $data = array(
            'draw' => $draw,
            'recordsTotal' => $total_members,
            'recordsFiltered' => $total_members,
            'data' => $data,
        );

        print  json_encode($data);
    }

    public function showConfirmreceiveItem($Docno,$OrderIn,$DSize,$TotalNum){
        return view('admin.receiveItem.receiveitem_confirm',[
            'Docno'=>$Docno,
            'OrderIn'=>$OrderIn,
            'Dsize'=>$DSize,
            'TotalNum'=>$TotalNum
        ]);

    }

    public function confirmreceiveItem(Request $request){


        $data = $request->all(); // This will get all the request data.

//        dd($data); // This will dump and die

        $validator = $this->ReceiveItem_rules($data);
        if($validator->fails())
        {
//            dd($validator);
            return redirect()->back()->withErrors($validator)->withInput();
        }
//        dd($request->all());
        try{
            $id = DB::table('torder_dt')
                ->where('XVOrderDocNo',$request->Docno)
                ->where('XVOrderDSize',$request->Dsize)
                ->update(
                    [
                        "XDDateInSewn" => \DB::raw('NOW()'),
                        "XIOrderReceive" => $request->TotalNum,
                    ]
                );
            DB::table('torder_bc')
                ->where('XVOrderBLocation','=','1')
                ->where('XVOrderDocNo',$request->Docno)
                ->where('XVOrderBSize',$request->Dsize)
                ->update(
                    [
                        "XVOrderBLocation" => '2',
                    ]
                );
            return redirect()->route('admin.receiveItem.index')->with("success",'ยืนยันการส่งสินค้าสำเร็จ');
        }catch (QueryException  $e){
            return redirect()->route('admin.receiveItem.index')->with("failed",'ยืนยันการส่งสินค้าไม่สำเร็จ :'.$e->getMessage());
        }
    }

    public function ReceiveItem_rules($data)
    {
        $messages = [
            'Docno.required'=>'กรุณากรอกข้อมูล',
            'OrderIn.required'=>'กรุณากรอกข้อมูล',
            'Dsize.required'=>'กรุณากรอกข้อมูล',
            'TotalNum.required'=>'กรุณากรอกข้อมูล',
        ];

        $validator = \Validator::make($data, [
            "Docno" => 'required',
            "OrderIn" => 'required',
            "Dsize" => 'required',
            "TotalNum" => 'required',

        ], $messages);

        return $validator;
    }
}
