<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

/**
 * Class DashboardController.
 */
class ReportDeliveryController extends Controller
{
    /**
     * @return \Illuminate\View\View
     */
    public function index()
    {

        return view('admin.reportdeliveryacc.index');
    }

    public function create()
    {
        return view('admin.reportdeliveryacc.create');
    }

    public function edit()
    {
        return view('admin.reportdeliveryacc.edit');
    }


//    public function getData(Request $request)
//    {
//
//        $sql = \DB::table('torder_bc')
//            ->join('torder_hd', 'torder_bc.XVOrderDocNo', 'torder_hd.XVOrderDocNo')
//            ->selectRaw("CAST(XDDateInSend as date) as XDDateInSend,XVCarCode,XVBoxCode,
//                        CASE When XCStatusSend = 1 THEN 'จัดส่งเรียบร้อย'
//                        ELSE 'อยู่ระหว่างการจัดส่ง'
//                        END as XCStatusSend
//                        ,COUNT(*) XICountAll ")
//            ->where('XVOrderBLocation', $request->location)
//            ->groupBy(\DB::raw('XVCarCode,XVBoxCode,CAST(XDDateInSend as date)'));
//
//        // dd($sql);
//        $totalData = $sql->get()->count();
//
//
//        $totalFiltered = $totalData;
//
//        $limit = $request->input('length');
//        $start = $request->input('start');
//
//
//        if (empty($request->input('search.value'))) {
//            $datas = $sql->offset($start)
//                ->limit($limit)
//                ->orderByDesc(\DB::raw('CAST(XDDateInSend as date)'))
//                ->get();
//        } else {
//            $search = $request->input('search.value');
//
//            $datas =  $sql->whereRaw('(XVCarCode LIKE "%' . $search . '%"
//                                        OR XVBoxCode LIKE "%' . $search . '%"
//                                        OR CAST(XDDateInSend as date) LIKE "%' . $search . '%"
//                                        )
//                                    ')
//                ->offset($start)
//                ->limit($limit)
//                ->orderByDesc(\DB::raw('CAST(XDDateInSend as date)'))
//                ->get();
//
//            $totalFiltered = $sql->whereRaw('(XVCarCode LIKE "%' . $search . '%"
//                                        OR XVBoxCode LIKE "%' . $search . '%"
//                                        OR CAST(XDDateInSend as date) LIKE "%' . $search . '%"
//                                        )
//                                    ')
//                ->count();
//        }
//
//
//        $json_data = array(
//            "draw"            => intval($request->input('draw')),
//            "recordsTotal"    => intval($totalData),
//            "recordsFiltered" => intval($totalFiltered),
//            "data"            => $datas
//        );
//
//        // dd($json_data);
//
//
//        echo json_encode($json_data);
//    }

    public function getDataDetail($carCode, $boxCode)
    {



        $res_bc = \DB::table('torder_bc')
            ->join('torder_hd', 'torder_bc.XVOrderDocNo', 'torder_hd.XVOrderDocNo')
            ->selectRaw("torder_hd.XVOrderDocNo,XVOrderBSize,XVBoxCode, XVOrderMItemNo,XVOrderBCode")
            ->where('XVCarCode', $carCode)
            ->where('XVBoxCode', $boxCode)
            ->get()
            ->toArray();

        $datas = [
            'XVCarCode' => $carCode,
            'XDDateInSend' => $boxCode,
            'res_bc' => $res_bc
        ];

        return view('admin.reportdeliveryacc.create', compact('datas'));
    }
    public function getData(Request $request)
    {
        $draw = $request->get('draw');
        $start = $request->get('start');
        $length = $request->get('length');


        $search = (isset($filter['value'])) ? $filter['value'] : false;

        $sql = \DB::table('torder_hd')
            ->join('torder_bc', 'torder_hd.XVOrderDocNo', '=', 'torder_bc.XVOrderDocNo')
            ->where('XVOrderBLocation', '=', $request->location)
            ->groupBy(\DB::raw('DATE_FORMAT(XDDateInSend,\'%Y-%m-%d\')'))
            ->groupBy('XVOrderBSize')
            ->groupBy('XVOrderIn')
            ->select(\DB::raw('DATE_FORMAT(XDDateInSend,\'%Y-%m-%d\') as XDDate'),
                'XVOrderIn','XVOrderBSize',
                'XVOrderDetail',\DB::raw('COUNT(XVOrderBCode) as XISizeCount'))
            ->orderBy('XDDateInSend','desc');
        // dd($request->location);
//         dd($sql);

        $AllData = $sql->count();

        $total_members = $AllData; // get your total no of data;
        // $members = $this->methodToGetMembers($start, $length); //supply start and length of the table data
        $data = $sql->limit($start, $length)->get();

        $data = array(
            'draw' => $draw,
            'recordsTotal' => $total_members,
            'recordsFiltered' => $total_members,
            'data' => $data,
        );

        print  json_encode($data);
    }

    public function reportdeliveryaccshowDetail($date,$size,$orderin){
        return view('admin.reportdeliveryacc.show',[
            'date'=>$date,
            'size'=>$size,
            'orderIn'=>$orderin
        ]);
    }
    public function reportdeliveryaccfindDetail(Request $request){
        $draw = $request->get('draw');
        $start = $request->get('start');
        $length = $request->get('length');


        $search = (isset($filter['value'])) ? $filter['value'] : false;

//        dd($request->orderIn);
        $sql = \DB::table('torder_hd')
            ->join('torder_bc', 'torder_hd.XVOrderDocNo', '=', 'torder_bc.XVOrderDocNo')
            ->where('XVOrderBLocation', '=',$request->location)
            ->where(\DB::raw('DATE_FORMAT(XDDateInSend,\'%Y-%m-%d\')'),'=',$request->date)
            ->where('XVOrderBSize','=',$request->size)
            ->where('XVOrderIn','=',$request->orderIn)
            ->select(\DB::raw('DATE_FORMAT(XDDateInSend,\'%Y-%m-%d\') as XDDate'),
                'XVOrderBCode','XVOrderIn',
                'XVOrderDetail','XVOrderBSize')
            ->orderBy('XVOrderBCode','ASC');
// dd($sql);
        $AllData = $sql->count();

        $total_members = $AllData; // get your total no of data;
        // $members = $this->methodToGetMembers($start, $length); //supply start and length of the table data
        $data = $sql->limit($start, $length)->get();

        $data = array(
            'draw' => $draw,
            'recordsTotal' => $total_members,
            'recordsFiltered' => $total_members,
            'data' => $data,
        );

        print  json_encode($data);
    }

}
