<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use PDF;
use Illuminate\Support\Carbon;

/**
 * Class DashboardController.
 */
class ReportProductInBoxController extends Controller
{
    /**
     * @return \Illuminate\View\View
     */
    public function index()
    {
        return view('admin.reportproductinbox.index');
    }

    public function create()
    {
        return view('admin.reportproductinbox.create');
    }

    public function edit()
    {
        return view('admin.reportproductinbox.edit');
    }


    public function getDataDetail($boxCode)
    {
        $res_bc = \DB::table('torder_bc')
            ->join('torder_hd', 'torder_bc.XVOrderDocNo', 'torder_hd.XVOrderDocNo')
            ->selectRaw("torder_hd.XVOrderDocNo,XVOrderBSize,XVBoxCode, XVOrderMItemNo,XVOrderBCode")
            ->where('XVBoxCode', $boxCode)
            ->where('XVOrderBLocation', '9')
            ->get()
            ->toArray();


        $datas = [
            'boxCode'=>$boxCode,
            'res_bc' => $res_bc
        ];

        return view('admin.reportproductinbox.create', compact('datas'));
    }

    //XDDateInPack
    public function getData(Request $request)
    {
        $draw = $request->get('draw');
        $start = $request->get('start');
        $length = $request->get('length');


        $search = (isset($filter['value'])) ? $filter['value'] : false;

        $sql = \DB::table('torder_hd')
            ->join('torder_bc', 'torder_hd.XVOrderDocNo', '=', 'torder_bc.XVOrderDocNo')
            ->where('XVOrderBLocation', '=', $request->location)
            ->groupBy(\DB::raw('DATE_FORMAT(XDDateInPack,\'%Y-%m-%d\')'))
            ->groupBy('XVOrderBSize')
            ->groupBy('XVOrderIn')
            ->select(\DB::raw('DATE_FORMAT(XDDateInPack,\'%Y-%m-%d\') as XDDate'),
                'XVOrderIn','XVOrderBSize',
                'XVOrderDetail',\DB::raw('COUNT(XVOrderBCode) as XISizeCount'))
            ->orderBy('XDDateInPack','desc');
        // dd($request->location);
//         dd($sql);

        $AllData = $sql->count();

        $total_members = $AllData; // get your total no of data;
        // $members = $this->methodToGetMembers($start, $length); //supply start and length of the table data
        $data = $sql->limit($start, $length)->get();

        $data = array(
            'draw' => $draw,
            'recordsTotal' => $total_members,
            'recordsFiltered' => $total_members,
            'data' => $data,
        );

        print  json_encode($data);
    }

    public function reportproductinboxshowDetail($date,$size,$orderin){
        return view('admin.reportproductinbox.show',[
            'date'=>$date,
            'size'=>$size,
            'orderIn'=>$orderin
        ]);
    }
    public function reportproductinboxfindDetail(Request $request){
        $draw = $request->get('draw');
        $start = $request->get('start');
        $length = $request->get('length');


        $search = (isset($filter['value'])) ? $filter['value'] : false;

//        dd($request->orderIn);
        $sql = \DB::table('torder_hd')
            ->join('torder_bc', 'torder_hd.XVOrderDocNo', '=', 'torder_bc.XVOrderDocNo')
            ->where('XVOrderBLocation', '=',$request->location)
            ->where(\DB::raw('DATE_FORMAT(XDDateInPack,\'%Y-%m-%d\')'),'=',$request->date)
            ->where('XVOrderBSize','=',$request->size)
            ->where('XVOrderIn','=',$request->orderIn)
            ->select(\DB::raw('DATE_FORMAT(XDDateInPack,\'%Y-%m-%d\') as XDDate'),
                'XVOrderBCode','XVOrderIn',
                'XVOrderDetail','XVOrderBSize')
            ->orderBy('XVOrderBCode','ASC');
// dd($sql);
        $AllData = $sql->count();

        $total_members = $AllData; // get your total no of data;
        // $members = $this->methodToGetMembers($start, $length); //supply start and length of the table data
        $data = $sql->limit($start, $length)->get();

        $data = array(
            'draw' => $draw,
            'recordsTotal' => $total_members,
            'recordsFiltered' => $total_members,
            'data' => $data,
        );

        print  json_encode($data);
    }
}
