<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

/**
 * Class DashboardController.
 */
class ScanForBleachingJobsAminController extends Controller
{
    /**
     * @return \Illuminate\View\View
     */
    public function index()
    {
        return view('admin.scanforbleachingjobsadmin.index');
    }

    public function createData()
    {
        // dd(123);

        return view('admin.scanforbleachingjobsadmin.create');
    }

    public function edit()
    {
        return view('admin.scanforbleachingjobsadmin.edit');
    }

    public function getData(Request $request)
    {


        $draw = $request->get('draw');
        $start = $request->get('start');
        $length = $request->get('length');


        $search = (isset($filter['value'])) ? $filter['value'] : false;
        // ตาลแก้ $sql
        $sql = \DB::table('torder_bc')
            ->join('torder_hd', 'torder_hd.XVOrderDocNo', 'torder_bc.XVOrderDocNo')        
            ->select('XVOrderBCode', 'XVOrderDocNo', 'XVOrderBSize','XDDateInNoQC','torder_hd.XVOrderDetail')
            ->where('XVOrderBLocation', $request->location);



        $AllData = $sql->count();

        $total_members = $AllData; // get your total no of data;
        // $members = $this->methodToGetMembers($start, $length); //supply start and length of the table data
        $data = $sql->limit($start, $length)->get();

        $data = array(
            'draw' => $draw,
            'recordsTotal' => $total_members,
            'recordsFiltered' => $total_members,
            'data' => $data,
        );

        print  json_encode($data);
    }

    public function update(Request $request)
    {
        // dd($XVOrderDocNo);
        $chk_dup = \DB::table('torder_bc')->where('XVOrderBCode',$request->barcode)->where('XVOrderBLocation',$request->location)->get();
        // $chk_dup = \DB::table('torder_bc')->where('XVOrderBCode','3220191100010002')->where('XVOrderBLocation','4')->get();
        // dd(count($chk_dup));
        if(count($chk_dup)>0){
            return response()->json([
                'success'     => '2',
                'order_no'    => '',
                'size'        => ''
            ]);
        }
        // dd();

        switch ($request->location) {
            case '3': //รับเข้าโรงฟอก
                $status = 1;
                \DB::table('torder_bc')
                    ->where('XVOrderBCode', $request->barcode)
                    ->update(
                        [
                            'XDDateInBlench' => date("Y-m-d H:i:s"),
                            'XVOrderBLocation' => $request->location,
                            'XVWhoEdit' => \Auth::user()->name,
                            'XTWhenEdit' => date("Y-m-d H:i:s"),
                        ]
                    );


                break;
            case '4': //ตัดด้ายตอกกระดุม
                $status = 1;
                \DB::table('torder_bc')
                    ->where('XVOrderBCode', $request->barcode)
                    ->update(
                        [
                            'XDDateInThread' => date("Y-m-d H:i:s"),
                            'XVOrderBLocation' => $request->location,
                            'XVWhoEdit' => \Auth::user()->name,
                            'XTWhenEdit' => date("Y-m-d H:i:s"),
                        ]
                    );
                break;
            case '5': //FG
                $status = 1;
                \DB::table('torder_bc')
                    ->where('XVOrderBCode', $request->barcode)
                    ->update(
                        [
                            'XDDateInStockFG' => date("Y-m-d H:i:s"),
                            'XVOrderBLocation' => $request->location,
                            'XVWhoEdit' => \Auth::user()->name,
                            'XTWhenEdit' => date("Y-m-d H:i:s"),
                        ]
                    );
                break;
            case '6': //รับเข้า QC
                $status = 1;
                \DB::table('torder_bc')
                    ->where('XVOrderBCode', $request->barcode)
                    ->update(
                        [
                            'XDDateInQC' => date("Y-m-d H:i:s"),
                            'XVOrderBLocation' => $request->location,
                            'XVWhoEdit' => \Auth::user()->name,
                            'XTWhenEdit' => date("Y-m-d H:i:s"),
                        ]
                    );
                break;
            case '7': //ไม่ผ่าน QC
                $status =1;
                 \DB::table('torder_bc')
                    ->where('XVOrderBCode', $request->barcode)
                    ->update(
                        [
                            'XDDateInNoQC' => date("Y-m-d H:i:s"),
                            'XVOrderBLocation' => $request->location,
                            'XVWhoEdit' => \Auth::user()->name,
                            'XTWhenEdit' => date("Y-m-d H:i:s"),
                        ]
                    );
                break;
            case '8':// Reject ซ่อมไม่ได้
                $status = 1;
                \DB::table('torder_bc')
                    ->where('XVOrderBCode', $request->barcode)
                    ->update(
                        [
                            'XDDateInNoQC' => date("Y-m-d H:i:s"),
                            'XDDateInReject' => date("Y-m-d H:i:s"),
                            'XVOrderBLocation' => $request->location,
                            'XVWhoEdit' => \Auth::user()->name,
                            'XTWhenEdit' => date("Y-m-d H:i:s"),
                        ]
                    );
                break;
            case '9': //ลงกล่อง
                $status =1;
                 \DB::table('torder_bc')
                    ->where('XVOrderBCode', $request->barcode)
                    ->update(
                        [
                            'XDDateInBox' => date("Y-m-d H:i:s"),
                            'XVOrderBLocation' => $request->location,
                            'XVWhoEdit' => \Auth::user()->name,
                            'XTWhenEdit' => date("Y-m-d H:i:s"),
                        ]
                    );
                break;
            case '10': //ระหว่างการจัดส่ง
                $status = 1;
                \DB::table('torder_bc')
                    ->where('XVOrderBCode', $request->barcode)
                    ->update(
                        [
                            'XDDateInSend' => date("Y-m-d H:i:s"),
                            'XVOrderBLocation' => $request->location,
                            'XCStatusSend' => '0',
                            'XVWhoEdit' => \Auth::user()->name,
                            'XTWhenEdit' => date("Y-m-d H:i:s"),
                        ]
                    );
                break;
            case '11': //จัดส่งแล้ว
                $status = 1;
                \DB::table('torder_bc')
                    ->where('XVOrderBCode', $request->barcode)
                    ->update(
                        [
                            'XDDateInSend' => date("Y-m-d H:i:s"),
                            'XVOrderBLocation' => $request->location,
                            'XCStatusSend' => '1',
                            'XVWhoEdit' => \Auth::user()->name,
                            'XTWhenEdit' => date("Y-m-d H:i:s"),
                        ]
                    );
                break;
            case '12': /// รับหลังส่งซ่อม
                $status = 1;
                \DB::table('torder_bc')
                    ->where('XVOrderBCode', $request->barcode)
                    ->update(
                        [
                            'XDDateInRepair' => date("Y-m-d H:i:s"),
                            'XVOrderBLocation' => "5",
                            'XVWhoEdit' => \Auth::user()->name,
                            'XTWhenEdit' => date("Y-m-d H:i:s"),
                        ]
                    );
                break;
            case '13': //Stock on hand รับเข้า packing
                $status = 1;
                \DB::table('torder_bc')
                    ->where('XVOrderBCode', $request->barcode)
                    ->update(
                        [
                            'XDDateInPack' => date("Y-m-d H:i:s"),
                            'XDDateInStockOH' => date("Y-m-d H:i:s"),
                            'XVOrderBLocation' => $request->location,
                            'XVWhoEdit' => \Auth::user()->name,
                            'XTWhenEdit' => date("Y-m-d H:i:s"),
                        ]
                    );
                break;
        }



        $res = \DB::table('torder_bc')->where('XVOrderBCode', $request->barcode)->first();
        if (!$res) {
            $status = 0;
        }
        // dd($res);

        return response()->json([
            'success'     => $status,
            'order_no'    => @$res->XVOrderDocNo,
            'size'        => @$res->XVOrderBSize
        ]);
    }
}
