<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\TMbranch;
use Illuminate\Http\Request;

/**
 * Class DashboardController.
 */
class ScanForBleachingJobsController extends Controller
{
    /**
     * @return \Illuminate\View\View
     */
    public function index()
    {
        //dd(123);

        $res_branch = TMbranch::Where('XIBranchCode', \Auth::user()->XIBranchCode)->first();
        return view('admin.scanforbleachingjobs.index', ['datas' => $res_branch]);
    }

    public function createData()
    {
        // dd(123);

        return view('admin.scanforbleachingjobs.create');
    }

    public function edit()
    {
        return view('admin.scanforbleachingjobs.edit');
    }

    public function getData(Request $request)
    {

//        $res_branch = TMbranch::Where('XIBranchCode', \Auth::user()->XIBranchCode)->first();
//
//        dd($request->all());
        $draw = $request->get('draw');
        $start = $request->get('start');
        $length = $request->get('length');


        $search = (isset($filter['value'])) ? $filter['value'] : false;


        $sql = \DB::table('torder_bc')
            ->join('torder_hd', 'torder_bc.XVOrderDocNo', '=', 'torder_hd.XVOrderDocNo')
            ->join('tmbranch','torder_bc.XIBranchCode_B','=','tmbranch.XIBranchCode')
            ->where('XVOrderBLocation', '=', $request->location)
            ->groupBy(\DB::raw('DATE_FORMAT(XDDateInBlench,\'%Y-%m-%d\')'))
            ->groupBy('XVOrderBSize')
            ->groupBy('XVOrderIn')
            ->select(\DB::raw('DATE_FORMAT(XDDateInBlench,\'%Y-%m-%d\') as XDDate'),
                'XVOrderIn','XVOrderBSize',
                'XVOrderDetail',\DB::raw('COUNT(XVOrderBCode) as XISizeCount'),'XVBranchName')
                ->orderBy('XDDateInBlench','desc');
        //
        // dd($request->location);
        // dd($sql);
//        //
        if($request->branch != null){
            $sql->where('XIBranchCode_B','=',$request->branch);
        }
        $AllData = $sql->count();

        $total_members = $AllData; // get your total no of data;
        // $members = $this->methodToGetMembers($start, $length); //supply start and length of the table data
        $data = $sql->limit($start, $length)->get();

        $data = array(
            'draw' => $draw,
            'recordsTotal' => $total_members,
            'recordsFiltered' => $total_members,
            'data' => $data,
        );
        //dd($request,$AllData);

        print  json_encode($data);
    }

    public function update(Request $request)
    {
//        dd($request->all());
        $chk_dup = \DB::table('torder_bc')->where('XVOrderBCode', $request->barcode)->where('XVOrderBLocation', $request->location)->get();
        if (count($chk_dup) > 0) {
            return response()->json([
                'success'     => '2',
                'order_no'    => '',
                'size'        => ''
            ]);
        }
        // dd();

        switch ($request->location) {
            case '3': //รับเข้าโรงฟอก
                $status = 1;
                \DB::table('torder_bc')
                    ->where('XVOrderBCode', $request->barcode)
                    ->update(
                        [
                            'XIBranchCode_B' => \Auth::user()->XIBranchCode,
                            'XDDateInBlench' => date("Y-m-d H:i:s"),
                            'XVOrderBLocation' => $request->location,
                            'XVWhoEdit' => \Auth::user()->name,
                            'XTWhenEdit' => date("Y-m-d H:i:s"),
                        ]
                    );


                break;
            case '4': //ตัดด้ายตอกกระดุม

                $chk_exists = \DB::table('torder_bc')
                    ->where('XVOrderBCode', $request->barcode)
                    ->where('XVOrderBLocation', '3')
                    ->where('XIBranchCode_B', \Auth::user()->XIBranchCode)
                    ->first();
                if ($chk_exists === null) {
                    return response()->json([
                        'success'     => '3',
                        'message'    => 'ไม่พบรายการนี้ยู่ในโรงฟอก กรุณาทำรับเข้าโรงฟอกก่อน'
                    ]);
                }

                $status = 1;
                \DB::table('torder_bc')
                    ->where('XVOrderBCode', $request->barcode)
                    ->update(
                        [
                            'XDDateInThread' => date("Y-m-d H:i:s"),
                            'XVOrderBLocation' => $request->location,
                            'XVWhoEdit' => \Auth::user()->name,
                            'XTWhenEdit' => date("Y-m-d H:i:s"),
                        ]
                    );
                break;
            case '5': //FG
                $status = 1;
                \DB::table('torder_bc')
                    ->where('XVOrderBCode', $request->barcode)
                    ->update(
                        [
                            'XDDateInStockFG' => date("Y-m-d H:i:s"),
                            'XVOrderBLocation' => $request->location,
                            'XVBcNoSand'=>$request->XVBcNoSand,
                            'XVWhoEdit' => \Auth::user()->name,
                            'XTWhenEdit' => date("Y-m-d H:i:s"),
                        ]
                    );
                break;
            case '6': //รับเข้า QC
                $status = 1;
                \DB::table('torder_bc')
                    ->where('XVOrderBCode', $request->barcode)
                    ->update(
                        [
                            'XDDateInQC' => date("Y-m-d H:i:s"),
                            'XVOrderBLocation' => $request->location,
                            'XVWhoEdit' => \Auth::user()->name,
                            'XTWhenEdit' => date("Y-m-d H:i:s"),
                        ]
                    );
                break;
            case '7': //ไม่ผ่าน QC
                $status = 1;
                \DB::table('torder_bc')
                    ->where('XVOrderBCode', $request->barcode)
                    ->update(
                        [
                            'XDDateInNoQC' => date("Y-m-d H:i:s"),
                            'XVOrderBLocation' => $request->location,
                            'XVWhoEdit' => \Auth::user()->name,
                            'XTWhenEdit' => date("Y-m-d H:i:s"),
                        ]
                    );
                break;
            case '8': // Reject ซ่อมไม่ได้
                $status = 1;
                \DB::table('torder_bc')
                    ->where('XVOrderBCode', $request->barcode)
                    ->update(
                        [
                            'XDDateInNoQC' => date("Y-m-d H:i:s"),
                            'XDDateInReject' => date("Y-m-d H:i:s"),
                            'XVOrderBLocation' => $request->location,
                            'XVWhoEdit' => \Auth::user()->name,
                            'XTWhenEdit' => date("Y-m-d H:i:s"),
                        ]
                    );
                break;
            case '9': //ลงกล่อง
                $status = 1;
                \DB::table('torder_bc')
                    ->where('XVOrderBCode', $request->barcode)
                    ->update(
                        [
                            'XDDateInBox' => date("Y-m-d H:i:s"),
                            'XVOrderBLocation' => $request->location,
                            'XVWhoEdit' => \Auth::user()->name,
                            'XTWhenEdit' => date("Y-m-d H:i:s"),
                        ]
                    );
                break;
            case '10': //ระหว่างการจัดส่ง
                $status = 1;
                \DB::table('torder_bc')
                    ->where('XVOrderBCode', $request->barcode)
                    ->update(
                        [
                            'XDDateInSend' => date("Y-m-d H:i:s"),
                            'XVOrderBLocation' => $request->location,
                            'XCStatusSend' => '0',
                            'XVWhoEdit' => \Auth::user()->name,
                            'XTWhenEdit' => date("Y-m-d H:i:s"),
                        ]
                    );
                break;
            case '11': //จัดส่งแล้ว
                $status = 1;
                \DB::table('torder_bc')
                    ->where('XVOrderBCode', $request->barcode)
                    ->update(
                        [
                            'XDDateInSend' => date("Y-m-d H:i:s"),
                            'XVOrderBLocation' => $request->location,
                            'XCStatusSend' => '1',
                            'XVWhoEdit' => \Auth::user()->name,
                            'XTWhenEdit' => date("Y-m-d H:i:s"),
                        ]
                    );
                break;
            case '12': /// รับหลังส่งซ่อม
                $status = 1;
                \DB::table('torder_bc')
                    ->where('XVOrderBCode', $request->barcode)
                    ->update(
                        [
                            'XDDateInRepair' => date("Y-m-d H:i:s"),
                            'XVOrderBLocation' => "5",
                            'XVWhoEdit' => \Auth::user()->name,
                            'XTWhenEdit' => date("Y-m-d H:i:s"),
                        ]
                    );
                break;
            case '13': //Stock on hand รับเข้า packing
                $status = 1;
                \DB::table('torder_bc')
                    ->where('XVOrderBCode', $request->barcode)
                    ->update(
                        [
                            'XDDateInPack' => date("Y-m-d H:i:s"),
                            'XDDateInStockOH' => date("Y-m-d H:i:s"),
                            'XVOrderBLocation' => $request->location,
                            'XVWhoEdit' => \Auth::user()->name,
                            'XTWhenEdit' => date("Y-m-d H:i:s"),
                        ]
                    );
                break;
        }

        $res = \DB::table('torder_bc')->where('XVOrderBCode', $request->barcode)->first();
        if (!$res) {
            $status = 0;
        }
        // dd($res);

        return response()->json([
            'success'     => $status,
            'order_no'    => @$res->XVOrderDocNo,
            'size'        => @$res->XVOrderBSize
        ]);
    }

    public function stockshowDetail($date, $size,$orderin)
    {
        return view('admin.scanforbleachingjobs.show', [
            'date' => $date,
            'size' => $size,
            'orderIn'=>$orderin
        ]);
    }

    public function stockshowMyDetail(Request $request){
        $draw = $request->get('draw');
        $start = $request->get('start');
        $length = $request->get('length');


        $search = (isset($filter['value'])) ? $filter['value'] : false;

//        dd($request->orderIn);
        $sql = \DB::table('torder_hd')
            ->join('torder_bc', 'torder_hd.XVOrderDocNo', '=', 'torder_bc.XVOrderDocNo')
            ->where('XVOrderBLocation', '=',$request->location)
            ->where(\DB::raw('DATE_FORMAT(XDDateInBlench,\'%Y-%m-%d\')'),'=',$request->date)
            ->where('XVOrderBSize','=',$request->size)
            ->where('XVOrderIn','=',$request->orderIn)
            ->select(\DB::raw('DATE_FORMAT(XDDateInBlench,\'%Y-%m-%d\') as XDDate'),
                'XVOrderBCode','XVOrderIn',
                'XVOrderDetail','XVOrderBSize')
                ->orderBy('XVOrderBCode','ASC');
// dd($sql);
            $AllData = $sql->count();

            $total_members = $AllData; // get your total no of data;
            // $members = $this->methodToGetMembers($start, $length); //supply start and length of the table data
            $data = $sql->limit($start, $length)->get();

            $data = array(
                'draw' => $draw,
                'recordsTotal' => $total_members,
                'recordsFiltered' => $total_members,
                'data' => $data,
            );

            print  json_encode($data);
    }
}
