<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use PDF;
use Illuminate\Support\Carbon;

/**
 * Class DashboardController.
 */
class ScanQCReceiveController extends Controller
{
    /**
     * @return \Illuminate\View\View
     */
    public function index()
    {
        return view('admin.qcReceive.index');
    }

    public function create()
    {
        // abort_unless(\Gate::allows('order_create'), 403);
        $defectt     = \DB::table('tmdefectt')->where('XCStatus', '1')->get();
        $defectm     = \DB::table('tmdefectm')->where('XCStatus', '1')->get();
        $defectl     = \DB::table('tmdefectl')->where('XCStatus', '1')->get();
        $branch     = \DB::table('tmbranch')->get();


        $res = [
            'defectt'     => $defectt,
            'defectm'       => $defectm,
            'defectl'       => $defectl,
            'branch'        => $branch,
        ];

        //  dd($res['defectm']);

        return view('admin.qcReceive.create', compact('res'));
    }

    public function edit()
    {
        return view('admin.QCReceive.edit');
    }

    public function update(Request $request)
    {

        $chk_dup = \DB::table('torder_bc')->where('XVOrderBCode', $request->barcode)->where('XVOrderBLocation', $request->location)->get();
        if (count($chk_dup) > 0) {
            return response()->json([
                'success'     => '2',
                'order_no'    => '',
                'size'        => ''
            ]);
        }

        $status = 1;
        \DB::table('torder_bc')
            ->where('XVOrderBCode', $request->barcode)
            ->update(
                [
                    'XDDateInQC' => date("Y-m-d H:i:s"),
                    'XVOrderBLocation' => $request->location,
                    'XVWhoEdit' => \Auth::user()->name,
                    'XTWhenEdit' => date("Y-m-d H:i:s"),
                ]
            );

        $res = \DB::table('torder_bc')->where('XVOrderBCode', $request->barcode)->first();
        if (!$res) {
            $status = 0;
        }


        return response()->json([
            'success'     => $status,
            'order_no'    => @$res->XVOrderDocNo,
            'size'        => @$res->XVOrderBSize
        ]);
    }

    public function scanBarcode(Request $request)
    {
        // dd($request->barcode);
        $status = 1;
        $res = \DB::table('torder_bc')->where('XVOrderBCode', $request->barcode)->first();
        if (!$res) {
            $status = 0;
        }

        return response()->json([
            'success'     => $status,
            'order_no'    => @$res->XVOrderDocNo,
            'size'        => @$res->XVOrderBSize
        ]);
    }
    public function getData(Request $request)
    {

        $draw = $request->get('draw');
        $start = $request->get('start');
        $length = $request->get('length');


        $search = (isset($filter['value'])) ? $filter['value'] : false;

        $sql = \DB::table('torder_hd')
            ->join('torder_bc', 'torder_hd.XVOrderDocNo', '=', 'torder_bc.XVOrderDocNo')
            ->where('XVOrderBLocation', '=', $request->location)
            ->groupBy(\DB::raw('DATE_FORMAT(XDDateInQC,\'%Y-%m-%d\')'))
            ->groupBy('XVOrderBSize')
            ->groupBy('XVOrderIn')
            ->select(\DB::raw('DATE_FORMAT(XDDateInQC,\'%Y-%m-%d\') as XDDate'),
                'XVOrderIn','XVOrderBSize',
                'XVOrderDetail',\DB::raw('COUNT(XVOrderBCode) as XISizeCount'))
            ->orderBy('XDDateInQC','desc');
        // dd($request->location);
//         dd($sql);

        $AllData = $sql->count();

        $total_members = $AllData; // get your total no of data;
        // $members = $this->methodToGetMembers($start, $length); //supply start and length of the table data
        $data = $sql->limit($start, $length)->get();

        $data = array(
            'draw' => $draw,
            'recordsTotal' => $total_members,
            'recordsFiltered' => $total_members,
            'data' => $data,
        );

        print  json_encode($data);
    }

    public function report()
    {
        return view('admin.qcReceive.report');
    }

    public function reportPdf(Request $request)
    {

        $dateStart =  Carbon::createFromFormat('d/m/Y', $request->dateStart)->format('Y-m-d');
        $dateEnd =  Carbon::createFromFormat('d/m/Y', $request->dateEnd)->format('Y-m-d');

        // dd($dateStart, $dateEnd);

        $sql = "select torder_hd.XVOrderDocNo,XVOrderBSize,count(XVOrderBarNo) as count_all,torder_hd.XVOrderDetail,torder_hd.XVOrderIn
                    from torder_bc
                    INNER JOIN torder_hd on torder_hd.XVOrderDocNo = torder_bc.XVOrderDocNo
                    WHERE cast(XDDateInQC as date) Between '" . $dateStart . "' and '" . $dateEnd . "' and XVOrderBLocation='6'
                    GROUP BY XVOrderIn,XVOrderBSize
                    ORDER BY XVOrderIn,XVOrderBSize";

        $res_bc = \DB::select($sql);

        $res = [
            'res_bc'     => $res_bc,
            'dateStart'     => $request->dateStart,
            'dateEnd'     => $request->dateEnd,
        ];

        // dd($res);

        $pdf = PDF::loadView('admin.qcReceive.report_pdf', compact('res'));

        return $pdf->stream();
    }

    public function qcshowDetail($date,$size,$orderin){
        return view('admin.qcReceive.show',[
            'date'=>$date,
            'size'=>$size,
            'orderIn'=>$orderin
        ]);

    }

    public function qcfindDetail(Request $request){
        $draw = $request->get('draw');
        $start = $request->get('start');
        $length = $request->get('length');


        $search = (isset($filter['value'])) ? $filter['value'] : false;

//        dd($request->orderIn);
        $sql = \DB::table('torder_hd')
            ->join('torder_bc', 'torder_hd.XVOrderDocNo', '=', 'torder_bc.XVOrderDocNo')
            ->where('XVOrderBLocation', '=',$request->location)
            ->where(\DB::raw('DATE_FORMAT(XDDateInQC,\'%Y-%m-%d\')'),'=',$request->date)
            ->where('XVOrderBSize','=',$request->size)
            ->where('XVOrderIn','=',$request->orderIn)
            ->select(\DB::raw('DATE_FORMAT(XDDateInQC,\'%Y-%m-%d\') as XDDate'),
                'XVOrderBCode','XVOrderIn',
                'XVOrderDetail','XVOrderBSize')
            ->orderBy('XVOrderBCode','ASC');
// dd($sql);
        $AllData = $sql->count();

        $total_members = $AllData; // get your total no of data;
        // $members = $this->methodToGetMembers($start, $length); //supply start and length of the table data
        $data = $sql->limit($start, $length)->get();

        $data = array(
            'draw' => $draw,
            'recordsTotal' => $total_members,
            'recordsFiltered' => $total_members,
            'data' => $data,
        );

        print  json_encode($data);
    }
}
