<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use PDF;
use Illuminate\Support\Carbon;

/**
 * Class DashboardController.
 */
class ScanTransportController extends Controller
{
    /**
     * @return \Illuminate\View\View
     */
    public function index()
    {
        return view('admin.scantransport.index');
    }

    public function create()
    {
        return view('admin.scantransport.create');
    }

    public function edit()
    {
        return view('admin.scantransport.edit');
    }

    public function update(Request $request)
    {

        $chk_dup = \DB::table('torder_bc')->where('XVBoxCode', $request->barcode)->where('XVOrderBLocation', $request->location)->get();
        if (count($chk_dup) > 0) {
            return response()->json([
                'success'     => '2',
                'order_no'    => '',
                'carcode'        => ''
            ]);
        }

        $status = 1;
        \DB::table('torder_bc')
            ->where('XVBoxCode', $request->barcode)
            ->update(
                [
                    'XDDateInSend' => date("Y-m-d H:i:s"),
                    'XVOrderBLocation' => $request->location,
                    'XVCarCode' => $request->carCode,
                    'XCStatusSend' => '0',
                    'XVWhoEdit' => \Auth::user()->name,
                    'XTWhenEdit' => date("Y-m-d H:i:s"),
                ]
            );

        $res = \DB::table('torder_bc')
            ->join('torder_hd', 'torder_hd.XVOrderDocNo', 'torder_bc.XVOrderDocNo')
            ->where('XVBoxCode', $request->barcode)
            ->first();

        if (!$res) {
            $status = 0;
        }


        return response()->json([
            'success'     => $status,
            'XVCarCode'    => @$request->carCode,
            'XVBoxCode'        => @$request->barcode,
            'XVOrderDocNo'        => @$res->XVOrderDocNo,
            'XVOrderMItemNo'        => @$res->XVOrderMItemNo
        ]);
    }

    public function GetByCar(Request $request)
    {
        $status = 1;
        $res = \DB::table('torder_bc')
            ->join('torder_hd', 'torder_hd.XVOrderDocNo', 'torder_bc.XVOrderDocNo')
            ->select('XVBoxCode', 'torder_hd.XVOrderDocNo', 'XVOrderMItemNo')
            ->where('XVCarCode', $request->carCode)
            ->where('XVOrderBLocation', $request->location)
            ->groupBy('XVBoxCode', 'torder_hd.XVOrderDocNo', 'XVOrderMItemNo')
            ->get();
        if (!$res) {
            $status = 0;
        }
        // dd($res);

        return response()->json([
            'success'     => $status,
            'datas'    => @$res
        ]);
    }

//    public function getData(Request $request)
//    {
//
//        $sql = \DB::table('torder_bc')
//            ->join('torder_hd', 'torder_bc.XVOrderDocNo', 'torder_hd.XVOrderDocNo')
//            ->selectRaw("torder_hd.XVOrderDocNo,XVOrderMItemNo, XVCarCode,XVBoxCode")
//            ->where('XVOrderBLocation', $request->location)
//            ->groupBy('torder_hd.XVOrderDocNo', 'XVOrderMItemNo', 'torder_bc.XVCarCode', 'XVBoxCode');
//
//
//        $totalData = $sql->get()->count();
//
//        $totalFiltered = $totalData;
//
//        $limit = $request->input('length');
//        $start = $request->input('start');
//
//
//        if (empty($request->input('search.value'))) {
//            $datas = $sql->offset($start)
//                ->limit($limit)
//                ->orderByDesc('torder_hd.XVOrderDocNo')
//                ->get();
//        } else {
//            $search = $request->input('search.value');
//
//            $datas =  $sql->whereRaw('(torder_hd.XVOrderDocNo LIKE "%' . $search . '%"
//                                        OR torder_hd.XVOrderMItemNo LIKE "%' . $search . '%"
//                                        OR XVCarCode LIKE "%' . $search . '%"
//                                        OR XVBoxCode LIKE "%' . $search . '%"
//                                        )
//                                    ')
//                ->offset($start)
//                ->limit($limit)
//                ->orderByDesc('torder_hd.XVOrderDocNo')
//                ->get();
//
//            $totalFiltered = $sql->whereRaw('(torder_hd.XVOrderDocNo LIKE "%' . $search . '%"
//                                        OR torder_hd.XVOrderMItemNo LIKE "%' . $search . '%"
//                                        OR XVCarCode LIKE "%' . $search . '%"
//                                        OR XVBoxCode LIKE "%' . $search . '%"
//                                        )
//                                    ')
//                ->count();
//        }
//
//
//        $json_data = array(
//            "draw"            => intval($request->input('draw')),
//            "recordsTotal"    => intval($totalData),
//            "recordsFiltered" => intval($totalFiltered),
//            "data"            => $datas
//        );
//
//        // dd($json_data);
//
//
//        echo json_encode($json_data);
//    }

    public function Delete(Request $request)
    {
        // dd($request);
        $status = 1;
        \DB::table('torder_bc')
            ->where('XVBoxCode', $request->barcode)
            ->update(
                [
                    'XDDateInSend' => '',
                    'XVOrderBLocation' => '6',
                    'XVCarCode' => '',
                    'XCStatusSend' => '0',
                    'XVWhoEdit' => \Auth::user()->name,
                    'XTWhenEdit' => date("Y-m-d H:i:s"),
                ]
            );


        return response()->json([
            'success'     => $status
        ]);
    }
    public function getData(Request $request)
    {
        $draw = $request->get('draw');
        $start = $request->get('start');
        $length = $request->get('length');


        $search = (isset($filter['value'])) ? $filter['value'] : false;

        $sql = \DB::table('torder_hd')
            ->join('torder_bc', 'torder_hd.XVOrderDocNo', '=', 'torder_bc.XVOrderDocNo')
            ->where('XVOrderBLocation', '=', $request->location)
            ->groupBy(\DB::raw('DATE_FORMAT(XDDateInSend,\'%Y-%m-%d\')'))
            ->groupBy('XVOrderBSize')
            ->groupBy('XVOrderIn')
            ->select(\DB::raw('DATE_FORMAT(XDDateInSend,\'%Y-%m-%d\') as XDDate'),
                'XVOrderIn','XVOrderBSize',
                'XVOrderDetail',\DB::raw('COUNT(XVOrderBCode) as XISizeCount'))
            ->orderBy('XDDateInSend','desc');
        // dd($request->location);
//         dd($sql);

        $AllData = $sql->count();

        $total_members = $AllData; // get your total no of data;
        // $members = $this->methodToGetMembers($start, $length); //supply start and length of the table data
        $data = $sql->limit($start, $length)->get();

        $data = array(
            'draw' => $draw,
            'recordsTotal' => $total_members,
            'recordsFiltered' => $total_members,
            'data' => $data,
        );

        print  json_encode($data);
    }

    public function scantransportshowDetail($date,$size,$orderin){
        return view('admin.scantransport.show',[
            'date'=>$date,
            'size'=>$size,
            'orderIn'=>$orderin
        ]);
    }
    public function scantransportfindDetail(Request $request){
        $draw = $request->get('draw');
        $start = $request->get('start');
        $length = $request->get('length');


        $search = (isset($filter['value'])) ? $filter['value'] : false;

//        dd($request->orderIn);
        $sql = \DB::table('torder_hd')
            ->join('torder_bc', 'torder_hd.XVOrderDocNo', '=', 'torder_bc.XVOrderDocNo')
            ->where('XVOrderBLocation', '=',$request->location)
            ->where(\DB::raw('DATE_FORMAT(XDDateInSend,\'%Y-%m-%d\')'),'=',$request->date)
            ->where('XVOrderBSize','=',$request->size)
            ->where('XVOrderIn','=',$request->orderIn)
            ->select(\DB::raw('DATE_FORMAT(XDDateInSend,\'%Y-%m-%d\') as XDDate'),
                'XVOrderBCode','XVOrderIn',
                'XVOrderDetail','XVOrderBSize')
            ->orderBy('XVOrderBCode','ASC');
// dd($sql);
        $AllData = $sql->count();

        $total_members = $AllData; // get your total no of data;
        // $members = $this->methodToGetMembers($start, $length); //supply start and length of the table data
        $data = $sql->limit($start, $length)->get();

        $data = array(
            'draw' => $draw,
            'recordsTotal' => $total_members,
            'recordsFiltered' => $total_members,
            'data' => $data,
        );

        print  json_encode($data);
    }


}
