<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Carbon\Carbon;
use App\TMtotalsew;
use Auth;
use PDF;
/**
 * Class DashboardController.
 */
class ScanboxController extends Controller
{
    /**
     * @return \Illuminate\View\View
     */
    public function index()
    {
        //dd('box');
        return view('admin.scanbox.index');


    }

    public function create()
    {
        //dd('FG New Create');
        //return view('admin.ppe.create');
        return view('admin.scanbox.create');
    }

    public function edit($id)
    {
        //dd($id);
        //return view('admin.ppedate.showedit');
        $data = DB::table('torder_inout')->where('XIIOID','=',$id)->first();
        //dd($datainout->XVIOSKUin);
        $datanum = DB::table('torder_stockvk')->where('XVStVkSKUin','=',$data->XVIOSKUin)->first();
        //dd($datanum);
        return view('admin.scanbox.edit',['data' => $data,'datanum'=>$datanum]);
    }

    public function store(Request $request)
    {
        //dd($request);

        //$XDIODate=Carbon::createFromFormat('d/m/Y', now())->format('Y-m-d');
        $numstock=($request->XIStVkNum)-($request->XIIONum);
        //dd($numstock);
        DB::beginTransaction();
        try {
                DB::table('torder_inout')->insert(
                    [
                        'XDIODate'          => DB::Raw('now()'),
                        'XIStVkID'          => $request->XIStVkID,
                        'XVOrderIn'         => $request->XVOrderIn,
                        'XVStVkSize'        => $request->XVStVkSize,
                        'XVIOSKUin'         => $request->XVIOSKUin,
                        'XIIONum'           => $request->XIIONum,
                        'XVOrderMItemNo'    => $request->XVOrderMItemNo,
                        'XIIOSta'           => "9",
                        'XIIOinorout'       => "0",
                        'XTWhenCreate'      => DB::Raw('now()'),
                        'XTWhenEdit'        => DB::Raw('now()'),
                        'XVWhoCreate'       => Auth::user()->name,
                        'XVWhoEdit'         => Auth::user()->name,
                    ]
                );
            DB::commit();

            } catch (\Exception $e) {
                //echo $e;
                DB::rollBack();
                abort(500, 'Internal error');
            }

            DB::beginTransaction();
            try {
                    DB::table('torder_stockvk') ->where('XVStVkSKUin','=',$request->XVIOSKUin)
                    ->update(
                        [
                            'XIStVkNum'          => $numstock,
                        ]
                    );
                DB::commit();
                } catch (\Exception $e) {
                //echo $e;
                DB::rollBack();
                    abort(500, 'Internal error');
                }

            return redirect('admin/scanbox')->with('message','ระบบตัด Stock สำเร็จ');

        //return view('admin.scanpackking.create');
    }
    public function update(Request $request,$id){
        // dd($request);
        // $numstock = ($request->XIStVkNum)- ($request->XIIONum);
        DB::beginTransaction();
        try {
                DB::table('torder_inout') ->where('XIIOID','=',$id)
                ->update(
                    [
                        'XVOrderIn'         => $request->XVOrderIn,
                        'XVStVkSize'        => $request->XVStVkSize,
                        'XVIOSKUin'         => $request->XVIOSKUin,
                        'XIIONum'           => $request->XIIONum,
                        'XVOrderMItemNo'    => $request->XVOrderMItemNo,
                        'XTWhenEdit'        => DB::Raw('now()'),
                        'XVWhoEdit'         => Auth::user()->name,

                        ]
                );
            DB::commit();
            } catch (\Exception $e) {
                DB::rollBack();
                abort(500, 'Internal error');
            }

            // DB::beginTransaction();
            // try {
            //         DB::table('torder_stockvk') ->where('XVStVkSKUin','=',$request->XVStVkSKUin)
            //         ->update(
            //             [
            //                 'XIStVkNum'          => $numstock,
            //             ]
            //         );
            //     DB::commit();
            //     } catch (\Exception $e) {
            //     //echo $e;
            //     DB::rollBack();
            //         abort(500, 'Internal error');
            //     }

            return redirect('admin/scanbox')->with('message','ระบบ แก้ไข Stock สำเร็จ');


    }


    public function getdata()
    {
        $sql="select * from torder_inout where (XIIOinorout='0') and (XIIOSta='9') order by XDIODate desc";
        $data = \DB::select($sql);
        $data = array(
            'data' => $data,
        );

        print json_encode($data);
    }

    public function findsku(Request $request)
    {
        $sql="select * from torder_stockvk where XVStVkSKUin='$request->id'";
        $result = \DB::select($sql);
//        dd($result);
        return response()->json($result);
    }

    public function report()
    {
        //dd("Report box");
        return view('admin.scanbox.report');
    }


    public function reportpdf(Request $request)
    {
        // dd($request);
        $dateStart =  Carbon::createFromFormat('d/m/Y', $request->dateStart)->format('Y-m-d');
        $dateEnd =  Carbon::createFromFormat('d/m/Y', $request->dateEnd)->format('Y-m-d');
        // dd($dateStart);
        $sql="select * from torder_inout
                WHERE cast(XDIODate as date) Between '" . $dateStart . "' and '" . $dateEnd . "' and XIIOSta='9'
                order by XVOrderMItemNo";

                $res_bc = \DB::select($sql);
        // dd($res_bc);

        $pdf = PDF::loadView('admin.scanbox.reportpdf', ['res_bc'=>$res_bc]);

        return $pdf->stream();

    }


}
