<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use PDF;
use Illuminate\Support\Carbon;


/**
 * Class DashboardController.
 */
class ScansendBleachReporAdminController extends Controller
{
    /**
     * @return \Illuminate\View\View
     */
    public function index()
    {
        return view('admin.scansendbleachadmin.index');
    }

    public function create()
    {
        return view('admin.scansendbleachadmin.create');
    }

    public function edit()
    {
        return view('admin.scansendbleachadmin.edit');
    }

    public function report()
    {
        return view('admin.scansendbleachadmin.report');
    }

    public function reportPdf(Request $request)
    {

        $dateStart =  Carbon::createFromFormat('d/m/Y', $request->dateStart)->format('Y-m-d');
        $dateEnd =  Carbon::createFromFormat('d/m/Y', $request->dateEnd)->format('Y-m-d');
        $blench = \DB::table('TMblench')->get();
        // dd($dateStart, $dateEnd);

        $sql = "select XVOrderDocNo,XVOrderBSize,count(XVOrderBarNo) as count_all
                    from torder_bc
                    WHERE cast(XDDateInBlench as date) Between '" . $dateStart . "' and '" . $dateEnd . "'
                    GROUP BY XVOrderDocNo,XVOrderBSize
                    ORDER BY XVOrderDocNo,XVOrderBSize";

        $res_bc = \DB::select($sql);
        $res = [
            'res_bc'     => $res_bc,
            'dateStart'     => $request->dateStart,
            'dateEnd'     => $request->dateEnd,
            'blench'     => $blench,

        ];

        $pdf = PDF::loadView('admin.scansendbleachadmin.report_pdf', compact('res'));

        return $pdf->stream();
    }

    public function sendReport()
    {
        $blench = \DB::table('TMblench')->get();

        $report = [

            'blench'      => $blench,
        ];
        return view('admin.scansendbleachadmin.Sendreport', compact('report'));

    }

    public function sendReportPdf(Request $request)
    {


        $dateStart =  Carbon::createFromFormat('d/m/Y', $request->dateStart)->format('Y-m-d');
        $dateEnd =  Carbon::createFromFormat('d/m/Y', $request->dateEnd)->format('Y-m-d');
        $blench = $request->input('blench');
        // $blenchDB = \DB::table('tmblench')->where('XIBlenchCode', $blench)->first();
        $blenchDB = \DB::table('tmblench')->where('XIBlenchCode', '=', $blench)->first('XVBlenchName');



        // dd($dateStart, $dateEnd);

        $sql = "select XVOrderDocNo,XVOrderBSize,count(XVOrderBarNo) as count_all
                    from torder_bc
                    WHERE cast(XDDateInThread as date) Between '" . $dateStart . "' and '" . $dateEnd . "'
                    GROUP BY XVOrderDocNo,XVOrderBSize
                    ORDER BY XVOrderDocNo,XVOrderBSize";

        $res_bc = \DB::select($sql);
        // dd($res_bc);

        // $res_bc = \DB::table("torder_bc")->whereRaw(" cast(XDDateInBlench as date) Between '" . $dateStart . "' and '" . $dateEnd . "'")


        $res = [
            'res_bc'     => $res_bc,
            'dateStart'     => $request->dateStart,
            'dateEnd'     => $request->dateEnd,
            'blench'  =>  $blench,
            'blenchDB' => $blenchDB,
            'XVBlenchName' => $blenchDB->XVBlenchName

        ];

         //dd( $res, $blenchDB);

        // return view('admin.scansendbleachadmin.report_pdf', compact('res'));

        $pdf = PDF::loadView('admin.scansendbleachadmin.sendReport_pdf', compact('res'));

        return $pdf->stream();
    }
    public function update(Request $request)
    {
        // dd($XVOrderDocNo);
        $chk_dup = \DB::table('torder_bc')->where('XVOrderBCode', $request->barcode)->where('XVOrderBLocation', $request->location)->get();
        // $chk_dup = \DB::table('torder_bc')->where('XVOrderBCode','3220191100010002')->where('XVOrderBLocation','4')->get();
        // dd(count($chk_dup));
        if (count($chk_dup) > 0) {
            return response()->json([
                'success'     => '2',
                'order_no'    => '',
                'size'        => ''
            ]);
        }
        // dd();




        $res = \DB::table('torder_bc')->where('XVOrderBCode', $request->barcode)->first();
        if (!$res) {
            $status = 0;
        }
        // dd($res);

        return response()->json([
            'success'     => $status,
            'order_no'    => @$res->XVOrderDocNo,
            'size'        => @$res->XVOrderBSize
        ]);
    }
}
