<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Carbon\Carbon;
use App\TMtotalsew;
use Auth;
use PDF;

/**
 * Class DashboardController.
 */
class SendSewController extends Controller
{
    /**
     * @return \Illuminate\View\View
     */
    public function index()
    {
        // dd('cutcloth');
        return view('admin.sendsew.index');
    }

    public function inputqc()
    {
        // dd("inQQQ");
        return view('admin.sendsew.index2');
    }


    public function create()
    {
        // dd('Qc New Create');
        $totalsews    = TMtotalsew::all();
        $totalsews = \DB::table('tmtotalsew')->get();

        // $data = DB::table('torder_inout')->where('XIIOID','=',$id)->first();

        // $orders = [
        //     'totalsews'    => $totalsews,
        //     'data' => $data
        // ];
        // dd($orders);

        return view('admin.sendsew.create', [
            'totalsews'    => $totalsews
        ]);


        // return view('admin.sendsew.create',['data' => $data]);
    }

    public function findsku(Request $request)
    {
        $sql="select * from torder_stockvk where XVStVkSKUin='$request->id'";
        $result = \DB::select($sql);
//        dd($result);
        return response()->json($result);
    }

    public function edit($id)
    {
        // dd($id);
        $data = DB::table('torder_inout')->where('XIIOID','=',$id)->first();
        return view('admin.sendsew.edit',['data' => $data]);
    }

    public function store(Request $request)
    {
        // dd($request);
        $XDIODate=Carbon::createFromFormat('d/m/Y',$request->XDIODate)->format('Y-m-d');

        DB::beginTransaction();
        try {
                DB::table('torder_inout')->insert(
                    [
                        'XDIODate'          => $XDIODate,
                        'XVOrderIn'         => $request->XVOrderIn,
                        'XVStVkSize'        => $request->XVStVkSize,
                        'XVIOSKUin'         => $request->XVIOSKUin,
                        'XIIONum'           => $request->XIIONum,
                        'XVOinoutNote'      => $request->XVOinoutNote,
                        'XIIOSta'           => "34",
                        'XIIOinorout'       => "1",
                        'XTWhenCreate'      => DB::Raw('now()'),
                        'XTWhenEdit'        => DB::Raw('now()'),
                        'XVWhoCreate'       => Auth::user()->name,
                        'XVWhoEdit'         => Auth::user()->name,
                    ]
                );
            DB::commit();
            } catch (\Exception $e) {
                //echo $e;
                DB::rollBack();
                abort(500, 'Internal error');
            }

            return redirect('admin/sendsew')->with('message','บันทึกสำเร็จ');


    }

    public function update(Request $request,$id){
        // dd($request);
        // $XIIOinoutedit = $request->XIIOinoutedit == 'true'? 0:1;
        $XDIODate=Carbon::createFromFormat('d/m/Y',$request->XDIODate)->format('Y-m-d');

        DB::beginTransaction();
        try {
                DB::table('torder_inout') ->where('XIIOID','=',$id)
                ->update(
                    [
                        'XDIODate'          => $XDIODate,
                        'XVOrderIn'         => $request->XVOrderIn,
                        'XVStVkSize'        => $request->XVStVkSize,
                        'XVIOSKUin'         => $request->XVIOSKUin,
                        'XIIONum'           => $request->XIIONum,
                        'XIIOinorout'       => "1",
                        'XTWhenEdit'        => DB::Raw('now()'),
                        'XVWhoEdit'         => Auth::user()->name,

                        ]
                );
            DB::commit();
            } catch (\Exception $e) {
                DB::rollBack();
                abort(500, 'Internal error');
            }
            return redirect('admin/sendsew')->with('message','บันทึกสำเร็จ');


    }


    public function getdata()
    {
        //dd("testvkG");
        // $sql="select * from torder_inout where (XIIOinorout='1') and (XIIOSta='5') order by XDIODate desc";
        $sql="select * from torder_inout where XIIOSta='34' order by XIIOID desc";
        $data = \DB::select($sql);
        $data = array(
            'data' => $data,
        );

        print json_encode($data);
    }

    public function getdata2()
    {
        //dd("testvkG");
        // $sql="select * from torder_inout where (XIIOinorout='1') and (XIIOSta='5') order by XDIODate desc";
        $sql="select * from torder_inout where XIIOSta='88' order by XIIOID desc";
        $data = \DB::select($sql);
        $data = array(
            'data' => $data,
        );

        print json_encode($data);
    }

    public function report()
    {
        //dd("Report Fg");
        return view('admin.sendsew.report');
    }

    public function reportpdf(Request $request)
    {
        $dateStart =  Carbon::createFromFormat('d/m/Y', $request->dateStart)->format('Y-m-d');
        $dateEnd =  Carbon::createFromFormat('d/m/Y', $request->dateEnd)->format('Y-m-d');
        // dd($dateStart);
        $sql="select * from torder_inout
                WHERE cast(XDIODate as date) Between '" . $dateStart . "' and '" . $dateEnd . "' and XIIOSta='34'
                order by XDIODate";

                $res_bc = \DB::select($sql);

                $pdf = PDF::loadView('admin.sendsew.reportpdf', ['res_bc'=>$res_bc]);

                return $pdf->stream();
        
    }

    public function dele($id)
    {
        //dd($id);
        $data = DB::table('torder_inout')->where('XIIOID','=',$id)->delete();
        return view('admin.sendsew.index');
    }


}
