<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Carbon\Carbon;
use App\TMtotalsew;
use Auth;
use PDF;
/**
 * Class DashboardController.
 */
class SewInController extends Controller
{
    /**
     * @return \Illuminate\View\View
     */
    public function index()
    {
        //  dd(Auth::user()->XIBranchCode);
        // $u1 = Auth::user()->XIBranchCode;
        // switch ($u1){
        //     case "31":
        //         dd("31");
        //         break;
        //     case "32":
        //         dd("32");
        //         break;
        //     default:
        //         dd("Other");
        // }

        return view('admin.sewin.index');
    }

    public function findsku(Request $request)
    {
        $sql="select * from torder_stockvk where XVStVkSKUin='$request->id'";
        $result = \DB::select($sql);
//        dd($result);
        return response()->json($result);
    }



    public function create()
    {
        // dd('Qc New Create');
        // $data = DB::table('torder_inout')->where('XIIOID','=',$id)->first();
        return view('admin.sewin.create');
    }

    public function edit($id)
    {
        // dd($id);
        $data = DB::table('torder_inout')->where('XIIOID','=',$id)->first();
        return view('admin.sewin.edit',['data' => $data]);
    }

    public function store(Request $request)
    {
        // dd($request);
        $XDIODate=Carbon::createFromFormat('d/m/Y',$request->XDIODate)->format('Y-m-d');
        $u1 = Auth::user()->XIBranchCode;
        // dd($u1);
        $u1 = Auth::user()->XIBranchCode;
        if (is_null($u1)) {
            $u2="ไม่ระบุ";
        } else {
            $data = DB::table('tmbranch')->where('XIBranchCode','=',$u1)->first();
            $u2 =$data->XVBranchName;
        }

        // dd($u2);
        // dd($u1);
        // dd($request);
        DB::beginTransaction();
        try {
                DB::table('torder_inout')->insert(
                    [
                        'XDIODate'          => $XDIODate,
                        'XVOrderIn'         => $request->XVOrderIn,
                        'XVStVkSize'        => $request->XVStVkSize,
                        'XVIOSKUin'         => $request->XVIOSKUin,
                        'XIIONum'           => $request->XIIONum,
                        'XIIOSta'           => "35",
                        'XIIOinorout'       => "1",
                        'XVOinoutNote'      => $u2,
                        'XIIOinoutedit'     => $u1,
                        'XTWhenCreate'      => DB::Raw('now()'),
                        'XTWhenEdit'        => DB::Raw('now()'),
                        'XVWhoCreate'       => Auth::user()->name,
                        'XVWhoEdit'         => Auth::user()->name,
                    ]
                );
            DB::commit();
            } catch (\Exception $e) {
                //echo $e;
                DB::rollBack();
                abort(500, 'Internal error');
            }

            return redirect('admin/sewin')->with('message','บันทึกสำเร็จ');


    }

    public function update(Request $request,$id){
        //  dd($request);
        //  dd($id);
        // $XIIOinoutedit = $request->XIIOinoutedit == 'true'? 0:1;
        $XDIODate=Carbon::createFromFormat('d/m/Y',$request->XDIODate)->format('Y-m-d');

        DB::beginTransaction();
        try {
                DB::table('torder_inout') ->where('XIIOID','=',$id)
                ->update(
                    [
                        'XDIODate'          => $XDIODate,
                        'XVOrderIn'         => $request->XVOrderIn,
                        'XVStVkSize'        => $request->XVStVkSize,
                        'XVIOSKUin'         => $request->XVIOSKUin,
                        'XIIONum'           => $request->XIIONum,
                        'XIIOinorout'       => "0",
                        'XTWhenEdit'        => DB::Raw('now()'),
                        'XVWhoEdit'         => Auth::user()->name,

                        ]
                );
            DB::commit();
            } catch (\Exception $e) {
                DB::rollBack();
                abort(500, 'Internal error');
            }
            return redirect('admin/sewin')->with('message','บันทึกสำเร็จ');


    }


    public function getdata()
    {

        $u1 = Auth::user()->XIBranchCode;
        if (is_null($u1)) {
            $sql="select * from torder_inout where XIIOSta='35' order by XIIOID desc";
        } else {
            $sql="select * from torder_inout where (XIIOSta='35') and (XIIOinoutedit=$u1) order by XIIOID desc";
        }

        $data = \DB::select($sql);
        $data = array(
            'data' => $data,
        );

        print json_encode($data);
    }


    public function report()
    {
        //dd("Report Fg");
        return view('admin.sewin.report');
    }

    public function reportpdf(Request $request)
    {
        $u1 = Auth::user()->XIBranchCode;
        $dateStart =  Carbon::createFromFormat('d/m/Y', $request->dateStart)->format('Y-m-d');
        $dateEnd =  Carbon::createFromFormat('d/m/Y', $request->dateEnd)->format('Y-m-d');
        // dd($dateStart);

        if (is_null($u1)) {
            $sql="select * from torder_inout
            WHERE cast(XDIODate as date) Between '" . $dateStart . "' and '" . $dateEnd . "' and XIIOSta='35'
            order by XDIODate";
        } else {
            $sql="select * from torder_inout
            WHERE cast(XDIODate as date) Between '" . $dateStart . "' and '" . $dateEnd . "' and XIIOSta='35' and XIIOinoutedit=$u1
            order by XDIODate";
        }


        // switch ($u1){
        //     case "31":
        //         // dd("31");
        //         $sql="select * from torder_inout
        //         WHERE cast(XDIODate as date) Between '" . $dateStart . "' and '" . $dateEnd . "' and XIIOSta='3' and XIIOinoutedit='31'
        //         order by XDIODate";
        //     break;
        //     case "32":
        //         // dd("32");
        //         $sql="select * from torder_inout
        //         WHERE cast(XDIODate as date) Between '" . $dateStart . "' and '" . $dateEnd . "' and XIIOSta='3' and XIIOinoutedit='32'
        //         order by XDIODate";
        //     break;
        //     default:
        //     $sql="select * from torder_inout
        //     WHERE cast(XDIODate as date) Between '" . $dateStart . "' and '" . $dateEnd . "' and XIIOSta='3'
        //     order by XDIODate";
        // dd("Other");
        // }


        $res_bc = \DB::select($sql);
        $pdf = PDF::loadView('admin.sewin.reportpdf', ['res_bc'=>$res_bc]);

        return $pdf->stream();

    }

    public function dele($id)
    {
        // dd($id);
        $data = DB::table('torder_inout')->where('XIIOID','=',$id)->delete();
        return view('admin.sewin.index');
    }


}
