<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\GennarateidController;
use App\Http\Requests\MassDestroySewinglocatinRequest;
use App\Http\Requests\StoreSewinglocatinRequest;
use App\Http\Requests\UpdateSewinglocatinRequest;
use App\TMsew;

use Illuminate\Support\Facades\Auth;

class SewinglocatinController extends Controller
{
    public function index()
    {

        abort_unless(\Gate::allows('sew_access'), 403);

        $sews = TMsew::all();


        return view('admin.sewinglocatin.index', compact('sews'));
    }

    public function create()
    {
        abort_unless(\Gate::allows('sew_create'), 403);

        return view('admin.sewinglocatin.create');
    }

    public function store(StoreSewinglocatinRequest $request)
    {
        abort_unless(\Gate::allows('sew_create'), 403);

        // $docid = GennarateidController::Gent5id("TMsew", "XISewCode");

        //add request
        // $request->request->add(['XISewCode' => $docid]);
        $request->request->add(['XVWhoCreate' => Auth::user()->name]);
        $request->request->add(['XVWhoEdit' => Auth::user()->name]);
        $sewinglocatin = TMsew::create($request->all());

        return redirect()->route('admin.sewinglocatin.index');
    }

    public function edit(TMsew $sewinglocatin)
    {

        abort_unless(\Gate::allows('sew_edit'), 403);

        return view('admin.sewinglocatin.edit', compact('sewinglocatin'));
    }

    public function update(UpdateSewinglocatinRequest $request, TMsew $sewinglocatin)
    {

        abort_unless(\Gate::allows('sew_edit'), 403);

        //add request
        $request->request->add(['XVWhoEdit' => Auth::user()->name]);
        $sewinglocatin->update($request->all());

        return redirect()->route('admin.sewinglocatin.index');
    }

    public function show(TMsew $sewinglocatin)
    {
        abort_unless(\Gate::allows('sew_show'), 403);

        return view('admin.sewinglocatin.show', compact('sewinglocatin'));
    }

    public function destroy(TMsew $sewinglocatin)
    {
        abort_unless(\Gate::allows('sew_delete'), 403);

        // $sewinglocatin->update(['XVWhoEdit' => Auth::user()->name]);
        $sewinglocatin->delete();

        return back();
    }

    public function massDestroy(MassDestroySewinglocatinRequest $request)
    {
        abort_unless(\Gate::allows('sew_delete'), 403);

        //add request
        // TMsew::whereIn('XISewCode', request('ids'))->update(['XVWhoEdit' => Auth::user()->name]);
        TMsew::whereIn('XISewCode', request('ids'))->delete();

        return response(null, 204);
    }
}
