<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Torder_box;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

/**
 * Class DashboardController.
 */
class ShippingMarkController extends Controller
{
    /**
     * @return \Illuminate\View\View
     */
    public function index()
    {
        $box = \DB::table('torder_box')
            ->select('XVPONbr', 'XVStoreNbr', 'XVBoxCode')
            ->groupBy('XVPONbr', 'XVStoreNbr', 'XVBoxCode')
            ->get();

        $data = [
            'box' => $box
        ];
        // dd($data);

        return view('admin.shippingmark.index', compact('data'));
    }

    public function createData($XVPONbr, $XVStoreNbr)
    {

        // dd($id);
        $boxDB = DB::table('torder_box')->where('XVPONbr', '=', $XVPONbr)
            ->where('XVStoreNbr', $XVStoreNbr)
            ->first();
        $box = DB::table('torder_box')->where('XVPONbr', '=', $XVPONbr)
            ->where('XVStoreNbr', $XVStoreNbr)
            ->get();

        $data = [
            'box' => $box,
            'boxDB' => $boxDB,
        ];
        // dd($boxDB);
        return view('admin.shippingmark.create', compact('data'));
    }

    public function edit()
    {
        return view('admin.shippingmark.edit');
    }

    public function getData(Request $request)
    {


        $draw = $request->get('draw');
        $start = $request->get('start');
        $length = $request->get('length');


        $search = (isset($filter['value'])) ? $filter['value'] : false;

        $sql = \DB::table('torder_bc')
            ->select('XVOrderBCode', 'XVOrderDocNo', 'XVOrderBSize', 'XDDateInNoQC')
            ->where('XVOrderBLocation', $request->location);

        $AllData = $sql->count();

        $total_members = $AllData; // get your total no of data;
        // $members = $this->methodToGetMembers($start, $length); //supply start and length of the table data
        $data = $sql->limit($start, $length)->get();

        $data = array(
            'draw' => $draw,
            'recordsTotal' => $total_members,
            'recordsFiltered' => $total_members,
            'data' => $data,
        );

        print  json_encode($data);
    }

    public function store(Request $request)
    {

        Torder_box::where('XVPONbr', $request->XVPONbr)
            ->where('XVStoreNbr', $request->XVStoreNbr)
            ->update(['XVBoxCode' => $request->XVBoxCode]);

        return redirect()->route('admin.shippingmark.index');
    }
}
