<?php

namespace App\Http\Requests;

use App\TMbranch;
use Gate;
use Illuminate\Foundation\Http\FormRequest;

class MassDestroybranchRequest extends FormRequest
{
    public function authorize()
    {
        return abort_if(Gate::denies('branch_delete'), 403, '403 Forbidden') ?? true;
    }

    public function rules()
    {
        return [
            'ids'   => 'required|array',
            'ids.*' => 'exists:TMbranch,XIbranchCode',
        ];
    }
}
