<?php

namespace App\Http\Requests;

use App\tmcustomer;
use Gate;
use Illuminate\Foundation\Http\FormRequest;

class MassDestroyCustomerRequest extends FormRequest
{
    public function authorize()
    {
        return abort_if(Gate::denies('customer_delete'), 403, '403 Forbidden') ?? true;
    }

    public function rules()
    {
      return [
          'ids'   => 'required|array',
          'ids.*' => 'exists:TMcustomer,XIGuestCode',
      ];
    }
}
