<?php

namespace App\Http\Requests;

use App\tmgenerate;
use Gate;
use Illuminate\Foundation\Http\FormRequest;

class MassDestroyFormRequest extends FormRequest
{
    public function authorize()
    {
        return abort_if(Gate::denies('form_delete'), 403, '403 Forbidden') ?? true;
    }

    public function rules()
    {
        return [
            'ids'   => 'required|array',
            'ids.*' => 'exists:TMgenerate,XIGenerateCode',
        ];
    }
}
