<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class HomeController
{
    public function index()
    {
        $XDDateInBlench = DB::select('Select count(*) As num
                            from torder_bc
                            where CAST(XDDateInBlench AS date) =CAST(NOW() AS date)
                            GROUP BY CAST(XDDateInBlench AS date)');
        $XDDateInThread = DB::select('Select count(*) As num
                            from torder_bc
                            where CAST(XDDateInThread AS date) = CAST(NOW() AS date)
                            GROUP BY CAST(XDDateInThread AS date)');
        $XDDateInStockFG = DB::select('Select count(*) As num
                            from torder_bc
                            where CAST(XDDateInStockFG AS date) = CAST(NOW() AS date)
                            GROUP BY CAST(XDDateInStockFG AS date)');
        $XDDateInQC = DB::select('Select count(*) As num
                            from torder_bc
                            where CAST(XDDateInQC AS date) = CAST(NOW() AS date)
                            GROUP BY CAST(XDDateInQC AS date)');
        $XDDateInPack = DB::select('Select count(*) As num
                            from torder_bc
                            where CAST(XDDateInPack AS date) = CAST(NOW() AS date)
                            GROUP BY CAST(XDDateInPack AS date)');
        $XDDateInBox = DB::select('Select count(*) As num
                            from torder_bc
                            where CAST(XDDateInBox AS date) = CAST(NOW() AS date)
                            GROUP BY CAST(XDDateInBox AS date)');
        $sql = DB::select('Select t.XIOrderTCode, count(h.XIOrderTCode) as amount , t.XVOrderTName
                            from tmordertype t
                            left JOIN torder_hd h
                            on t.XIOrderTCode = h.XIOrderTCode
                            GROUP BY t.XIOrderTCode');
        $allBox = DB::select('Select SUM(XIOrderQty) As num from torder_box');

//        dd($XDDateInBlench);
        return view('home', [
            'groupType' => $sql,
            'XDDateInBlench'=>$XDDateInBlench,
            'XDDateInThread'=>$XDDateInThread,
            'XDDateInStockFG'=>$XDDateInStockFG,
            'XDDateInQC'=>$XDDateInQC,
            'XDDateInPack'=>$XDDateInPack,
            'XDDateInBox'=>$XDDateInBox,
            'allBox'=>$allBox
        ]);
    }

    public function show_data_type($id)
    {
        $sql = DB::table('torder_hd')
            ->join('tmordertype', 'torder_hd.XIOrderTCode', '=', 'tmordertype.XIOrderTCode')
            ->where('torder_hd.XIOrderTCode', '=', $id)
            ->select('torder_hd.*', 'tmordertype.XVOrderTName')
            ->get();
//        dd($sql);
        return view('admin.showDataOfType.show', ['id' => $id]);
    }

    public function get_data_type(Request $request)
    {

        $draw = $request->get('draw');
        $start = $request->get('start');
        $length = $request->get('length');


        $search = (isset($filter['value'])) ? $filter['value'] : false;

        $sql = DB::table('torder_hd')
            ->join('torder_dt', 'torder_hd.XVOrderDocNo', '=', 'torder_dt.XVOrderDocNo')
            ->where('torder_hd.XIOrderTCode', '=', $request->id)
            ->select('torder_hd.XDOrderDocMDate', 'torder_hd.XDOrderDateApprove',
                'torder_dt.XIOrderDTotalNum', 'torder_hd.XVOrderDetail', 'torder_hd.XIOrderTCode')
            ->groupBy('torder_hd.XVOrderDocNo')
            ->orderBy('torder_hd.XDOrderDocMDate', 'desc');
        // dd($request->location);
//         dd($sql);

        $AllData = $sql->count();

        $total_members = $AllData; // get your total no of data;
        // $members = $this->methodToGetMembers($start, $length); //supply start and length of the table data
        $data = $sql->limit($start, $length)->get();

        $data = array(
            'draw' => $draw,
            'recordsTotal' => $total_members,
            'recordsFiltered' => $total_members,
            'data' => $data,
        );

        print  json_encode($data);
    }

    public function show_qty_box(){
        return view('admin.showDataOfType.showT_box');
    }
    public function get_qty_box(Request $request)
    {

        $draw = $request->get('draw');
        $start = $request->get('start');
        $length = $request->get('length');


        $search = (isset($filter['value'])) ? $filter['value'] : false;

        $sql = DB::table('torder_box')
            ->select('XVSize','XVDescription',DB::raw('SUM(XIOrderQty) As Qty'))
            ->groupBy('XVSize','XVDescription')
            ->orderBy('XVSize', 'ASC');
        // dd($request->location);
//         dd($sql);

        $AllData = $sql->count();

        $total_members = $AllData; // get your total no of data;
        // $members = $this->methodToGetMembers($start, $length); //supply start and length of the table data
        $data = $sql->limit($start, $length)->get();

        $data = array(
            'draw' => $draw,
            'recordsTotal' => $total_members,
            'recordsFiltered' => $total_members,
            'data' => $data,
        );

        print  json_encode($data);
    }

}
