@extends('layouts.admin')

@section('title', 'หน้าจอเพิ่มกลุ่มอุปกรณ์ | เพิ่ม')

@section('content')


  <form action="{{ route("admin.accgroup.store") }}" method="POST" enctype="multipart/form-data">
      @csrf


    <div class="card">
        <div class="card-header">
            {{ trans('global.create') }} กลุ่มอุปกรณ์
        </div>

        <div class="card-body">

            <div class="form-group {{ $errors->has('XVAccGroupName') ? 'has-error' : '' }}">
                <label for="XVAccGroupName">ชื่อกลุ่มอุปกรณ์ *</label>
                <input type="text" id="XVAccGroupName" name="XVAccGroupName" class="form-control" maxlength="191" value="{{ old('XVAccGroupName', isset($accgroup) ? $accgroup->XVAccGroupName : '') }}" required autofocus>
                @if($errors->has('XVAccGroupName'))
                    <em class="invalid-feedback">
                        กรุณากรอกชื่อกลุ่มอุปกรณ์
                    </em>
                @endif
            </div>


             <div class="checkbox d-flex align-items-center">
                {{-- <label class="switch switch-label switch-pill switch-primary mr-2" for="role-1"> --}}
                    <input class="" type="checkbox" name="XVStatus" id="XVStatus" value="1" checked   > ใช้งาน
                    {{-- <span class="switch-slider" data-checked="on" data-unchecked="off"></span></label> --}}

            </div>

      </div>

      <div class="card-footer">
          <div class="row">
              <div class="col">
                <a href="{{route('admin.accgroup.index')}}" class="btn btn-danger active" role="button" aria-pressed="true">{{ trans('global.back') }}</a>
              </div>

              <div class="col text-right">
                <input class="btn btn-success active" type="submit" value="{{ trans('global.save') }}">
              </div>
          </div>
      </div>

    </div>

</form>
@endsection
