@extends('layouts.admin')

@section('title', env('APP_NAME') . ' | ตรวจสอบ Order')

@section('content')
    <div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    ตรวจสอบ Order
                </h4>
            </div><!--col-->

            {{-- <div class="col-sm-7 pull-right">
                    <div class="btn-toolbar float-right">
                        <a href="{{ url('admin/scanforbleachingjobs/create') }}" class="btn btn-success ml-1" data-toggle="tooltip" title="เพิ่มข้อมูล"><i class="fas fa-plus-circle"></i></a>
                    </div>
            </div><!--col--> --}}
        </div><!--row-->

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive " >
                    <table class="table display" id="datatable"  style="width:100%">
                        <thead>
                        <tr>
                                <th scope="col">เลขที่เอกสาร</th>
                                <th scope="col">รายละเอียด</th>
                                <th scope="col">รหัสภายใน</th>
                                <th scope="col">Size</th>
                                <th scope="col">จำนวน</th>
                                <th scope="col">ฟอก</th>
                                <th scope="col">FG</th>
                                <th scope="col">ซ่อม</th>
                                <th scope="col">OH</th>
                                <th scope="col">กล่อง</th>
                                <th scope="col">จัดการ</th>
                        </tr>
                        </thead>

                    </table>

                </div>
            </div><!--col-->
        </div><!--row-->
        <div class="row">
            <div class="col-7">
                <div class="float-left">
                    {{-- {!! $roles->total() !!} {{ trans_choice('labels.backend.access.roles.table.total', $roles->total()) }} --}}
                </div>
            </div><!--col-->

            <div class="col-5">
                <div class="float-right">
                    {{-- {!! $roles->render() !!} --}}
                </div>
            </div><!--col-->
        </div><!--row-->
    </div><!--card-body-->
</div><!--card-->
@endsection

    @section('styles')
    <link href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css" rel="stylesheet" />
    @endsection
    @section('scripts')
    <script>
        $(document).ready(function() {

            var url = '{{ url('admin/checkorder')}}';


            $('#datatable').DataTable( {
                // "processing": true,
                //  "serverSide": true,
                pageLength: 10,
                "ajax": {
                    url : "{{url('')}}/admin/checkorderGetData",
                    data:{_token: "{{csrf_token()}}"} ,
                    dataType: "json",
                    type: "POST",
                    },
                "columns": [
                    { data: 'XVOrderDocNo' },
                    { data: 'XVOrderDetail' },
                    { data: 'XVOrderIn' },
                    { data: 'XVOrderDSize' },
                    { data: 'XIOrderDTotalNum' },
                    { data: 'BlenchQty' },
                    { data: 'FGQty' },
                    { data: 'RepairQty' },
                    { data: 'OHQty' },
                    { data: 'BoxQty' },
                    {
                    sortable: false,
                    "render": function ( data, type, full, meta ) {
                        return '<a href="{{ url('admin/checkorderDetail')}}/'+full.XVOrderDocNo+'/'+full.XVOrderDSize+'/'+'" class="btn btn-primary" data-toggle="tooltip" data-placement="top" title="จัดการ"><i class="fas fa-eye"></i></a>';
                    }
                    },
                ]
            } );


            $('#datatable tbody').on( 'click', 'button', function () {
                var data = $(this).parents('tr')
                console.log(data)
                // alert( data[0] +"'s salary is: "+ data[ 5 ] );
            } );

        })
    </script>
    @endsection
