@extends('layouts.admin')
@section('content')


  <form action="{{ route("admin.customer.store") }}" method="POST" enctype="multipart/form-data">
      @csrf


    <div class="card">
        <div class="card-header">
            {{ trans('global.create') }}{{ trans('global.customers') }}
        </div>

        <div class="card-body">

            <div class="form-group {{ $errors->has('XVGuestName') ? 'has-error' : '' }}">
                <label for="name">{{ trans('global.TMcustomer.fields.XVGuestName') }}*</label>
                <input type="text" id="XVGuestName" name="XVGuestName" class="form-control" value="{{ old('XVGuestName', isset($customer) ? $customer->XVGuestName : '') }}">
                @if($errors->has('XVGuestName'))
                    <em class="invalid-feedback">
                        กรุณากรอกชื่อ
                        {{-- {{ $errors->first('XVGuestName') }} --}}
                    </em>
                @endif
                <p class="helper-block">
                    {{ trans('global.TMcustomer.fields.XVGuestName_helper') }}
                </p>
            </div>

            <div class="form-group {{ $errors->has('XVNameContact') ? 'has-error' : '' }}">
                <label for="price">{{ trans('global.TMcustomer.fields.XVNameContact') }}</label>
                <input type="text" id="XVNameContact" name="XVNameContact" class="form-control" value="{{ old('XVNameContact', isset($customer) ? $customer->XVNameContact : '') }}">
                @if($errors->has('XVNameContact'))
                    <em class="invalid-feedback">
                        {{ $errors->first('XVNameContact') }}
                    </em>
                @endif
                <p class="helper-block">
                    {{ trans('global.TMcustomer.fields.XVNameContact_helper') }}
                </p>
            </div>

            <div class="form-group {{ $errors->has('XVGuestTel') ? 'has-error' : '' }}">
                <label for="price">{{ trans('global.TMcustomer.fields.XVGuestTel') }}</label>
                <input type="text" id="XVGuestTel" name="XVGuestTel" class="form-control" value="{{ old('XVGuestTel', isset($customer) ? $customer->XVGuestTel : '') }}" >
                @if($errors->has('XVGuestTel'))
                    <em class="invalid-feedback">
                        {{ $errors->first('XVGuestTel') }}
                    </em>
                @endif
                <p class="helper-block">
                    {{ trans('global.TMcustomer.fields.XVGuestTel_helper') }}
                </p>
            </div>

            <div class="form-group {{ $errors->has('XVGuestAddress') ? 'has-error' : '' }}">
                <label for="XVGuestAddress">{{ trans('global.TMcustomer.fields.XVGuestAddress') }}</label>
                <textarea id="XVGuestAddress" name="XVGuestAddress" class="form-control ">{{ old('XVGuestAddress', isset($customer) ? $customer->XVGuestAddress : '') }}</textarea>
                @if($errors->has('XVGuestAddress'))
                    <em class="invalid-feedback">
                        {{ $errors->first('XVGuestAddress') }}
                    </em>
                @endif
                <p class="helper-block">
                    {{ trans('global.TMcustomer.fields.XVGuestAddress_helper') }}
                </p>
            </div>

      </div>

      <div class="card-footer">
          <div class="row">
              <div class="col">
                <a href="{{route('admin.customer.index')}}" class="btn btn-danger active" role="button" aria-pressed="true">{{ trans('global.back') }}</a>
              </div>

              <div class="col text-right">
                <input class="btn btn-success active" type="submit" value="{{ trans('global.save') }}">
              </div>
          </div>
      </div>

    </div>

</form>
@endsection
