@extends('layouts.admin')

@section('title', 'หน้าจอสำหรับ | แก้ไข')

@section('content')

  <form action="{{ route("admin.foruse.update", [$foruse->XIForCode]) }}" method="POST" enctype="multipart/form-data">
    @csrf
    @method('PUT')
    <div class="card">
        <div class="card-header">
            {{ trans('global.create') }}{{ trans('global.foruse') }}
        </div>

        <div class="card-body">

            <div class="form-group {{ $errors->has('XVForType') ? 'has-error' : '' }}">
                <label for="name">{{ trans('global.TMforuse.fields.XVForType') }}*</label>
                <input type="text" id="XVForType" name="XVForType" class="form-control" maxlength="191" value="{{ old('XVForType', isset($foruse) ? $foruse->XVForType : '') }}" required autofocus>
                @if($errors->has('XVForType'))
                    <em class="invalid-feedback">
                        {{ $errors->first('XVForType') }}
                    </em>
                @endif
                <p class="helper-block">
                    {{ trans('global.TMforuse.fields.XVForType_helper') }}
                </p>
            </div>

      </div>

      <div class="card-footer">
          <div class="row">
              <div class="col">
                <a href="{{route('admin.foruse.index')}}" class="btn btn-danger active" role="button" aria-pressed="true">{{ trans('global.back') }}</a>
              </div>

              <div class="col text-right">
                <input class="btn btn-success active" type="submit" value="{{ trans('global.save') }}">
              </div>
          </div>
      </div>

    </div>

</form>
@endsection
