@extends('layouts.admin')

@section('title', env('APP_NAME') . ' | รายงานตาม Order แยกตามโรงฟอก')

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    รายงานตาม Order แยกตามโรงฟอก {{-- @lang('labels.backend.access.roles.management') --}}
                </h4>
            </div><!--col-->
        </div><!--row-->

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped table-hover datatable">
                        <thead>
                        <tr>
                            <th>วันที่อนุมัติ <!--@lang('labels.backend.access.roles.table.role')--></th>
                            <th>เลขที่ <!--@lang('labels.backend.access.roles.table.permissions')--></th>
                            <th>Item NO. <!--@lang('labels.backend.access.roles.table.permissions')--></th>
                            <th>จำนวน <!--@lang('labels.backend.access.roles.table.permissions')--></th>
                            <th>ราคาต่อหน่วย <!--@lang('labels.backend.access.roles.table.permissions')--></th>
                            <th>รวม <!--@lang('labels.backend.access.roles.table.permissions')--></th>
                            <th>Option <!--@lang('labels.general.actions')--></th>
                        </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>xx/xx/xxxx</td>
                                <td>xxxxxxxxx</td>
                                <td>xxxxxxxxx</td>
                                <td>xxxx</td>
                                <td>xxx.xx</td>
                                <td>xxxxx.xx</td>
                                <td>
                                    <div class="btn-group btn-group-sm" role="group" >
                                        <a href="{{ route('admin.orderreport.create') }}" class="btn btn-primary" data-toggle="tooltip" data-placement="top" title="รายละเอียด">
                                            <i class="fas fa-edit">รายละเอียด</i>
                                        </a>
                                      
                                    </div></td>
                            </tr>
                            {{-- @foreach($roles as $role)
                                <tr>
                                    <td>{{ ucwords($role->name) }}</td>
                                    <td>
                                        @if($role->id === 1)
                                            @lang('labels.general.all')
                                        @else
                                            @if($role->permissions->count())
                                                @foreach($role->permissions as $permission)
                                                    {{ ucwords($permission->name) }}
                                                @endforeach
                                            @else
                                                @lang('labels.general.none')
                                            @endif
                                        @endif
                                    </td>
                                    <td>{{ $role->users->count() }}</td>
                                    <td>@include('backend.auth.role.includes.actions', ['role' => $role])</td>
                                </tr>
                            @endforeach --}}
                        </tbody>
                    </table>
                </div>
            </div><!--col-->
        </div><!--row-->
        <div class="row">
            <div class="col-7">
                <div class="float-left">
                    {{-- {!! $roles->total() !!} {{ trans_choice('labels.backend.access.roles.table.total', $roles->total()) }} --}}
                </div>
            </div><!--col-->

            <div class="col-5">
                <div class="float-right">
                    {{-- {!! $roles->render() !!} --}}
                </div>
            </div><!--col-->
        </div><!--row-->
    </div><!--card-body-->
</div><!--card-->

@endsection

@section('styles')
<link href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css" rel="stylesheet" />
@endsection

@section('scripts')
<script>
    $(document).ready(function() {


        $('#datatable').DataTable( {
            // "processing": true,
            // "serverSide": true,
            pageLength: 10,
            "ajax": {
                url : "{{url('')}}/admin/scanforbleachingjobsGetData",
                data:{location:3} ,
                },
            "columns": [
                { data: 'XVOrderBCode' },
                { data: 'XVOrderDocNo' },
                { data: 'XVOrderBSize' },
                { data: 'XVOrderBSize' },
            ]
        } );
    })
</script>
  @section('scripts')
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@9"></script>
  <script>
        $(document).ready(function() {

            $('.datatable:not(.ajaxTable)').DataTable({
                "pageLength": 25
            })

        })
  </script>
  @endsection
@endsection



