@extends('layouts.admin')

@section('title', 'หน้าจอแบบทรง | แก้ไข')

@section('content')

@php
if ($order['order_hd']->XDOrderDateApprove){
    $approveDate = date_format(date_create($order['order_hd']->XDOrderDateApprove),"d/m/Y");
}else{
    $approveDate="";
}

@endphp
<form action="{{ route("admin.order.update", [$order['XVOrderDocNo']]) }}" method="POST" enctype="multipart/form-data">
      @csrf
      @method('PUT')

      <input name="XCStatus" type="hidden" value="{{ $order['order_hd']->XCStatus}}">
      <input name="XDOrderDateApprove" type="hidden" value="{{ $approveDate }}">

      <div class="card">
        <div class="card-header">
            {{ trans('global.edit') }} {{ trans('global.Torder_hd.title') }}
        </div>
        <div class="card-body">
      </div>


      <div class="row justify-content-center">

                <div class="col-lg-3">

                    <div class="form-group col-sm-12">
                      <label class="label-bold" for="XVOrderDocNo">เลขที่เอกสาร</label>
                        <input required="required" class="col-sm-12 form-control font-size text-center" type="text" name="XVOrderDocNo" id="XVOrderDocNo" value="{{ old('XVOrderDocNo', isset($order) ? $order['XVOrderDocNo'] : 'Autoid') }}" disabled="" style="font-size: 16px;">
                    </div>

                    <div class="form-group col-sm-12">
                      <label class="label-bold" for="XVOrderMItemNo">Item No :</label> <sub class="text-danger">&nbsp;&nbsp;&nbsp;*</sub>
                      <input required="required" class="col-sm-12 form-control font-size text-center" type="text" name="XVOrderMItemNo" id="XVOrderMItemNo" value="{{ old('XVOrderMItemNo', isset($order['order_hd']) ? $order['order_hd']->XVOrderMItemNo : '') }}" placeholder="Item No" style="font-size: 16px;" required>
                    </div>

                    <div class="form-group col-sm-12">
                      <label class="label-bold" for="XIGuestCode">ชื่อลูกค้า :</label>
                      <select id="XIGuestCode" name="XIGuestCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;">
                        @foreach ($order['customer'] as $customer)
                          <option value="{{ $customer->XIGuestCode }}" {{ old('XIGuestCode', (isset($order['order_hd']) && $order['order_hd']->XIGuestCode == $customer->XIGuestCode) ? 'selected' : '') }}>{{ $customer->XVGuestName }} </option>
                        @endforeach
                      </select>
                    </div>

                    <div class="form-group col-sm-12">
                      <label class="label-bold" for="XIGenerateCode">แบบงาน :</label>
                      <select id="XIGenerateCode" name="XIGenerateCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;">
                        @foreach ($order['forms'] as $forms)
                          <option value="{{ $forms->XIGenerateCode }}" {{ old('XIGenerateCode', (isset($order['order_hd']) && $order['order_hd']->XIGenerateCode == $forms->XIGenerateCode) ? 'selected' : '') }}>{{ $forms->XVGenerateName }} </option>
                        @endforeach
                      </select>
                    </div>

                    <div class="form-group col-sm-12">
                      <label class="label-bold" for="XISewCode">สถานที่เย็บหน้า หลัง :</label>
                      <select id="XISewCode" name="XISewCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;">
                        @foreach ($order['sews'] as $sews)
                          <option value="{{ $sews->XISewCode }}" {{ old('XISewCode', (isset($order['order_hd']) && $order['order_hd']->XISewCode == $sews->XISewCode) ? 'selected' : '') }}>{{ $sews->XVSewName }} </option>
                        @endforeach
                      </select>
                    </div>

                    <div class="form-group col-sm-12">
                      <label class="label-bold" for="XIBlenchCode">สถานทฟอก :</label>
                      <select id="XIAddBlenchCode" name="XIAddBlenchCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;">
                        @foreach ($order['blenchs'] as $blenchs)
                          <option value="{{ $blenchs->XIBlenchCode }}" {{ old('XIBlenchCode', (isset($order['order_hd']) && $order['order_hd']->XIAddBlenchCode == $blenchs->XIBlenchCode) ? 'selected' : '') }}>{{ $blenchs->XVBlenchName }} </option>
                        @endforeach
                      </select>
                    </div>

                </div>

                <!-- <div class="col-lg-1"></div> -->
                <div class="col-lg-3">

                  <div class="form-group col-sm-12">
                    <label class="label-bold" for="Workat">วันที่สร้างเอกสาร :</label>
                    <div class="end_date input-group mb-4">
                      <input class="form-control end_date" type="text" placeholder="วัน/เดือน/ปี" data-date-format="dd/mm/yyyy" value="{{ old('XDOrderDocMDate', isset($order['order_hd']) ? $order['order_hd']->XDOrderDocMDate : '') }}" name="XDOrderDocMDate" id="eratedate_datepicker" required="required">
                      <div class="input-group-append">
                        <span class="fa fa-calendar input-group-text end_date_calendar" aria-hidden="true "></span>
                      </div>
                    </div>
                  </div>

                  <div class="form-group col-sm-12">
                    <label class="label-bold" for="XVOrderMSeasion">Season :</label>
                    <input required="required" class="col-sm-12 form-control font-size" type="text" name="XVOrderMSeasion" id="XVOrderMSeasion" value="{{ old('XVOrderMSeasion', isset($order['order_hd']) ? $order['order_hd']->XVOrderMSeasion : '') }}"   placeholder="Season" style="font-size: 16px;">
                  </div>

                  <div class="form-group col-sm-12">
                    <label class="label-bold" for="XIForCode">สำหรับ :</label>
                    <select id="XIForCode" name="XIForCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;">
                      @foreach ($order['foruse'] as $foruse)
                        <option value="{{ $foruse->XIForCode }}" {{ old('XIForCode', (isset($order['order_hd']) && $order['order_hd']->XIForCode == $foruse->XIForCode) ? 'selected' : '') }}>{{ $foruse->XVForType }} </option>
                      @endforeach
                    </select>
                  </div>

                  <div class="form-group col-sm-12">
                    <label class="label-bold" for="XIShapeCode">ทรง :</label>
                    <select id="XIShapeCode" name="XIShapeCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;">
                      @foreach ($order['shape'] as $shape)
                        <option value="{{ $shape->XIShapeCode }}" {{ old('XIShapeCode', (isset($order['order_hd']) && $order['order_hd']->XIShapeCode == $shape->XIShapeCode) ? 'selected' : '') }}>{{ $shape->XVShapeName }} </option>
                      @endforeach
                    </select>
                  </div>

                  <div class="form-group col-sm-12">
                    <label class="label-bold" for="XITotalSewCode">สถานที่เย็บ รวมตัว :</label>
                    <select id="XITotalSewCode" name="XITotalSewCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;">
                      @foreach ($order['totalsews'] as $totalsews)
                        <option value="{{ $totalsews->XITotalSewCode }}" {{ old('XITotalSewCode', (isset($order['order_hd']) && $order['order_hd']->XITotalSewCode == $totalsews->XITotalSewCode) ? 'selected' : '') }}>{{ $totalsews->XVTotalSewName }} </option>
                      @endforeach
                    </select>
                  </div>

                </div>

                <div class="col-lg-5">
                  <div class="card">
                      <div class="card-header">
                          จำนวนที่สั่ง
                      </div>

                      <div class="card-body">

                      <div class="row mt-1">

                          <div class="input-group mb-3 col-sm-12">
                          <label class="label-bold" for="Workat">Size :</label>
                          </div>

                          <div class="input-group mb-3 col-sm-12">
                            <select type="number" class="col-sm-4 font-size" id="XVOrderDSize" style="font-size: 16px;" required="required" >
                              @foreach ($order['sizes'] as $size)
                                  <option value="{{ $size->size_id }}">{{ $size->size_name }} </option>
                              @endforeach
                            </select>
                            <input type="number" id="XIOrderDNum" class="form-control" placeholder="จำนวนสั่งผลิต" size="10" min="1" max="1000" >
                            <div class="input-group-append">
                              <button id="add-row" class="btn btn-success active" type="button" {{ ($order['order_hd']->XCStatus != "1" ? 'disabled':'')}}   >{{ trans('global.add') }}</button>
                            </div>
                          </div>

                          <div class="col">
                              <div class="table-responsive">
                                  <table id="Orderlist" class="table table-bordered table-striped table-hover datatable">
                                      <thead>
                                          <tr>
                                              <th width="33%">Size</th>
                                              <th width="33%">จำนวน</th>
                                              <th width="33%">Option</th>
                                          </tr>
                                      </thead>
                                      <tbody>

                                        @php
                                            $row = 0;
                                        @endphp
                                      @foreach ($order['order_dt'] as $key =>$order_dt)

                                      <tr id="r<?php print $row?>">
                                        <input type="hidden" value="{{ old('XVOrderDSize', isset($order_dt) ? $order_dt['XVOrderDSize'] : '') }}" name="XVOrderDSize[]">
                                        <input type="hidden" value="{{ old('XIOrderDNum', isset($order_dt) ? $order_dt['XIOrderDNum'] : '') }}" name="XIOrderDNum[]">

                                        <td>{{ old('XVOrderDSize', isset($order_dt) ? $order_dt['XVOrderDSize'] : '') }}</td>
                                        <td>{{ old('XIOrderDNum', isset($order_dt) ? $order_dt['XIOrderDNum'] : '') }}</td>
                                        <td class="text-center" ><button class="btn btn-danger" type="button" onclick="Rremoverow('<?php print $row?>')" {{ ($order['order_hd']->XCStatus != "1" ? 'disabled':'')}} >ลบ</button></td>
                                      </tr>
                                        @php
                                            $row++;
                                        @endphp
                                      @endforeach


                                      </tbody>
                                  </table>
                              </div>
                          </div><!--col-->
                      </div><!--row-->

                      </div>

                  <div class="card-footer">
                      <div class="row">
                      </div>
                  </div>

                 </div>
              </div>
      </div>

      <div class="card-footer">
          <div class="row">
              <div class="col">
                <a href="{{route('admin.order.index')}}" class="btn btn-danger active" role="button" aria-pressed="true">{{ trans('global.back') }}</a>
              </div>

              <div class="col text-right">
                <input class="btn btn-success active" type="submit" value="{{ trans('global.save') }}">
              </div>
          </div>
      </div>

    </div>

</form>

<script type="text/javascript">
  var i = <?php print $row?>;
    $("#eratedate_datepicker").datepicker()
    $("#add-row").click(function(){
    bReturn = false;

    if ($("#XIOrderDNum").val() == 0){
        Swal.fire({
                icon:  'error',
                title: 'แจ้งเตือน',
                text:  'โปรดใส่จำนวนสั่งผลิต !',
                })
                bReturn = true;
    }
    if (bReturn) return false;

    $("input[name='XVOrderDSize[]']" ).each(function(){
        if ($(this).val() ==$('#XVOrderDSize').val()){
            Swal.fire({
                icon:  'error',
                title: 'แจ้งเตือน',
                text:  'มี Size  '+ $(this).val() +' นี้อยู่แล้วกรุณาตรวจสอบ !',
            })
            bReturn = true;
        }
    });
    if (bReturn) return false;

      i++;
      $('#Orderlist').append('<tr id=r'+i+'> <td><input type="hidden" value="'+$('#XVOrderDSize').val()+'" name="XVOrderDSize[]">'+$('#XVOrderDSize').val()+'</td> <td><input type="hidden" value="'+$('#XIOrderDNum').val()+'" name="XIOrderDNum[]">'+$('#XIOrderDNum').val()+'</td> <td class="text-center"><button onclick="Rremoverow('+i+')" class="btn btn-danger" type="button">ลบ</button></td> </tr>');
      $("#XIOrderDNum").val("");

  });

  function Rremoverow(i)
  {
    console.log(i);
    $('#r'+i).remove();
  }
</script>
@endsection
