@extends('layouts.admin')

@section('title', env('APP_NAME') . ' | ตรวจรับการจจัดส่ง')

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    ตรวจรับการจจัดส่ง
                </h4>
            </div><!--col-->
        </div><!--row-->

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive " >
                    <table class="table display" id="datatable"  style="width:100%">
                        <thead>
                        <tr>
                            <th>ลำดับ</th>
                            <th>วันที่</th>
                            <th>ทะเบียนรถ</th>
                            <th>รหัส Barcode กล่อง</th>
                            <th>จำนวนสินค้า</th>
                            <th>รายละเอียด</th>
                            <th>สถานะ</th>
                        </tr>
                        </thead>

                    </table>

                </div>
            </div><!--col-->
        </div><!--row-->
        <div class="row">
            <div class="col-7">
                <div class="float-left">
                    {{-- {!! $roles->total() !!} {{ trans_choice('labels.backend.access.roles.table.total', $roles->total()) }} --}}
                </div>
            </div><!--col-->

            <div class="col-5">
                <div class="float-right">
                    {{-- {!! $roles->render() !!} --}}
                </div>
            </div><!--col-->
        </div><!--row-->
    </div><!--card-body-->
</div><!--card-->
@endsection

    @section('styles')
    <link href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css" rel="stylesheet" />
    @endsection
    @section('scripts')
    <script>
       $(document).ready(function() {
            var url = "{{route('admin.reportdeliveryacc.create')}}";
            var t =$('#datatable').DataTable({
                "processing": true,
                "serverSide": true,
                pageLength: 10,
                "ajax": {
                    url : "{{url('')}}/admin/reportdeliveryGetData",
                    data:{_token: "{{csrf_token()}}",location:10} ,
                    dataType: "json",
                    type: "POST",
                    },
                "columns": [
                    { defaultContent:'' },
                    { data: 'XDDateInSend' },
                    { data: 'XVCarCode' },
                    { data: 'XVBoxCode' },
                    { data: 'XICountAll' },
                    { "defaultContent": "<button type='button' href="+url+" class='btn btn-success'>รายละเอียด</button>" },
                    { data: 'XCStatusSend' },
                ],
                "order": [[ 1, 'asc' ]]
            });

            t.on( 'order.dt search.dt', function () {
            t.column(0, {search:'applied', order:'applied'}).nodes().each( function (cell, i) {
                cell.innerHTML = i+1;
            } );
        } ).draw();

            $('#datatable tbody').on( 'click', 'button', function () {
                var cells = $(this).closest("tr").children("td");
                var carCode = cells.eq(2).text();
                var boxCode = cells.eq(3).text();

                 window.location.href = '{{url("admin/reportdeliveryDetail")}}/'+carCode+'/'+boxCode
            } );
        })
    </script>
    @endsection

{{-- group order size --}}
